/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.symbol;

import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import devmgr.v0910api01.symbol.BatteryStatus;
import devmgr.v0910api01.symbol.BatteryTypeData;
import devmgr.v0910api01.symbol.ComponentRef;
import devmgr.v0910api01.symbol.Location;
import devmgr.v0910api01.symbol.SYMbolAPIConstants;

public class Battery
implements XDRType,
SYMbolAPIConstants {
    private ComponentRef batteryRef = new ComponentRef();
    private BatteryStatus status = new BatteryStatus();
    private Location physicalLocation = new Location();
    private int batteryAge;
    private int batteryLifeRemaining;
    private BatteryTypeData batteryTypeData = new BatteryTypeData();
    private byte[] reserved1;
    private byte[] reserved2;

    public Battery() {
    }

    public Battery(Battery battery) {
        this.batteryRef = battery.batteryRef;
        this.status = battery.status;
        this.physicalLocation = battery.physicalLocation;
        this.batteryAge = battery.batteryAge;
        this.batteryLifeRemaining = battery.batteryLifeRemaining;
        this.batteryTypeData = battery.batteryTypeData;
        this.reserved1 = battery.reserved1;
        this.reserved2 = battery.reserved2;
    }

    public int getBatteryAge() {
        return this.batteryAge;
    }

    public int getBatteryLifeRemaining() {
        return this.batteryLifeRemaining;
    }

    public ComponentRef getBatteryRef() {
        return this.batteryRef;
    }

    public BatteryTypeData getBatteryTypeData() {
        return this.batteryTypeData;
    }

    public Location getPhysicalLocation() {
        return this.physicalLocation;
    }

    public byte[] getReserved1() {
        return this.reserved1;
    }

    public byte[] getReserved2() {
        return this.reserved2;
    }

    public BatteryStatus getStatus() {
        return this.status;
    }

    public void setBatteryAge(int n) {
        this.batteryAge = n;
    }

    public void setBatteryLifeRemaining(int n) {
        this.batteryLifeRemaining = n;
    }

    public void setBatteryRef(ComponentRef componentRef) {
        this.batteryRef = componentRef;
    }

    public void setBatteryTypeData(BatteryTypeData batteryTypeData) {
        this.batteryTypeData = batteryTypeData;
    }

    public void setPhysicalLocation(Location location) {
        this.physicalLocation = location;
    }

    public void setReserved1(byte[] byArray) {
        this.reserved1 = byArray;
    }

    public void setReserved2(byte[] byArray) {
        this.reserved2 = byArray;
    }

    public void setStatus(BatteryStatus batteryStatus) {
        this.status = batteryStatus;
    }

    public void xdrDecode(XDRInputStream xDRInputStream) throws RPCError {
        int n = xDRInputStream.getInt() + xDRInputStream.getPosition();
        if (xDRInputStream.getPosition() < n) {
            this.batteryRef.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.status.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.physicalLocation.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryAge = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryLifeRemaining = xDRInputStream.getInt();
        }
        if (xDRInputStream.getPosition() < n) {
            this.batteryTypeData.xdrDecode(xDRInputStream);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved1 = xDRInputStream.getFixedOpaque(8);
        }
        if (xDRInputStream.getPosition() < n) {
            this.reserved2 = xDRInputStream.getVariableOpaque();
        }
        xDRInputStream.skip(n - xDRInputStream.getPosition());
    }

    public void xdrEncode(XDROutputStream xDROutputStream) throws RPCError {
        int n = xDROutputStream.prepareLength();
        this.batteryRef.xdrEncode(xDROutputStream);
        this.status.xdrEncode(xDROutputStream);
        this.physicalLocation.xdrEncode(xDROutputStream);
        xDROutputStream.putInt(this.batteryAge);
        xDROutputStream.putInt(this.batteryLifeRemaining);
        this.batteryTypeData.xdrEncode(xDROutputStream);
        xDROutputStream.putFixedOpaque(this.reserved1, 8);
        xDROutputStream.putVariableOpaque(this.reserved2);
        xDROutputStream.setLength(n);
    }
}

