/*
 * Decompiled with CFR 0.152.
 */
package devmgr.v0910api01.jrpc;

import devmgr.trace.Trace;
import devmgr.v0910api01.jrpc.RPCAuthGenerator;
import devmgr.v0910api01.jrpc.RPCDebug;
import devmgr.v0910api01.jrpc.RPCError;
import devmgr.v0910api01.jrpc.RPCMsg;
import devmgr.v0910api01.jrpc.RPCNullAuthGenerator;
import devmgr.v0910api01.jrpc.RPCOpaqueAuth;
import devmgr.v0910api01.jrpc.XDRInputStream;
import devmgr.v0910api01.jrpc.XDRMessageIOV;
import devmgr.v0910api01.jrpc.XDROutputStream;
import devmgr.v0910api01.jrpc.XDRType;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;

public abstract class RPCClientGeneric {
    private static final int CLIENT_AUTH_OFFSET = 24;
    private int m_Program;
    private int m_Version;
    private int m_NextXid;
    private RPCAuthGenerator m_AuthGenerator;
    private RPCOpaqueAuth m_NullVerifier;

    public RPCClientGeneric(int n, int n2) {
        this.m_Program = n;
        this.m_Version = n2;
        this.m_NextXid = (int)(new Date().getTime() / 1000L);
        this.m_AuthGenerator = new RPCNullAuthGenerator();
        this.m_NullVerifier = new RPCOpaqueAuth();
        this.m_NullVerifier.getType().setValue(0);
        this.m_NullVerifier.setInfo(new byte[0]);
    }

    protected XDRMessageIOV buildRequestMsg(int n, int n2, XDRType xDRType) throws RPCError {
        XDRMessageIOV xDRMessageIOV = null;
        XDROutputStream xDROutputStream = new XDROutputStream();
        RPCMsg rPCMsg = new RPCMsg();
        RPCOpaqueAuth rPCOpaqueAuth = null;
        RPCOpaqueAuth rPCOpaqueAuth2 = null;
        rPCMsg.setXid(n2);
        rPCMsg.getBody().getMsgType().setValue(0);
        rPCMsg.getBody().getCallMsg().setRpcVersion(2);
        rPCMsg.getBody().getCallMsg().setProgramNo(this.m_Program);
        rPCMsg.getBody().getCallMsg().setVersionNo(this.m_Version);
        rPCMsg.getBody().getCallMsg().setProcedure(n);
        rPCMsg.getBody().getCallMsg().setVerifier(this.m_NullVerifier);
        rPCOpaqueAuth = this.m_AuthGenerator.getInitialAuthData();
        rPCMsg.getBody().getCallMsg().setCredential(rPCOpaqueAuth);
        rPCMsg.xdrEncode(xDROutputStream);
        xDRType.xdrEncode(xDROutputStream);
        xDRMessageIOV = xDROutputStream.getMessage();
        rPCOpaqueAuth2 = this.m_AuthGenerator.getFinalAuthData(rPCOpaqueAuth, xDRMessageIOV);
        xDROutputStream.setPosition(24);
        rPCOpaqueAuth2.xdrEncode(xDROutputStream);
        Trace.printf(4, "Sending call message; xid=%d, proc=%d size=%d\n", new Integer(n2), new Integer(n), new Integer(xDRMessageIOV.getMessageSize()));
        if (Trace.isTracing(6)) {
            RPCDebug.dumpIOV(6, xDRMessageIOV);
        }
        return xDRMessageIOV;
    }

    public synchronized void call(int n, XDRType xDRType, XDRType xDRType2) throws RPCError, IOException {
        int n2 = this.getNextXid();
        XDRMessageIOV xDRMessageIOV = null;
        XDRMessageIOV xDRMessageIOV2 = null;
        xDRMessageIOV = this.buildRequestMsg(n, n2, xDRType);
        xDRMessageIOV2 = this.transact(xDRMessageIOV, n2);
        this.processReplyMsg(xDRMessageIOV2, n2, xDRType2);
    }

    public abstract void close() throws IOException;

    public abstract InetAddress getDestinationIP();

    public abstract InetAddress getLocalAddress();

    protected synchronized int getNextXid() {
        return this.m_NextXid++;
    }

    protected void processReplyMsg(XDRMessageIOV xDRMessageIOV, int n, XDRType xDRType) throws RPCError {
        XDRInputStream xDRInputStream = null;
        RPCMsg rPCMsg = new RPCMsg();
        Trace.printf(4, "Processing reply message for xid=%d size=%d \n", new Integer(n), new Integer(xDRMessageIOV.getMessageSize()));
        if (Trace.isTracing(5)) {
            RPCDebug.dumpIOV(5, xDRMessageIOV);
        }
        xDRInputStream = new XDRInputStream(xDRMessageIOV);
        rPCMsg.xdrDecode(xDRInputStream);
        if (rPCMsg.getXid() != n || rPCMsg.getBody().getMsgType().getValue() != 1) {
            throw new RPCError("PROTOCOL_ERROR");
        }
        if (rPCMsg.getBody().getReplyMsg().getStatus().getValue() != 0) {
            throw new RPCError("REQUEST_REJECTED");
        }
        if (rPCMsg.getBody().getReplyMsg().getAcceptedReply().getVerifier().getType().getValue() != 0) {
            throw new RPCError("BAD_VERIFIER");
        }
        switch (rPCMsg.getBody().getReplyMsg().getAcceptedReply().getBody().getStatus().getValue()) {
            case 1: {
                throw new RPCError("PROG_UNAVAILABLE");
            }
            case 2: {
                throw new RPCError("PROG_MISMATCH");
            }
            case 3: {
                throw new RPCError("PROC_UNAVAILABLE");
            }
            case 4: {
                throw new RPCError("ARGS_REJECTED");
            }
            default: {
                throw new RPCError("SYSTEM_ERROR");
            }
            case 0: 
        }
        xDRType.xdrDecode(xDRInputStream);
    }

    synchronized void setAuthGenerator(RPCAuthGenerator rPCAuthGenerator) {
        this.m_AuthGenerator = rPCAuthGenerator;
    }

    public abstract void setTimeout(int var1) throws IOException;

    public abstract XDRMessageIOV transact(XDRMessageIOV var1, int var2) throws RPCError, IOException;
}

