       IDENTIFICATION DIVISION.
       PROGRAM-ID. IKJEFT01.
      *---------------------------------------------------------------*
      *                                                               |
      * THIS PROGRAM IS PROVIDED AS A SAMPLE TO SIMULATE TSO CLIST    |
      * COMMANDS.                                                     |
      *                                                               |
      * TO UTILIZE:                                                   |
      *                                                               |
      *   1). COMPILE THIS PROGRAM                                    |
      *   2). COMMENT OR DELETE LINE IKJEFT01 IN $PUBLIC/MVS.CONF     |
      *   3). SHELL SCRIPT MUST EXIST FOR EACH FUNCTION IN $PUBLIC/BIN|
      *                                                               |
      *---------------------------------------------------------------*
       AUTHOR. UKT.
       ENVIRONMENT DIVISION.
      
       INPUT-OUTPUT  SECTION.
       FILE-CONTROL.
      
           SELECT SYSTSIN ASSIGN TO UT-S-SYSTSIN
               ORGANIZATION IS LINE SEQUENTIAL
               FILE STATUS IS SYSTSIN-STATUS.
      
       DATA DIVISION.
       FILE SECTION.
      
       FD  SYSTSIN
           RECORDING MODE IS F.
       01  SYSTSIN-RECORD          PIC X(80).
      
       WORKING-STORAGE SECTION.
      
       01  WS-SYSTSIN-RECORD       PIC X(80).
      
       01  SYSTSIN-STATUS          PIC X(02).
           88  SYSTSIN-NORMAL                    VALUE '00'.
           88  SYSTSIN-EOF                       VALUE '10'.
      
       01  WS-FUNCTION             PIC X(05).
      
      
       PROCEDURE DIVISION.
      
       MAIN.
      
           OPEN INPUT SYSTSIN.
           IF NOT SYSTSIN-NORMAL
                MOVE 'OPEN'            TO WS-FUNCTION
                PERFORM ABEND          THRU ABEND-EXIT
           END-IF.
           PERFORM READ-CLIST THRU READ-CLIST-EXIT UNTIL SYSTSIN-EOF.
           CLOSE SYSTSIN.
      
       MAIN-EXIT.
           GOBACK.
      
       READ-CLIST.
      
           READ SYSTSIN INTO WS-SYSTSIN-RECORD END-READ.
      
           EVALUATE TRUE
               WHEN SYSTSIN-NORMAL
                   DISPLAY 'IKJEFT01 - INPUT = ' WS-SYSTSIN-RECORD
                   PERFORM CALL-SYSTEM THRU CALL-SYSTEM-EXIT
               WHEN NOT SYSTSIN-EOF
                   MOVE 'READ'         TO WS-FUNCTION
                   PERFORM ABEND       THRU ABEND-EXIT
           END-EVALUATE.
      
       READ-CLIST-EXIT.
      
       CALL-SYSTEM.
      
           CALL "SYSTEM" USING WS-SYSTSIN-RECORD.
           IF RETURN-CODE NOT = ZERO
               DISPLAY 'IKJEFT01 - RETURN-CODE = ' RETURN-CODE
               PERFORM ABEND-TWO       THRU ABEND-EXIT
           END-IF.
      
       CALL-SYSTEM-EXIT.
      
       ABEND.
      
           DISPLAY 'IKJEFT01 - SYSTSIN ' WS-FUNCTION ' STATUS = '
                   SYSTSIN-STATUS.
      
       ABEND-TWO.
      
           DISPLAY ' '.
           DISPLAY 'IKJEFT01 - ABNORMAL TERMINATION'.
      
           CALL "ABENDING".
      
       ABEND-EXIT.
            EXIT.

