#!/bin/ksh
echo "*******************************************************************************"
echo "*                                                                             *"
echo "*                     W E L C O M E   T O   B A T C H                         *"
echo "*                                                                             *"
echo "*******************************************************************************"
if  echo "\c" | grep c >$DEVNULL 2>&1; then    
    N='-n'
else
    C='\c'
fi
export N C
batchelp -v | cut -f2 -d':' | cut -f1 -d','
SUBSYSLIST=/tmp/subsyslist.$$;export SUBSYSLIST
rm -f $SUBSYSLIST
touch $SUBSYSLIST

ls -C1 $EBMHOME/bam/subsys 2>$DEVNULL | while read subsysname
do
if [ ! -f $EBMHOME/bam/subsys/$subsysname/.deactiv ]
then
  if [ -f $EBMHOME/bam/subsys/$subsysname/Setup ]
  then
    echo " -    $subsysname" >> $SUBSYSLIST
  fi
fi  
done

if [ -s $SUBSYSLIST ]
then
  echo "" 
  echo "Subsystem Environments available:" 
  echo "" 
  cat $SUBSYSLIST
  echo "" 
  echo $N "Enter Subsystem Name ( Return for none ) : $C"
  read risp
  case $risp in
    "") ;;
    *) grep $risp $SUBSYSLIST > $DEVNULL 2>&1
       if [ $? -ne 0 ]
       then
         echo "ERROR. $risp: invalid Subsystem Name"
       else
         . $EBMHOME/batchenv $risp
         if [ ! -z "$JCLLIB" ]
         then
           cd $JCLLIB/..
           case "$EBM_OS_NAME" in
             NT) 
                 if [ ! -d /tmp ]
                 then
                   mkdir /tmp
                   chmod 777 /tmp
                 fi
                 ;;
              *) ;;
           esac
         fi      
       fi
  esac
fi
rm -f $SUBSYSLIST
echo "Working (Current) Directory: `pwd`"
case "$EBM_OS_NAME" in
  NT) sh.exe ;;
   *) ksh ;;
esac
exit 0
