
/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2001 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/



/* $Date:   09 Jun 2005 11:03:46  $ */
/* $Modtime:   09 Jun 2005 11:04:44  $ */

#ifndef	lint
#ifdef __STDC__
const
#endif
static char sccsid[] = "@(#) $Workfile:   runfs.c  $ $Revision:   1.2.1.1  $";
#endif

/*
 * $Log:   /home/kw134160/pvcslinks/MBM10.1.0/unikixebm/ebmsrc/rtsfs/PVCS/runfs.c_v  $
 * 
 *    Rev 1.2.1.1   09 Jun 2005 11:03:46   kw134160
 * B6267835
 * Rework to include non-STDC prototype for rtsfs_cobsw missed in first fix.
 * 
 *    Rev 1.2.1.0   20 May 2005 11:02:16   kw134160
 * B6267835
 * Put in missing #include lines and function prototypes to avoid compiler warnings during non-VSAM subsystem builds.
 * 
 *    Rev 1.2   01 Oct 2003 14:17:10   gr134150
 * B4927839
 * support of COBOL animator for MBM HA
 * 
 *    Rev 1.1   27 Mar 2002 14:31:54   gr134150
 * B4657073
 * National Language Common Message Catalog Support
 * 
 *    Rev 1.0   18 Sep 2001 13:54:08   unikix
 * Initial 9.2
 * 
 *    Rev 1.1   08 Mar 2001 16:07:46   giulio
 * B7608
 * postponed the rdbms allocate action until the terminal redirection is executed.
 * 
 *    Rev 1.0   31 Jan 2000 15:35:00   unikix
 * Initial 9.0
 * 
 *    Rev 1.3   12/12/97 14:50:02   giulio
 * 2675
 * 
 *    Rev 1.2   10/24/96 11:46:38   giulio
 * B001734
 * runfs.c (like runner.c) uses the unikixcom/src/usrsrc user exit functions
 * those functions are shared with the TRANS usr exit calls.
 * runfs.c now checks if the allocate function failed, if yes the program aborts.
 * 
 *    Rev 1.1   10/03/96 09:36:28   giulio
 * B001783
 * runfs_stop receives now one more parameter the cond code passed to the
 * CCF_SET_CONDCODE function from the COBOL program.
 * runfs_stop does not rollback anymore if return code if <0 or >4095
 * runfs_stop rollback now if cond code passed is not 0.
 * The messages showing commit and rollback are changed.
 * The message showing the return-code is changed to show also the condcode.
 * 
 *    Rev 1.0   08/16/96 15:02:04   unikix
 * Initial EBM8.1.0.0
 * 
 */
/**********************************************************************/

# include  <stdio.h>
# include  <fcntl.h>
# include  <errno.h>
# include  <sys/types.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

#define MAX_APPL_LENGTH 8
#define RTS_MSG_SET 6
extern char *kxcatgets();
char rts_rdbms[ MAX_APPL_LENGTH + 1 ];

extern FILE *fdbug;
int     rts_debug;    
char    rtsfs_xtermdev[30];
static int      rtsfs_savefd[3];
static char     rtsfs_hstr[80] = "";

/* function prototypes */
extern int fsuser_allocate();
extern int fsuser_deallocate();
extern int fsuser_commit();
extern int fsuser_rollback();
void ebmcobexit();

#ifdef __STDC__
int rtsfs_cobsw(int pdebug);
void rtsfs_animate(int pcmd);
void rtsfs_reopena(int pfildes,  char* pttyname, int paccess);
void rtsfs_reopenm(int pfildes);
int runfs_stop(short retcode,short ccode);
#else
int rtsfs_cobsw();
void rtsfs_animate();
void rtsfs_reopena();
void rtsfs_reopenm();
int runfs_stop();
#endif


int 
#ifdef __STDC__
rtsfs_cobsw(int pdebug)
#else
rtsfs_cobsw(pdebug)
int pdebug;
#endif
{
    char    *lenv;      /*environment value for COBSW*/
    int     lrc;
    int     lcurlen;
    int     i, k;
    char    *lcp;
    char    lstr[80];

    lenv = (char*)getenv("COBSW");
    if (lenv == NULL) {
	if (pdebug) {
		strcpy(rtsfs_hstr, "COBSW=+A");
		lrc = putenv(rtsfs_hstr);
		return(lrc);
	}
    } else {
        if((lcp=(char*)strchr(lenv,'A'))==NULL) {
            if (pdebug) {
		    strcpy(lstr, "COBSW=");
		    strcat(lstr, lenv);     
		    strcat(lstr, "+A");    
		    strcpy(rtsfs_hstr, lstr);
		    lrc = putenv(rtsfs_hstr);
		    return(lrc);
            }
        } else {
            strcpy(lstr, "COBSW=");
            k = strlen(lenv);
            lcurlen = strlen(lstr);
            for (i = 0; i < k; i++) {
		    if (lenv [i + 1] == 'A') {
			    i++;
		    } else {
			    lstr[lcurlen] = lenv[i];
			    lcurlen++;
		    }
            }
	    lstr[lcurlen] = '\0';
            if (pdebug) {
		    strcat(lstr, "+A");
            }
            strcpy(rtsfs_hstr, lstr);
            lrc = putenv(rtsfs_hstr);
            return(lrc);
        }
    }
    return(0);
}



void
#ifdef __STDC__
rtsfs_animate (int pcmd)
#else
rtsfs_animate (pcmd)
int pcmd;
#endif
{
    void mbm_suspend_sun_cluster_pmf_to_animate();
    int lrc;

    if (rts_debug == 0) {
        return;
    }
    switch (pcmd) {
	    case 0: {
		rtsfs_reopenm(0);
		rtsfs_reopenm(1);
		rtsfs_reopenm(2);
		break;
	    }
	    case 1: {
                mbm_suspend_sun_cluster_pmf_to_animate();
		rtsfs_reopena(0, rtsfs_xtermdev, O_RDWR);
		rtsfs_reopena(1, rtsfs_xtermdev, O_WRONLY+O_APPEND);
		rtsfs_reopena(2, rtsfs_xtermdev, O_WRONLY);
		break;
	    }
    }
    return;
}

void
#ifdef __STDC__
rtsfs_reopena(int pfildes,  char* pttyname, int paccess)
#else
rtsfs_reopena(pfildes,  pttyname, paccess)
int pfildes;
char    *pttyname;
int paccess;
#endif
{
    int lrc;

    rtsfs_savefd [pfildes] = dup (pfildes);
    close (pfildes);
    lrc = open(pttyname, paccess, 666);
    if (lrc != pfildes) {
	    if (lrc < 0) {
		printf((kxcatgets(RTS_MSG_SET,66, "(S) rtsfs_reopena: reopen of %d failed, errno=%d\n")),
		    pfildes,errno);
	    } else {
		printf((kxcatgets(RTS_MSG_SET,67, "(S) rtsfs_reopena: reopen of %d returned %d\n")),
		    pfildes, lrc);
	    }
	    exit (-1);
    }
    return;
}

void
#ifdef __STDC__
rtsfs_reopenm(int pfildes)
#else
rtsfs_reopenm(pfildes)
int pfildes;
#endif
{
    int lrc;

    close (pfildes);
    lrc = dup (rtsfs_savefd[pfildes]);
    close (rtsfs_savefd[pfildes]);
    rtsfs_savefd[pfildes] = lrc;
    if (lrc != pfildes) {
	    if (lrc < 0) {
		printf((kxcatgets(RTS_MSG_SET,68, "(S) rtsfs_reopenm: reopen of %d failed, errno=%d\n")),
		    pfildes,errno);
	    } else {
		printf((kxcatgets(RTS_MSG_SET,69, "(S) rtsfs_reopenm: reopen of %d returned %d\n")),
		    pfildes, lrc);
	    }
	    exit (-1);
    }
return;
}

int
runfs_main ()
{
int fscode;
char *test_appl;
char *ebmanim;

        fscode = 0;
	memset(rts_rdbms,'\0',MAX_APPL_LENGTH+1);
	if((test_appl=(char *)getenv("RTS_RDBMS"))!=NULL) {
		if(strlen(test_appl) > MAX_APPL_LENGTH) {
			printf((kxcatgets(RTS_MSG_SET,70, "(S) rtsfs: %s invalid application name\n")),test_appl);
			strcpy(rts_rdbms,"NO_RDBMS");
		} else {
			strcpy(rts_rdbms,test_appl);
		}
	} else {
		strcpy(rts_rdbms,"NO_RDBMS");
	}
	if((ebmanim=(char *)getenv("EBMANIM"))!=NULL) {
		if(*ebmanim=='/') {
			rts_debug=1;
			strcpy((char *)rtsfs_xtermdev, ebmanim);
			if(fdbug!=NULL) {
					fprintf(fdbug, "rtsfs batch:xtermdev=%s ebmanim=%s\n",rtsfs_xtermdev,ebmanim);
					fflush(fdbug);
			}
		}
	}
	if(rts_debug) {
		if(fdbug!=NULL) {
				fprintf(fdbug, "starting anm on %s\n",rtsfs_xtermdev);
				fflush(fdbug);
		}
		rtsfs_cobsw(1);
		rtsfs_animate(1);
	} else {
		if(fdbug!=NULL) {
				fprintf(fdbug, "starting rtsfs_cobsw(0)\n");
				fflush(fdbug);
		}
		rtsfs_cobsw(0);
	}
        if (fscode = fsuser_allocate()) {
           printf((kxcatgets(RTS_MSG_SET,71, "(S) rtsfs: user exit allocate function returned code %d\n")),
                          fscode);
           ebmcobexit(-1);
        }
        return(0);
}

int
#ifdef __STDC__
runfs_stop(short retcode,short ccode)
#else
runfs_stop(retcode,ccode)
short retcode;
short ccode;
#endif
{
int fscode;

	if(rts_debug) {
		rtsfs_animate(0);
	}
	if (ccode != 0) {
		printf((kxcatgets(RTS_MSG_SET,72, "(I) rtsfs: RETURN-CODE=%d, COND-CODE=%d\n")), retcode, ccode);
		fsuser_rollback();
		printf((kxcatgets(RTS_MSG_SET,73, "(I) rtsfs: user exit rollback function executed\n")));
	} else {
		printf((kxcatgets(RTS_MSG_SET,74, "(I) rtsfs: RETURN-CODE=%d, COND-CODE=%d\n")), retcode, ccode);
		fsuser_commit();
		printf((kxcatgets(RTS_MSG_SET,75, "(I) rtsfs: user exit commit function executed\n")));
	}
 fscode = 0;
 if (fscode = fsuser_deallocate()) {
  printf((kxcatgets(RTS_MSG_SET,76, "(I) rtsfs: user exit deallocate function returned code %d\n")), fscode);
 }
	return(0);
}
