/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class MessageCatalog {
    private Properties catalog = null;

    public MessageCatalog(String catalogname) {
        if (!catalogname.endsWith(".properties")) {
            catalogname = catalogname + ".properties";
        }
        try {
            this.catalog = new Properties();
            File pFile = new File(System.getProperty("user.dir") + catalogname);
            if (pFile.exists()) {
                FileInputStream propFile = new FileInputStream(pFile);
                this.catalog.load(propFile);
                propFile.close();
            } else {
                int to;
                int from;
                String urlString;
                String myJar;
                JarFile jarFile;
                JarEntry je;
                String classpname;
                URL urlJar;
                String jcatalogName = catalogname;
                if (jcatalogName.charAt(0) == '/') {
                    jcatalogName = jcatalogName.substring(1);
                }
                String myClassName = this.getClass().getName();
                ClassLoader classldr = this.getClass().getClassLoader();
                if (classldr == null) {
                    System.out.println("getClassLoader returned null!!!!");
                    System.exit(0);
                }
                if ((urlJar = ClassLoader.getSystemResource(classpname = myClassName.replace('.', '/') + ".class")) == null) {
                    System.out.println("getSystemResource returned null!!!!");
                    System.exit(0);
                }
                if ((je = (jarFile = new JarFile(myJar = (urlString = urlJar.toString()).substring(from = "jar:file:".length(), to = urlString.indexOf("!/")))).getJarEntry(jcatalogName)) != null) {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        je = entries.nextElement();
                        if (jcatalogName.equalsIgnoreCase(je.getName())) break;
                        je = null;
                    }
                }
                if (je != null) {
                    InputStream is = jarFile.getInputStream(je);
                    this.catalog.load(is);
                    pFile.createNewFile();
                    FileOutputStream fos = new FileOutputStream(pFile);
                    this.catalog.store(fos, "Message Catalog");
                    fos.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + catalogname);
        }
        catch (IOException e) {
            System.out.println("Caught an I/O exception:" + e);
        }
    }

    public String getMessage(String key, Object[] parms) {
        String message = this.catalog.getProperty(key);
        return this.formatMessage(message, parms);
    }

    public synchronized String formatMessage(String msg, Object[] parms) {
        Object retString = null;
        try {
            if (parms == null || parms.length == 0) {
                return msg;
            }
            return MessageFormat.format(msg, parms);
        }
        catch (Exception ex) {
            return msg;
        }
    }
}

