/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import com.sun.emp.mbm.util.DialogHandler;
import com.sun.emp.mbm.util.MessageCatalog;
import java.awt.TextArea;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Log {
    private static LogManager mgr = LogManager.getLogManager();
    private static Logger msg = null;
    private static MessageCatalog mc = null;
    private static Logger trc = null;
    private static FileHandler traceFile = null;
    private static Logger lo = null;
    private static ArrayList arrl_filterClasses = new ArrayList();
    private static boolean closeFlag = false;
    private static boolean isLogging = false;
    private static String traceDirectory = null;
    private static String setTraceDirectory = null;
    private static Level defaultTraceLevel = Level.INFO;
    private static Properties logProperties = new Properties();
    private static String logPropertyFile = new String("/com/sun/emp/mbm/logger.properties");
    private static DialogHandler dh = null;
    private static String messageText = null;
    private static String dialogHeader = null;
    static int messageType = -1;
    private static Object[] options = new Object[]{"OK"};
    private static String buildMessageText = null;
    private static int buildMessageLines = 0;

    public static Logger getMessageLogger() {
        return msg;
    }

    public static Logger getTraceLogger() {
        return trc;
    }

    public static TextArea getTextArea() {
        return dh.getTextArea();
    }

    public static String getTraceDirectory() {
        return traceDirectory;
    }

    public static void setMessageLogger(Logger mLogger) {
        msg = mLogger;
    }

    public static void setTraceLogger(Logger tLogger) {
        trc = tLogger;
    }

    public static void setTraceDirectory(String tDir) {
        traceDirectory = tDir;
        setTraceDirectory = tDir;
    }

    public static DialogHandler getDialogHandler() {
        return dh;
    }

    public static void setFilterClasses(ArrayList arrl_fc) {
        arrl_filterClasses = arrl_fc;
    }

    public static void initializer() {
        try {
            File logProp = new File(System.getProperty("user.dir") + logPropertyFile);
            if (!logProp.exists()) {
                Log.defaultProperties(logProp);
            }
            FileInputStream propFile = new FileInputStream(logProp);
            logProperties.load(propFile);
            propFile.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + logPropertyFile);
        }
        catch (IOException e) {
            System.err.println("Caught an I/O Exception: " + e);
        }
        setTraceDirectory = traceDirectory = logProperties.getProperty("com.sun.emp.traceDirectory");
        String tracing = logProperties.getProperty("com.sun.emp.tracing", "0");
        isLogging = tracing != null ? (tracing.equalsIgnoreCase("1") ? true : tracing.equalsIgnoreCase("true")) : false;
        String traceLevel = logProperties.getProperty("com.sun.emp.traceLevel");
        if (traceLevel != null) {
            if (traceLevel.equalsIgnoreCase("Level.INFO")) {
                defaultTraceLevel = Level.INFO;
            } else if (traceLevel.equalsIgnoreCase("Level.WARNING")) {
                defaultTraceLevel = Level.WARNING;
            } else if (traceLevel.equalsIgnoreCase("Level.SEVERE")) {
                defaultTraceLevel = Level.SEVERE;
            }
        } else {
            defaultTraceLevel = Level.INFO;
        }
        String logging = logProperties.getProperty("com.sun.emp.logging", "0");
        isLogging = logging != null ? (logging.equalsIgnoreCase("1") ? true : logging.equalsIgnoreCase("true")) : false;
        if (mgr == null) {
            mgr = LogManager.getLogManager();
        }
        try {
            FileInputStream logFis = new FileInputStream(System.getProperty("user.dir") + logPropertyFile);
            mgr.readConfiguration(logFis);
            dh = new DialogHandler();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (msg == null) {
            msg = Logger.getLogger("com.sun.emp.MessageLogging");
            msg.setLevel(defaultTraceLevel);
            mgr.addLogger(msg);
        }
        if (trc == null) {
            trc = Logger.getLogger("com.sun.emp.TraceLogging");
            trc.setLevel(defaultTraceLevel);
            mgr.addLogger(trc);
        }
        if (setTraceDirectory != null) {
            FileHandler traceFile = null;
            FileHandler msgFile = null;
            try {
                traceFile = new FileHandler(traceDirectory + File.separator + mgr.getProperty("com.sun.emp.LogFileName") + "_Trace%g.Log");
                msgFile = new FileHandler(traceDirectory + File.separator + mgr.getProperty("com.sun.emp.LogFileName") + "_Message%g.Log");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            trc.addHandler(traceFile);
            trc.addHandler(dh);
            msg.addHandler(msgFile);
            msg.addHandler(dh);
            setTraceDirectory = null;
        }
        Log.tracing(isLogging);
        Log.trace(Level.ALL, "Log", "open", "----------------------------------- Logging started -----------------------------------");
        mc = new MessageCatalog(mgr.getProperty("com.sun.emp.messageFile"));
    }

    public static void tracing(boolean traceOn) {
        if (traceOn) {
            isLogging = true;
            trc.setLevel(defaultTraceLevel);
            Log.trace(Level.ALL, "Log", "tracing", "trace turned ON");
        } else {
            Log.trace(Level.ALL, "Log", "tracing", "trace turned OFF");
            isLogging = false;
            trc.setLevel(Level.OFF);
        }
    }

    public static void clearTraceFilter() {
        trc.setFilter(null);
        Log.trace(Level.ALL, "Log", "tracing", "trace filter cleared");
    }

    public static void setTraceLevel(Level level) {
        System.out.println("Setting level to " + level.toString());
        Log.trace(Level.ALL, "Log", "setTraceLevel", "Trace level set to " + level.getName());
        trc.setLevel(level);
        msg.setLevel(level);
    }

    public static void test() {
        Log.trace(Level.ALL, "Log", "test", "start of trace test");
        Log.trace(Level.INFO, "Log", "test", "Level.INFO tracing");
        Log.trace(Level.WARNING, "Log", "test", "Level.WARNING tracing");
        Log.trace(Level.SEVERE, "Log", "test", "Level.SEVERE tracing");
        Log.trace(Level.ALL, "Log", "test", "end of trace test");
    }

    public static void close() {
        int i = 0;
        Log.trace(Level.ALL, "Log", "close", "----------------------------------- Logging stopped -----------------------------------");
        Handler[] msgHandlers = msg.getHandlers();
        i = 0;
        while (i < msgHandlers.length) {
            msgHandlers[i].close();
            ++i;
        }
        Handler[] trcHandlers = trc.getHandlers();
        i = 0;
        while (i < trcHandlers.length) {
            trcHandlers[i].close();
            ++i;
        }
        closeFlag = true;
    }

    public static void data(Level level, Object classname, String method, byte[] data) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            trc.logp(level, sourceName, method, new String(data));
        }
    }

    public static void entry(Level level, Object classname, String method) {
        if (isLogging) {
            Object[] parms = new Object[]{""};
            Log.entry(level, classname, method, parms);
        }
    }

    public static void entry(Level level, Object classname, String method, Object parm1) {
        if (isLogging) {
            Object[] parms = new Object[]{parm1};
            Log.entry(level, classname, method, parms);
        }
    }

    public static void entry(Level level, Object classname, String method, Object parm1, Object parm2) {
        if (isLogging) {
            Object[] parms = new Object[]{parm1, parm2};
            Log.entry(level, classname, method, parms);
        }
    }

    public static void entry(Level level, Object classname, String method, Object[] parms) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            String msg = "ENTRY";
            int i = 0;
            while (i < parms.length) {
                msg = msg + " {" + i + "}";
                ++i;
            }
            trc.logp(level, sourceName, method, msg, parms);
        }
    }

    public static void error(Object classname, String method, String key) {
        Object[] parms = new Object[]{""};
        Log.error(classname, method, key, parms);
    }

    public static void error(Object classname, String method, String key, Object parm1) {
        Object[] parms = new Object[]{parm1};
        Log.error(classname, method, key, parms);
    }

    public static void error(Object classname, String method, String key, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        Log.error(classname, method, key, parms);
    }

    public static void error(Object classname, String method, String key, Object[] parms) {
        String sourceName = null;
        sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
        msg.logp(Level.SEVERE, sourceName, method, mc.getMessage(key, parms));
    }

    public static void exception(Level level, Object classname, String method, Throwable throwable) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            trc.logp(level, sourceName, method, new String("Exception"), throwable);
        }
    }

    public static void exit(Level level, Object classname, String method) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            trc.logp(level, sourceName, method, "EXIT");
        }
    }

    public static void exit(Level level, Object classname, String method, byte retval) {
        if (isLogging) {
            Byte rval = new Byte(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, short retval) {
        if (isLogging) {
            Short rval = new Short(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, int retval) {
        if (isLogging) {
            Integer rval = new Integer(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, long retval) {
        if (isLogging) {
            Long rval = new Long(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, float retval) {
        if (isLogging) {
            Float rval = new Float(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, double retval) {
        if (isLogging) {
            Double rval = new Double(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, char retval) {
        if (isLogging) {
            Character rval = new Character(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, boolean retval) {
        if (isLogging) {
            Boolean rval = new Boolean(retval);
            Log.exit(level, classname, method, rval);
        }
    }

    public static void exit(Level level, Object classname, String method, Object retval) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            Object[] rval = new Object[]{retval};
            trc.logp(level, sourceName, method, "EXIT {0}", rval);
        }
    }

    public static void fatal(Object classname, String method, String key) {
        Object[] parms = new Object[]{""};
        Log.fatal(classname, method, key, parms);
    }

    public static void fatal(Object classname, String method, String key, Object parm1) {
        Object[] parms = new Object[]{parm1};
        Log.fatal(classname, method, key, parms);
    }

    public static void fatal(Object classname, String method, String key, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        Log.fatal(classname, method, key, parms);
    }

    public static void fatal(Object classname, String method, String key, Object[] parms) {
        String sourceName = null;
        sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
        msg.logp(Level.SEVERE, sourceName, method, key, parms);
    }

    public static void information(Object classname, String method, String key) {
        Object[] parms = new Object[]{""};
        Log.information(classname, method, key, parms);
    }

    public static void information(Object classname, String method, String key, Object parm1) {
        Object[] parms = new Object[]{parm1};
        Log.information(classname, method, key, parms);
    }

    public static void information(Object classname, String method, String key, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        Log.information(classname, method, key, parms);
    }

    public static void information(Object classname, String method, String key, Object[] parms) {
        String sourceName = null;
        sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
        msg.logp(Level.INFO, sourceName, method, key, parms);
    }

    public static void trace(Level level, Object classname, String method, String text) {
        if (isLogging) {
            Object[] parms = new Object[]{""};
            Log.trace(level, classname, method, text, parms);
        }
    }

    public static void trace(Level level, Object classname, String method, String text, Object parm1) {
        if (isLogging) {
            Object[] parms = new Object[]{parm1};
            Log.trace(level, classname, method, text, parms);
        }
    }

    public static void trace(Level level, Object classname, String method, String text, Object parm1, Object parm2) {
        if (isLogging) {
            Object[] parms = new Object[]{parm1, parm2};
            Log.trace(level, classname, method, text, parms);
        }
    }

    public static void trace(Level level, Object classname, String method, String text, Object[] parms) {
        if (isLogging) {
            String sourceName = null;
            sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
            trc.logp(level, sourceName, method, text, parms);
        }
    }

    public static void warning(Object classname, String method, String message) {
        Object[] parms = new Object[]{""};
        Log.warning(classname, method, message, parms);
    }

    public static void warning(Object classname, String method, String message, Object parm1) {
        Object[] parms = new Object[]{parm1};
        Log.warning(classname, method, message, parms);
    }

    public static void warning(Object classname, String method, String message, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        Log.warning(classname, method, message, parms);
    }

    public static void warning(Object classname, String method, String message, Object[] parms) {
        String sourceName = null;
        sourceName = classname instanceof String ? (String)classname : classname.getClass().getName();
        msg.logp(Level.WARNING, sourceName, method, message, parms);
    }

    public static void displayMessage(Object classname, String method, String message, String key, Object[] parms) {
        String classString = null;
        String formattedMessage = null;
        classString = classname instanceof String ? (String)classname : (classname != null ? classname.getClass().getName() : new String("Class"));
        if (key != null && classname != null) {
            formattedMessage = mc.getMessage(key, parms);
            msg.logp(Level.SEVERE, classString, method, formattedMessage);
        }
        if (formattedMessage == null) {
            formattedMessage = mc.formatMessage(message, parms);
            msg.logp(Level.SEVERE, classString, method, formattedMessage);
        }
        if (key == null) {
            dialogHeader = new String("Error");
        } else {
            switch (key.charAt(0)) {
                case 'E': {
                    dialogHeader = new String("Error: " + key);
                    messageType = 0;
                    break;
                }
                case 'I': {
                    dialogHeader = new String("Information: " + key);
                    messageType = 1;
                    break;
                }
                case 'W': {
                    dialogHeader = new String("Warning: " + key);
                    messageType = 2;
                    break;
                }
                case 'Q': {
                    dialogHeader = new String("Question: " + key);
                    messageType = 3;
                    break;
                }
                default: {
                    dialogHeader = new String("Message: " + key);
                    messageType = -1;
                }
            }
        }
        messageText = classString + "." + method + "\n" + formattedMessage;
        System.out.println(classString + "." + method + "(" + key + "): " + formattedMessage);
        Runnable runner = new Runnable(){

            public void run() {
                String myMessage = messageText;
                JOptionPane.showOptionDialog(null, myMessage, dialogHeader, 0, messageType, null, options, options[0]);
            }
        };
        try {
            SwingUtilities.invokeLater(runner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void displayMessage(Object classname, String method, String message, String key, Object parm1) {
        Object[] aobj = new Object[]{parm1};
        Log.displayMessage(classname, method, message, key, aobj);
    }

    public static void displayMessage(Object classname, String method, String message, String key, Object parm1, Object parm2) {
        Object[] aobj = new Object[]{parm1, parm2};
        Log.displayMessage(classname, method, message, key, aobj);
    }

    public static void displayMessage(Object classname, String method, String message, String key, Object parm1, Object parm2, Object parm3) {
        Object[] aobj = new Object[]{parm1, parm2, parm3};
        Log.displayMessage(classname, method, message, key, aobj);
    }

    public static void displayMessage(Object classname, String method, String message, String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        Object[] aobj = new Object[]{parm1, parm2, parm3, parm4};
        Log.displayMessage(classname, method, message, key, aobj);
    }

    public static void buildMessage(Object classname, String method, String message, String key) {
        Object[] parms = new Object[]{null};
        Log.buildMessage(classname, method, message, key, parms);
    }

    public static void buildMessage(Object classname, String method, String message, String key, Object parm1) {
        Object[] parms = new Object[]{parm1};
        Log.buildMessage(classname, method, message, key, parms);
    }

    public static void buildMessage(Object classname, String method, String message, String key, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        Log.buildMessage(classname, method, message, key, parms);
    }

    public static void buildMessage(Object classname, String method, String message, String key, Object parm1, Object parm2, Object parm3) {
        Object[] parms = new Object[]{parm1, parm2, parm3};
        Log.buildMessage(classname, method, message, key, parms);
    }

    public static void buildMessage(Object classname, String method, String message, String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        Object[] parms = new Object[]{parm1, parm2, parm3, parm4};
        Log.buildMessage(classname, method, message, key, parms);
    }

    public static void buildMessage(Object classname, String method, String message, String key, Object[] parms) {
        String classString = null;
        String formattedMessage = null;
        classString = classname instanceof String ? (String)classname : (classname != null ? classname.getClass().getName() : new String("Class"));
        if (key != null && classname != null) {
            formattedMessage = mc.getMessage(key, parms);
            msg.logp(Level.SEVERE, classString, method, formattedMessage);
        }
        if (formattedMessage == null) {
            formattedMessage = mc.formatMessage(message, parms);
            msg.logp(Level.SEVERE, classString, method, formattedMessage);
        }
        if (buildMessageLines > 10) {
            return;
        }
        messageText = classString + "." + method + "\n" + formattedMessage;
        buildMessageText = buildMessageText == null ? messageText + "\n" : buildMessageText + messageText + "\n";
        ++buildMessageLines;
    }

    public static void displayBuildMessage() {
        if (buildMessageText != null) {
            Log.displayMessage((Object)"Log", "Message", "Warning", "I00001", buildMessageText);
            buildMessageText = null;
            buildMessageLines = 0;
        }
    }

    private static void defaultProperties(File propFile) {
        try {
            if (!propFile.canWrite()) {
                propFile.getParentFile().mkdirs();
            }
            propFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(propFile);
            Properties defProp = new Properties();
            defProp.setProperty("com.sun.emp.messageFile", "/com/sun/emp/mbm/messageFile");
            defProp.setProperty("com.sun.emp.traceDirectory", "%t");
            defProp.setProperty("com.sun.emp.logging", "0");
            defProp.setProperty("com.sun.emp.logLevel", "Level.INFO");
            defProp.setProperty("com.sun.emp.tracingLevel", "Level.INFO");
            defProp.setProperty("java.util.logging.FileHandler.formatter", "com.sun.emp.mbm.util.EmpFormatter");
            defProp.setProperty("com.sun.emp.LogFileName", "EMP");
            defProp.store(fos, "Logging Properties");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        Log.initializer();
    }
}

