/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIVsamFile;
import com.sun.emp.mbm.jedit.model.JdVsamFile;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdVsamAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIVsamFile jdElement;
    private JLabel jdddlbl;
    private JLabel jdvsamlbl;
    private JTextField jdddtxt;
    private JTextField jdvsamtxt;
    private JButton jdbrowse;
    private JButton jdlist;
    private JCheckBox jdverbose;
    private File lastSelectedFile = null;

    public JdVsamAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        this.jdddlbl = new JLabel("DD Name");
        this.jdvsamlbl = new JLabel("VSAM Name");
        this.jdddtxt = new JTextField(20);
        this.jdvsamtxt = new JTextField(20);
        this.jdbrowse = new JButton("Browse");
        this.jdlist = new JButton("List");
        this.jdverbose = new JCheckBox("Verbose");
        this.jdbrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdVsamAttributesUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(0);
                chooser.setBackground(JdVsamAttributesUI.this.parent.getBackground());
                int option = chooser.showDialog(JdVsamAttributesUI.this.parent, "Select");
                if (option == 0) {
                    JdVsamAttributesUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdVsamAttributesUI.this.jdvsamtxt.setText(JdVsamAttributesUI.this.lastSelectedFile.getName());
                }
            }
        });
        this.jdlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Vsam Name Chooser", "Select a Vsam Name", JdMediator.getVsamNameList().toArray(), JdVsamAttributesUI.this.jdlist);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdVsamAttributesUI.this.jdvsamtxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdddlbl);
        this.add(this.jdddtxt);
        this.add(this.jdvsamlbl);
        this.add(this.jdvsamtxt);
        this.add(this.jdbrowse);
        this.add(this.jdlist);
        jp.add(this.jdverbose);
        this.add(jp);
        jp.setOpaque(false);
        this.jdverbose.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIVsamFile)jdIElement;
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getVsamName();
        if (str == null) {
            this.jdvsamtxt.setText("");
        } else {
            this.jdvsamtxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbose.setSelected(verbose);
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdddtxt.getText());
        this.jdElement.setVsamName(this.jdvsamtxt.getText());
        this.jdElement.setVerbose(this.jdverbose.isSelected());
    }

    public void reset() {
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdddtxt.setText("");
        } else {
            this.jdddtxt.setText(str);
        }
        str = this.jdElement.getVsamName();
        if (str == null) {
            this.jdvsamtxt.setText("");
        } else {
            this.jdvsamtxt.setText(str);
        }
        boolean verbose = false;
        verbose = this.jdElement.getVerbose();
        this.jdverbose.setSelected(verbose);
    }

    public void setUpdate() {
        this.jdddtxt.setEnabled(true);
        this.jdvsamtxt.setEnabled(true);
        this.jdbrowse.setEnabled(true);
        this.jdlist.setEnabled(true);
        this.jdverbose.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdddtxt.setEnabled(false);
        this.jdvsamtxt.setEnabled(false);
        this.jdbrowse.setEnabled(false);
        this.jdlist.setEnabled(false);
        this.jdverbose.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdddtxt.getText().length() == 0) {
            component.setJdReason(new String("The DD Name cannot be empty"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdddtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The DD Name cannot contain space"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdddtxt.getText())) {
            component.setJdReason(new String("The DD Name already exists"));
            component.setJdLabel(new String(this.jdddlbl.getText()));
            component.setJdComponent((Component)this.jdddtxt);
            return false;
        }
        if (this.jdvsamtxt.getText().length() == 0) {
            component.setJdReason(new String("The Vsam Name cannot be empty"));
            component.setJdLabel(new String(this.jdvsamlbl.getText()));
            component.setJdComponent((Component)this.jdvsamtxt);
            return false;
        }
        if (this.jdvsamtxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Vsam Name cannot contain space "));
            component.setJdLabel(new String(this.jdvsamlbl.getText()));
            component.setJdComponent((Component)this.jdvsamtxt);
            return false;
        }
        if (this.jdvsamtxt.getText().length() > 8) {
            component.setJdReason(new String("The Vsam Name cannot contain more than 8 chars"));
            component.setJdLabel(new String(this.jdvsamlbl.getText()));
            component.setJdComponent((Component)this.jdvsamtxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdVsamAttributesUI jdsaui = new JdVsamAttributesUI();
        JdVsamFile jdp = new JdVsamFile();
        jdsaui.show(jdp);
        jf.getContentPane().add(jdsaui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdsaui.update();
    }
}

