/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIStepElement;
import com.sun.emp.mbm.jedit.model.JdUtilStepElement;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdStepAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIStepElement jdElement;
    private JLabel jdsteplbl;
    private JLabel jdexecutablelbl;
    private JTextField jdsteptxt;
    private JTextField jdexecutabletxt;
    private JButton jdbrowse;
    private JButton jdlist;
    private JCheckBox jdverbose;
    private Object[] listData;
    private File lastSelectedFile;

    public JdStepAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        this.jdsteplbl = new JLabel("Step Name");
        this.jdexecutablelbl = new JLabel("Excecutable Name");
        this.jdsteptxt = new JTextField(20);
        this.jdexecutabletxt = new JTextField(20);
        this.jdbrowse = new JButton("Browse");
        this.jdlist = new JButton("List");
        this.jdverbose = new JCheckBox("Verbose");
        this.lastSelectedFile = null;
        this.jdbrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdStepAttributesUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(0);
                int option = chooser.showDialog(JdStepAttributesUI.this.parent, "Select");
                if (option == 0) {
                    JdStepAttributesUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdStepAttributesUI.this.jdexecutabletxt.setText(JdStepAttributesUI.this.lastSelectedFile.getName());
                }
            }
        });
        this.add(this.jdsteplbl);
        this.add(this.jdsteptxt);
        this.add(this.jdexecutablelbl);
        this.add(this.jdexecutabletxt);
        this.add(this.jdbrowse);
    }

    public JdStepAttributesUI(String executableType) {
        this();
        this.jdexecutablelbl.setText(executableType + " Name");
        this.listData = null;
        final String execType = executableType;
        this.jdlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (execType.equals("Utility")) {
                    JdStepAttributesUI.access$202(JdStepAttributesUI.this, JdMediator.getUtilityNameList().toArray());
                } else if (execType.equals("Program")) {
                    JdStepAttributesUI.access$202(JdStepAttributesUI.this, JdMediator.getProgramNameList().toArray());
                } else if (execType.equals("Procedure")) {
                    JdStepAttributesUI.access$202(JdStepAttributesUI.this, JdMediator.getProcedureNameList().toArray());
                }
                JdListChooser listChooser = new JdListChooser(execType + " Name Chooser", "Select the " + execType + " Name", JdStepAttributesUI.this.listData, JdStepAttributesUI.this.jdlist);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdStepAttributesUI.this.jdexecutabletxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        JPanel jp = new JPanel();
        this.add(this.jdlist);
        jp.add(this.jdverbose);
        this.add(jp);
        jp.setOpaque(false);
        this.jdverbose.setOpaque(false);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIStepElement)jdIElement;
        String str = this.jdElement.getName();
        boolean verbose = false;
        if (str == null) {
            this.jdsteptxt.setText("");
        } else {
            this.jdsteptxt.setText(str);
        }
        str = this.jdElement.getExecName();
        if (str == null) {
            this.jdexecutabletxt.setText("");
        } else {
            this.jdexecutabletxt.setText(str);
        }
        verbose = this.jdElement.getVerbose();
        this.jdverbose.setSelected(verbose);
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdsteptxt.getText());
        this.jdElement.setExecName(this.jdexecutabletxt.getText());
        this.jdElement.setVerbose(this.jdverbose.isSelected());
    }

    public void reset() {
        String str = this.jdElement.getName();
        boolean verbose = false;
        if (str == null) {
            this.jdsteptxt.setText("");
        } else {
            this.jdsteptxt.setText(str);
        }
        str = this.jdElement.getExecName();
        if (str == null) {
            this.jdexecutabletxt.setText("");
        } else {
            this.jdexecutabletxt.setText(str);
        }
        verbose = this.jdElement.getVerbose();
        this.jdverbose.setSelected(verbose);
    }

    public void setUpdate() {
        this.jdsteptxt.setEnabled(true);
        this.jdexecutabletxt.setEnabled(true);
        this.jdverbose.setEnabled(true);
        this.jdbrowse.setEnabled(true);
        this.jdlist.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdsteptxt.setEnabled(false);
        this.jdexecutabletxt.setEnabled(false);
        this.jdverbose.setEnabled(false);
        this.jdbrowse.setEnabled(false);
        this.jdlist.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdsteptxt.getText().length() == 0) {
            component.setJdReason(new String("The Step Name cannot be empty"));
            component.setJdLabel(new String(this.jdsteplbl.getText()));
            component.setJdComponent((Component)this.jdsteptxt);
            return false;
        }
        if (this.jdsteptxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Step Name cannot contain space"));
            component.setJdLabel(new String(this.jdsteplbl.getText()));
            component.setJdComponent((Component)this.jdsteptxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdsteptxt.getText())) {
            component.setJdReason(new String("The Step Name already exists"));
            component.setJdLabel(new String(this.jdsteplbl.getText()));
            component.setJdComponent((Component)this.jdsteptxt);
            return false;
        }
        if (this.jdexecutabletxt.getText().length() == 0) {
            component.setJdReason(new String("The Executable Name cannot be empty"));
            component.setJdLabel(new String(this.jdexecutablelbl.getText()));
            component.setJdComponent((Component)this.jdexecutabletxt);
            return false;
        }
        if (this.jdexecutabletxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Executable Name cannot contain space"));
            component.setJdLabel(new String(this.jdexecutablelbl.getText()));
            component.setJdComponent((Component)this.jdexecutabletxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdStepAttributesUI jdsaui = new JdStepAttributesUI("Utility");
        JdUtilStepElement jdp = new JdUtilStepElement();
        jdsaui.show(jdp);
        jf.getContentPane().add(jdsaui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdsaui.update();
    }

    static /* synthetic */ Object[] access$202(JdStepAttributesUI x0, Object[] x1) {
        x0.listData = x1;
        return x1;
    }
}

