/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.model.JdProjectElement;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JdProjectAttributesUI
extends JPanel
implements JdIFormUI {
    JPanel parent = this;
    private JdIProjectElement jdElement;
    private JLabel jdprojectlbl;
    private JLabel jddirectorylbl;
    private JTextField jdprojecttxt;
    private JTextField jddirectorytxt;
    private JButton jdbrowse;
    private JButton jdlist;

    public JdProjectAttributesUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 30);
        this.setLayout((LayoutManager)jdfl);
        this.jdprojectlbl = new JLabel("Project Name");
        this.jddirectorylbl = new JLabel("Directory pathname");
        this.jdprojecttxt = new JTextField(20);
        this.jddirectorytxt = new JTextField(20);
        this.jdbrowse = new JButton("Browse");
        this.jdlist = new JButton("List");
        this.add(this.jdprojectlbl);
        this.add(this.jdprojecttxt);
        this.add(this.jddirectorylbl);
        this.add(this.jddirectorytxt);
        this.jdbrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int option = chooser.showDialog(JdProjectAttributesUI.this.parent, "Select");
                if (option == 0) {
                    JdProjectAttributesUI.this.jddirectorytxt.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.jdlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Project Directory Chooser", "Select a Project Directory", JdMediator.getProjectDirectoryList().toArray(), JdProjectAttributesUI.this.jdlist);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdProjectAttributesUI.this.jddirectorytxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(this.jdbrowse);
        this.add(this.jdlist);
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIProjectElement)jdIElement;
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdprojecttxt.setText("");
        } else {
            this.jdprojecttxt.setText(str);
        }
        if (this.jdElement.getDirectoryPathname() != null) {
            str = this.jdElement.getDirectoryPathname().getPathname();
            if (str == null) {
                this.jddirectorytxt.setText("");
            } else {
                this.jddirectorytxt.setText(str);
            }
        } else {
            this.jddirectorytxt.setText("Directory Name");
        }
        this.setReadOnly();
    }

    public void update() {
        this.jdElement.setName(this.jdprojecttxt.getText());
        if (this.jdElement.getDirectoryPathname() != null) {
            this.jdElement.getDirectoryPathname().setPathname(this.jddirectorytxt.getText());
        }
    }

    public void reset() {
        String str = null;
        str = this.jdElement.getName();
        if (str == null) {
            this.jdprojecttxt.setText("");
        } else {
            this.jdprojecttxt.setText(str);
        }
        if (this.jdElement.getDirectoryPathname() != null) {
            str = this.jdElement.getDirectoryPathname().getPathname();
            if (str == null) {
                this.jddirectorytxt.setText("");
            } else {
                this.jddirectorytxt.setText(str);
            }
        } else {
            this.jddirectorytxt.setText("Directory Name");
        }
    }

    public void setUpdate() {
        this.jdprojecttxt.setEnabled(true);
        this.jddirectorytxt.setEnabled(true);
        this.jdbrowse.setEnabled(true);
        this.jdlist.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdprojecttxt.setEnabled(false);
        this.jddirectorytxt.setEnabled(false);
        this.jdbrowse.setEnabled(false);
        this.jdlist.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        if (this.jdprojecttxt.getText().length() == 0) {
            component.setJdReason(new String("The Project name cannot be empty"));
            component.setJdComponent((Component)this.jdprojecttxt);
            return false;
        }
        if (this.jdprojecttxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Project name cannot contain space"));
            component.setJdLabel(new String(this.jdprojectlbl.getText()));
            component.setJdComponent((Component)this.jdprojecttxt);
            return false;
        }
        if (JdMediator.getBrotherList().contains(this.jdprojecttxt.getText())) {
            component.setJdReason(new String("The Project Name already exists"));
            component.setJdLabel(new String(this.jdprojectlbl.getText()));
            component.setJdComponent((Component)this.jdprojecttxt);
            return false;
        }
        if (this.jddirectorytxt.getText().length() == 0) {
            component.setJdReason(new String("The Directory Pathname cannot be empty"));
            component.setJdLabel(new String(this.jddirectorylbl.getText()));
            component.setJdComponent((Component)this.jddirectorytxt);
            return false;
        }
        if (this.jddirectorytxt.getText().indexOf(32) != -1) {
            component.setJdReason(new String("The Directory Pathname cannot contain space"));
            component.setJdLabel(new String(this.jddirectorylbl.getText()));
            component.setJdComponent((Component)this.jddirectorytxt);
            return false;
        }
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdProjectAttributesUI jdpaui = new JdProjectAttributesUI();
        JdProjectElement jdp = new JdProjectElement();
        jdpaui.show(jdp);
        jf.getContentPane().add(jdpaui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdpaui.update();
    }
}

