/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIParameterList;
import com.sun.emp.mbm.jedit.model.JdProcElement;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import com.sun.emp.mbm.util.JdParameter;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JdParameterListUI
extends JPanel
implements JdIFormUI,
ListSelectionListener {
    private JdIParameterList jdElement;
    private JList jdwindowl;
    private JButton jdlistbtn;
    private JButton jddeletebtn;
    private JButton jdapplybtn;
    private JButton jdclearbtn;
    private JButton jdaddbtn;
    private JLabel jdparameternamelbl;
    private JLabel jdparametervaluelbl;
    private JLabel jddescriptionlbl;
    private JTextField jdparameternametxt;
    private JTextField jdparametervaluetxt;
    private JTextField jddescriptiontxt;
    private DefaultListModel listmodel;

    public JdParameterListUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 5);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        this.listmodel = new DefaultListModel();
        this.jdwindowl = new JList(this.listmodel);
        JScrollPane listScrollPane = new JScrollPane(this.jdwindowl);
        this.jdwindowl.setSelectionMode(0);
        this.jdwindowl.addListSelectionListener(this);
        this.jdlistbtn = new JButton("List");
        this.jddeletebtn = new JButton("Delete");
        this.jdapplybtn = new JButton("Apply");
        this.jdclearbtn = new JButton("Clear");
        this.jdaddbtn = new JButton("Add");
        this.jdparameternamelbl = new JLabel("Parameter Name");
        this.jdparametervaluelbl = new JLabel("Parameter Value");
        this.jddescriptionlbl = new JLabel("Description");
        this.jdparameternametxt = new JTextField(15);
        this.jdparametervaluetxt = new JTextField(15);
        this.jddescriptiontxt = new JTextField(15);
        this.jdaddbtn.addActionListener(new AddListener());
        this.jddeletebtn.addActionListener(new DeleteListener());
        this.jdapplybtn.addActionListener(new ApplyListener());
        this.jdclearbtn.addActionListener(new ClearListener());
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser md = new JdListChooser("Parameter", "Select a Parameter", JdMediator.getParameterList().toArray(), JdParameterListUI.this.jdlistbtn);
                md.setVisible(true);
                if (md.getSelectedValue() != null) {
                    JdParameter jdParam = (JdParameter)md.getSelectedValue();
                    JdParameterListUI.this.jdparameternametxt.setText(jdParam.getKey());
                    JdParameterListUI.this.jdparametervaluetxt.setText(jdParam.getValue());
                    JdParameterListUI.this.jddescriptiontxt.setText(jdParam.getDescription());
                }
                md.dispose();
            }
        });
        this.add(listScrollPane);
        this.add(jp);
        this.add(this.jdlistbtn);
        this.add(this.jddeletebtn);
        this.add(this.jdparameternamelbl);
        this.add(this.jdparameternametxt);
        this.add(this.jdparametervaluelbl);
        this.add(this.jdparametervaluetxt);
        this.add(this.jddescriptionlbl);
        this.add(this.jddescriptiontxt);
        this.add(this.jdapplybtn);
        this.add(this.jdclearbtn);
        this.add(this.jdaddbtn);
        jp.setOpaque(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.jdwindowl.getSelectedIndex() == -1) {
                this.jddeletebtn.setEnabled(false);
                this.jdapplybtn.setEnabled(false);
                this.jdparameternametxt.setText("");
            } else {
                this.jddeletebtn.setEnabled(true);
                this.jdapplybtn.setEnabled(true);
                JdParameter jdp = (JdParameter)this.jdwindowl.getSelectedValue();
                this.jdparameternametxt.setText(jdp.getKey());
                this.jdparametervaluetxt.setText(jdp.getValue());
                this.jddescriptiontxt.setText(jdp.getDescription());
            }
        }
    }

    public void show(JdIElement jdIElement) {
        this.jdElement = (JdIParameterList)((Object)jdIElement);
        this.listmodel.removeAllElements();
        ArrayList al = new ArrayList();
        al = this.jdElement.getListParameters();
        if (al != null) {
            if (al.size() != 0) {
                Object[] arr1 = al.toArray();
                int i = 0;
                while (i < arr1.length) {
                    this.listmodel.addElement(arr1[i]);
                    ++i;
                }
            }
            if (this.jdwindowl.getFirstVisibleIndex() != -1) {
                this.jdwindowl.setSelectedIndex(0);
            }
        }
        this.jdparameternametxt.setText("");
        this.jdparametervaluetxt.setText("");
        this.jddescriptiontxt.setText("");
        this.setReadOnly();
    }

    public void update() {
        ArrayList<Object> arr = new ArrayList<Object>();
        Object[] arr1 = new Object[]{""};
        arr1 = this.listmodel.toArray();
        int i = 0;
        while (i < arr1.length) {
            arr.add(arr1[i]);
            ++i;
        }
        this.jdElement.setListParameters(arr);
    }

    public void reset() {
    }

    public void setUpdate() {
        this.jdwindowl.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        if (this.listmodel.getSize() != 0) {
            this.jdapplybtn.setEnabled(true);
            this.jddeletebtn.setEnabled(true);
        }
        this.jdclearbtn.setEnabled(true);
        this.jdaddbtn.setEnabled(true);
        this.jdparameternametxt.setEnabled(true);
        this.jdparametervaluetxt.setEnabled(true);
        this.jddescriptiontxt.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdwindowl.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jddeletebtn.setEnabled(false);
        this.jdapplybtn.setEnabled(false);
        this.jdclearbtn.setEnabled(false);
        this.jdaddbtn.setEnabled(false);
        this.jdparameternametxt.setEnabled(false);
        this.jdparametervaluetxt.setEnabled(false);
        this.jddescriptiontxt.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        return true;
    }

    public static void main(String[] av) {
        JdProcElement jdp1;
        JFrame jf = new JFrame();
        JdParameterListUI jdplui = new JdParameterListUI();
        JdParameter jp1 = new JdParameter("path1", "abb", "desc1");
        JdParameter jp2 = new JdParameter("path2", "ccc", "desc2");
        ArrayList<JdParameter> ar = new ArrayList<JdParameter>();
        ar.add(jp1);
        ar.add(jp2);
        JdProcElement jdp = jdp1 = new JdProcElement();
        jdplui.show(jdp);
        jf.getContentPane().add(jdplui);
        jf.setSize(300, 300);
        jf.setVisible(true);
    }

    class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JdParameterListUI.this.jdparameternametxt.setText("");
            JdParameterListUI.this.jdparametervaluetxt.setText("");
            JdParameterListUI.this.jddescriptiontxt.setText("");
        }
    }

    class ApplyListener
    implements ActionListener {
        ApplyListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JdParameterListUI.this.listmodel.isEmpty()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (JdParameterListUI.this.jdparameternametxt.getText().length() == 0) {
                JOptionPane.showMessageDialog(null, "The parameter name cannot be empty.", "Invalid Input", 1, null);
                return;
            }
            if (JdParameterListUI.this.jdparameternametxt.getText().indexOf(" ") != -1) {
                JOptionPane.showMessageDialog(null, "The parameter name cannot contain space.", "Invalid Input", 1, null);
                return;
            }
            int index = JdParameterListUI.this.jdwindowl.getSelectedIndex();
            int size = JdParameterListUI.this.listmodel.getSize();
            JdParameter jdp = (JdParameter)JdParameterListUI.this.jdwindowl.getSelectedValue();
            String key = null;
            String value = null;
            String desc = null;
            key = JdParameterListUI.this.jdparameternametxt.getText();
            value = JdParameterListUI.this.jdparametervaluetxt.getText();
            desc = JdParameterListUI.this.jddescriptiontxt.getText();
            jdp.setKey(key);
            jdp.setValue(value);
            jdp.setDescription(desc);
            JdParameterListUI.this.listmodel.addElement(new JdParameter());
            JdParameterListUI.this.jdwindowl.setSelectedIndex(index + 1);
            JdParameterListUI.this.jdwindowl.setSelectedIndex(index);
            JdParameterListUI.this.listmodel.removeElementAt(JdParameterListUI.this.listmodel.getSize() - 1);
        }
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JdParameterListUI.this.jdparameternametxt.getText().length() == 0) {
                JOptionPane.showMessageDialog(null, "The parameter name cannot be empty.", "Invalid Input", 1, null);
                return;
            }
            if (JdParameterListUI.this.jdparameternametxt.getText().indexOf(" ") != -1) {
                JOptionPane.showMessageDialog(null, "The parameter name cannot contain space.", "Invalid Input", 1, null);
                return;
            }
            int index = JdParameterListUI.this.jdwindowl.getSelectedIndex();
            int size = JdParameterListUI.this.listmodel.getSize();
            String key = null;
            String value = null;
            String desc = null;
            key = JdParameterListUI.this.jdparameternametxt.getText();
            value = JdParameterListUI.this.jdparametervaluetxt.getText();
            desc = JdParameterListUI.this.jddescriptiontxt.getText();
            JdParameter jdp = new JdParameter(key, value, desc);
            if (index == -1 || index + 1 == size) {
                JdParameterListUI.this.listmodel.addElement(jdp);
                JdParameterListUI.this.jdwindowl.setSelectedIndex(size);
            } else {
                JdParameterListUI.this.listmodel.insertElementAt(jdp, index + 1);
                JdParameterListUI.this.jdwindowl.setSelectedIndex(index + 1);
            }
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = JdParameterListUI.this.jdwindowl.getSelectedIndex();
            if (index == -1) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                JdParameterListUI.this.listmodel.remove(index);
            }
            int size = JdParameterListUI.this.listmodel.getSize();
            if (size == 0) {
                JdParameterListUI.this.jddeletebtn.setEnabled(false);
                JdParameterListUI.this.jdapplybtn.setEnabled(false);
            } else {
                if (index == JdParameterListUI.this.listmodel.getSize()) {
                    --index;
                }
                JdParameterListUI.this.jdwindowl.setSelectedIndex(index);
            }
        }
    }
}

