/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.pgm;

import com.sun.emp.mbm.jedit.command.JdAbstractCommandFactory;
import com.sun.emp.mbm.jedit.command.JdCommand;
import com.sun.emp.mbm.jedit.command.JdQuitCommand;
import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.controller.JdTreeExpansionListener;
import com.sun.emp.mbm.jedit.controller.JdTreeSelectionListener;
import com.sun.emp.mbm.jedit.model.JdConfiguration;
import com.sun.emp.mbm.jedit.model.JdTree;
import com.sun.emp.mbm.jedit.pgm.Threadclass;
import com.sun.emp.mbm.jedit.view.JdButtonPanel;
import com.sun.emp.mbm.jedit.view.JdIconCellRenderer;
import com.sun.emp.mbm.jedit.view.JdMenuBar;
import com.sun.emp.mbm.jedit.view.JdPanelChanger;
import com.sun.emp.mbm.util.JdButton;
import com.sun.emp.mbm.util.JdLock;
import com.sun.emp.mbm.util.JdMenuItem;
import com.sun.emp.mbm.util.Log;
import com.sun.emp.mbm.util.interfaces.JdIAbstractCommandFactory;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class JEdit
extends JFrame {
    protected JdMediator mediator = null;
    protected JdMenuBar menu_bar = null;
    protected JdButtonPanel button_panel = null;
    protected JdTree tree = null;
    protected JdPanelChanger panel_changer = null;
    protected JdTreeSelectionListener tree_selection_listener = null;
    protected JdTreeExpansionListener tree_expansion_listener = null;
    static Threadclass tryThread;
    private boolean isUpdateMode = true;
    private static String JD_DEFAULT_CONFIG;
    private JdConfiguration in_config = null;
    private static String _jedit_pid;

    public JEdit(String title) {
        super(title);
        this.setFont(new Font("SansSerif", 1, 14));
        JOptionPane optionpane = new JOptionPane();
        String jdmessage = "Job Editor has detected a lock file :\n";
        Object[] options = new Object[]{"Yes", "No"};
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JdQuitCommand quit = new JdQuitCommand();
                quit.execute();
            }
        });
        JdButton.setJdIAbstractCommandFactory((JdIAbstractCommandFactory)JdAbstractCommandFactory.getAbstractCommandFactory());
        JdMenuItem.setJdIAbstractCommandFactory((JdIAbstractCommandFactory)JdAbstractCommandFactory.getAbstractCommandFactory());
        try {
            File jdConfigFile = new File(JD_DEFAULT_CONFIG);
            if (!jdConfigFile.exists()) {
                this.in_config = JdConfiguration.getConfiguration();
            } else {
                FileInputStream fstream = new FileInputStream(JD_DEFAULT_CONFIG);
                ObjectInputStream istream = new ObjectInputStream(fstream);
                this.in_config = (JdConfiguration)istream.readObject();
            }
        }
        catch (Exception e) {
            Log.displayMessage((Object)this, (String)"Job Editor", (String)e.toString(), (String)"E00003", (Object)e.toString());
        }
        this.menu_bar = new JdMenuBar();
        this.button_panel = new JdButtonPanel();
        this.tree = new JdTree(this.in_config.getRootProject());
        this.tree.setCellRenderer(new JdIconCellRenderer());
        this.panel_changer = new JdPanelChanger();
        this.mediator = new JdMediator(this.menu_bar, this.button_panel, this.tree, this.panel_changer);
        this.isUpdateMode = JdLock.jdLockSession((String)_jedit_pid);
        if (!this.isUpdateMode) {
            String fileName = JdLock.getSessionLockInfo();
            jdmessage = jdmessage + "                  " + fileName;
            jdmessage = jdmessage + "\n\nThis indicates that another user is running the Job Editor.\n";
            jdmessage = jdmessage + "You may continue to use the Job Editor, but you will\n";
            jdmessage = jdmessage + "not be able to update any job definitions.\n\n";
            jdmessage = jdmessage + "Do you want to continue in Read Only Mode?";
            Toolkit.getDefaultToolkit().beep();
            int yesno = JOptionPane.showOptionDialog(null, jdmessage, "Job Editor", 0, 0, null, options, options[0]);
            if (yesno == 0) {
                this.mediator.setSessionUpdateMode(this.isUpdateMode);
            } else {
                System.exit(0);
            }
        }
        JdCommand.setMediator(this.mediator);
        this.tree_expansion_listener = new JdTreeExpansionListener(this.mediator);
        this.tree_selection_listener = new JdTreeSelectionListener(this.mediator);
        this.tree.addTreeExpansionListener(this.tree_expansion_listener);
        this.tree.addTreeSelectionListener(this.tree_selection_listener);
        this.setJMenuBar(this.menu_bar);
        Container content_pane = this.getContentPane();
        JScrollPane tree_pane = new JScrollPane(this.tree);
        JPanel right_side = new JPanel();
        right_side.setPreferredSize(new Dimension(450, 500));
        right_side.setMinimumSize(new Dimension(450, 500));
        right_side.setAlignmentX(0.5f);
        right_side.setAutoscrolls(true);
        right_side.setLayout(new BoxLayout(right_side, 1));
        right_side.add(this.panel_changer);
        right_side.add(Box.createRigidArea(new Dimension(0, 5)));
        right_side.add(this.button_panel);
        tree_pane.setPreferredSize(new Dimension(250, 500));
        tree_pane.setMinimumSize(new Dimension(250, 500));
        JScrollPane right_pane = new JScrollPane(right_side);
        JSplitPane split_pane = new JSplitPane(1, tree_pane, right_pane);
        split_pane.setOneTouchExpandable(true);
        split_pane.setDividerLocation(150);
        content_pane.add(split_pane);
        tryThread.interrupt();
        this.setSize(750, 550);
        this.setVisible(true);
    }

    public static void main(String[] av) {
        tryThread = new Threadclass();
        tryThread.start();
        if (av.length > 0) {
            _jedit_pid = av[0];
        }
        JEdit jEdit = new JEdit("Job Editor");
    }

    static {
        JD_DEFAULT_CONFIG = "JdConfig.ser";
        _jedit_pid = null;
    }
}

