/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.command;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import com.sun.emp.mbm.util.interfaces.JdICommand;
import com.sun.emp.mbm.util.interfaces.JdIOperation;
import com.sun.emp.mbm.util.interfaces.JdIRedoable;
import com.sun.emp.mbm.util.interfaces.JdIUndoable;
import java.util.Stack;
import java.util.logging.Level;

public class JdCommandManager
implements JdIOperation {
    static final int MAX_STACK_DEPTH = 30;
    private JdIMutableTreeNode jdPasteNode;
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private boolean isUndoRedoMode = false;

    public void processCommand(JdICommand jdCommand) {
        JdICommand current_command;
        Log.entry((Level)Level.INFO, (Object)this, (String)"processCommand");
        if (jdCommand instanceof JdIUndoable) {
            this.isUndoRedoMode = true;
            if (!this.undoStack.empty()) {
                current_command = (JdICommand)this.redoStack.push(this.undoStack.pop());
                current_command.undoIt();
            }
        } else if (jdCommand instanceof JdIRedoable) {
            this.isUndoRedoMode = true;
            if (!this.redoStack.empty()) {
                current_command = (JdICommand)this.undoStack.push(this.redoStack.pop());
                current_command.redoIt();
            }
        } else {
            if (jdCommand.canUndo() != null) {
                if (this.isUndoRedoMode) {
                    this.isUndoRedoMode = false;
                    if (!this.undoStack.isEmpty()) {
                        this.undoStack.clear();
                    }
                    if (!this.redoStack.isEmpty()) {
                        this.redoStack.clear();
                    }
                }
                this.undoStack.push(jdCommand);
            }
            Log.trace((Level)Level.INFO, (Object)this, (String)"processCommand", (String)("doIt(" + jdCommand.getCommandName() + ")"));
            jdCommand.doIt();
        }
        while (this.undoStack.size() > 30) {
            this.undoStack.removeElementAt(1);
        }
        while (this.redoStack.size() > 30) {
            this.redoStack.removeElementAt(1);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"processCommand");
    }

    public void setPasteNode(JdIMutableTreeNode jdMutableTreeNode) {
        this.jdPasteNode = jdMutableTreeNode;
    }

    public void clearPasteNode() {
        this.jdPasteNode = null;
    }

    public JdIMutableTreeNode getPasteNode() {
        return this.jdPasteNode;
    }

    public String canUndo() {
        if (!this.undoStack.empty()) {
            JdICommand undoCommand = (JdICommand)this.undoStack.peek();
            return undoCommand.getCommandName();
        }
        return null;
    }

    public boolean canPaste(JdIElement jdIElement, JdIElement parentElement) {
        if (this.jdPasteNode != null) {
            return jdIElement.canInsert(this.jdPasteNode.getJdIElement().getElementType(), parentElement.getElementType());
        }
        return false;
    }

    public String canRedo() {
        if (!this.redoStack.empty()) {
            JdICommand redoCommand = (JdICommand)this.redoStack.peek();
            return redoCommand.getCommandName();
        }
        return null;
    }

    static {
        MAX_STACK_DEPTH = 30;
    }
}

