/*       REMARKS. THIS PROGRAM IS THE FIRST INVOKED BY THE 'AC01' */
/*                TRANSACTION.  IT ANALYZES ALL REQUESTS, AND COMPLETES */
/*                THOSE FOR NAME INQUIRES AND RECORD DISPLAYS.  FOR */
/*                UPDATE TRANSACTIONS, IT SENDS THE APPROPRIATE DATA ENTRY */
/*                SCREEN AND SETS THE NEXT TRANSACTION IDENTIFIER TO */
/*                'AC02', WHICH COMPLETE THE UPDATE OPERATION.  FOR PRINT */
/*                REQUESTS, IT STARTS TRANSACTION 'AC03' TO DO THE ACTUAL */
/*                PRINTING. */
#if defined(__cplusplus)
extern "C" {
#endif
extern void	kxprtf (
#if defined(__STDC__) || defined(__cplusplus)
	const char	*pstr,
	...
#endif
);
#include <stdio.h>
#include <ctype.h>
#include "dfhaid.h"
#include "dfhbmsca.h"
EXEC SQL INCLUDE SQLCA;

EXEC SQL BEGIN DECLARE SECTION;
#include "ACCTSET.h"

/*    ACIXREC - NAME INDEX RECORD */
struct acixrec_struct {
       char snamedo[19];
       char acctdo[6];
       char fnamedo[13];
       char mido[2];
       char ttldo[5];
       char addr1do[25];
       char statdo[3];
       char limitdo[9];
       };
struct acixrec_struct  acixrec;
#define ACIXREC acixrec
#define SNAMEDO acixrec.snamedo
#define ACCTDO  acixrec.acctdo
#define FNAMEDO acixrec.fnamedo
#define MIDO    acixrec.mido
#define TTLDO   acixrec.ttldo
#define ADDR1DO acixrec.addr1do
#define STATDO  acixrec.statdo
#define LIMITDO acixrec.limitdo


/*    ACCTREC - ACCOUNT FILE RECORD */
struct acctrec_struct {
       char acctdo[6];
       char snamedo[19];
       char fnamedo[13];
       char mido[2];
       char ttldo[5];
       char teldo[11];
       char addr1do[25];
       char addr2do[25];
       char addr3do[25];
       char auth1do[33];
       char auth2do[33];
       char auth3do[33];
       char auth4do[33];
       char cardsdo[2];
       char imodo[3];
       char idaydo[3];
       char iyrdo[3];
       char rsndo[2];
       char ccodedo[2];
       char apprdo[4];
       char scode1do[2];
       char scode2do[2];
       char scode3do[2];
       char statdo[3];
       char limitdo[9];
       struct { 
              char bal[9];
              char bmo[3];
              char bday[3];
              char byr[3];
              char bamt[9];
              char pmo[3];
              char pday[3];
              char pyr[3];
              char pamt[9];
              }    pay_hist[3];
       };
struct acctrec_struct acctrec;
#define AR_ACCTREC  acctrec
#define AR_ACCTDO   acctrec.acctdo
#define AR_SNAMEDO  acctrec.snamedo
#define AR_FNAMEDO  acctrec.fnamedo
#define AR_MIDO     acctrec.mido
#define AR_TTLDO    acctrec.ttldo
#define AR_TELDO    acctrec.teldo
#define AR_ADDR1DO  acctrec.addr1do
#define AR_ADDR2DO  acctrec.addr2do
#define AR_ADDR3DO  acctrec.addr3do
#define AR_AUTH1DO  acctrec.auth1do
#define AR_AUTH2DO  acctrec.auth2do
#define AR_AUTH3DO  acctrec.auth3do
#define AR_AUTH4DO  acctrec.auth4do
#define AR_CARDSDO  acctrec.cardsdo
#define AR_IMODO    acctrec.imodo
#define AR_IDAYDO   acctrec.idaydo
#define AR_IYRDO    acctrec.iyrdo
#define AR_RSNDO    acctrec.rsndo
#define AR_CCODEDO  acctrec.ccodedo
#define AR_APPRDO   acctrec.apprdo
#define AR_SCODE1DO acctrec.scode1do
#define AR_SCODE2DO acctrec.scode2do
#define AR_SCODE3DO acctrec.scode3do
#define AR_STATDO   acctrec.statdo
#define AR_LIMITDO  acctrec.limitdo

#define AR_PAY_HIST acctrec.pay_hist
#define AR_BAL(xx)     acctrec.pay_hist[xx].bal
#define AR_BMO(xx)     acctrec.pay_hist[xx].bmo
#define AR_BDAY(xx)    acctrec.pay_hist[xx].bday
#define AR_BYR(xx)     acctrec.pay_hist[xx].byr
#define AR_BAMT(xx)    acctrec.pay_hist[xx].bamt
#define AR_PMO(xx)     acctrec.pay_hist[xx].pmo
#define AR_PDAY(xx)    acctrec.pay_hist[xx].pday
#define AR_PYR(xx)     acctrec.pay_hist[xx].pyr
#define AR_PAMT(xx)    acctrec.pay_hist[xx].pamt

EXEC SQL END DECLARE SECTION;
#define MNUI acctmnu.acctmnui
#define MNUO acctmnu.acctmnuo
#define DTLO acctdtl.acctdtlo
#define DTLI acctdtl.acctdtli
	   struct cics_eib *prm1;
           int myresp;
           int myresp2;
	   int use_limit = 1000;
	   int tmp_date;
	   int tmp_time;
	   char *prm2;
	   short msg_no;
	   short acct_lng = 383;
	   short acix_lng = 63;
	   short dtl_lng = 751;
	   short line_cnt =0;
	   short max_lines = 6;
	   short use_lng = 12;
	   short use_item = 1;
	   char stars[12];
static    union {
		  char srch_comm[44];
		  char in_comm[41];
		  char ctype;
		  } com_area;
	   struct {
		  char use_qid1[3];
		  char use_qid2[5];
		  } use_qid;
#define USE_QID   use_qid
#define USE_QID1  use_qid.use_qid1
#define USE_QID2  use_qid.use_qid2
	   struct {
		  char use_term[4];
		  int use_time;
		  int use_date;
		  } use_rec;
#define USE_REC   use_rec
#define USE_TERM  use_rec.use_term
#define USE_TIME  use_rec.use_time
#define USE_DATE  use_rec.use_date
	   struct {
		  char filr1;
		  struct {
			 char brkey_sname[12];
			 char brkey_acct[5];
			 } brkey;
		  char max_sname[12];
		  char max_fname[7];
		  char min_fname[7];
		  } srch_ctrl;
#define SRCH_CTRL   srch_ctrl
#define BRKEY       srch_ctrl.brkey
#define BRKEY_SNAME srch_ctrl.brkey.brkey_sname
#define BRKEY_ACCT  srch_ctrl.brkey.brkey_acct
#define MAX_SNAME   srch_ctrl.max_sname
#define MAX_FNAME   srch_ctrl.max_fname
#define MIN_FNAME   srch_ctrl.min_fname
static struct {
		  char in_type;
		  struct {
			 char reqc;
			 char acctc[5];
			 char prtrc[4];
			 } in_req;
		  struct {
			 char snamec[18];
			 char fnamec[12];
			 } in_names;
		  } in_area;
#define IN_AREA in_area
#define IN_TYPE in_area.in_type
#define IN_REQ in_area.in_req
#define REQC   in_area.in_req.reqc
#define ACCTC  in_area.in_req.acctc
#define PRTRC  in_area.in_req.prtrc
#define SNAMEC in_area.in_names.snamec
#define FNAMEC in_area.in_names.fnamec
/* added by dv133961 */
  struct req_commarea_struct {
           char req_type;
           char req_acct[6];
           char  bal[9];
           char  bmo[3];
           char  bday[3];
           char  byr[3];
           char  bamt[9];
           char  pmo[3];
           char  pday[3]; 
           char  pyr[3];
           char  pamt[9];
           char req_status;
         };
struct req_commarea_struct req_commarea;
/* end add   */


  struct {
           char acctdo[5];
           char fil01[3];
           char snamedo[12];
           char fil02[2];
           char fnamedo[7];
           char fil03[2];
           char mido;
           char fil04[2];
           char ttldo[4];
           char fil05[2];
           char addr1do[24];
           char fil06[2];
           char statdo[2];
           char fil07[3];
           char limitdo[8];
	  } sum_line;
#define SL_SUM_LINE sum_line
#define SL_ACCTDO  sum_line.acctdo
#define SL_SNAMEDO sum_line.snamedo
#define SL_FNAMEDO sum_line.fnamedo
#define SL_MIDO    sum_line.mido
#define SL_TTLDO   sum_line.ttldo
#define SL_ADDR1DO sum_line.addr1do
#define SL_STATDO  sum_line.statdo
#define SL_LIMITDO sum_line.limitdo

   struct {
           char bal[8];
           char fil08[6];
           char bmo[2];
           char fil09;
           char bday[2];
           char fil10;
           char byr[2];
           char fil11[4];
           char bamt[8];
           char fil12[7];
           char pmo[2];
           char fil13;
           char pday[2];
           char fil14;
           char pyr[2];
           char fil15[4];
           char pamt[8];
	  } pay_line;
#define PL_PAY_LINE pay_line
#define PL_BAL  pay_line.bal
#define PL_BMO  pay_line.bmo
#define PL_BDAY pay_line.bday
#define PL_BYR  pay_line.byr
#define PL_BAMT pay_line.bamt
#define PL_PMO  pay_line.pmo
#define PL_PDAY pay_line.pday
#define PL_PYR  pay_line.pyr
#define PL_PAMT pay_line.pamt
           char all_blnks[256];
#define SPACES all_blnks
	   int xx,yy,zz;

static struct {
         char *txt;
          } msg_text[16] =
	{
	{""},
	{"NAMES MUST BE ALPHABETIC, AND SURNAME IS REQUIRED.          "},
	{"ENTER SOME INPUT AND USE ONLY 'CLEAR' OR 'ENTER'.           "},
	{"REQUEST TYPE REQUIRED; MUST BE 'D', 'P', 'A', 'M', OR 'X'.  "},
	{"PRINTER NAME REQUIRED ON PRINT REQUESTS.                    "},
	{"ACCOUNT NUMBER REQUIRED (BETWEEN 10000 AND 79999).          "},
	{"ACCOUNT NO. MUST BE NUMERIC AND FROM 10000 AND 79999.       "},
	{"NO NAMES ON FILE MATCHING YOUR REQUEST.                     "},
	{"ENTER EITHER NAME OR A REQUEST TYPE AND ACCOUNT NUMBER.     "},
	{"THIS ACCOUNT NUMBER ALREADY EXISTS.                         "},
	{"NO RECORD OF THIS ACCOUNT NUMBER.                           "},
	{"THIS ACCOUNT NUMBER ALREADY IN USE AT TERMIMAL.             "},
	{"PRINT REQUEST SCHEDULED.                                    "},
	{"PRINTER NAME NOT RECOGNIZED.                                "},
	{"INPUT ERROR; PLEASE RETRY; USE ONLY 'CLEAR' OR 'ENTER' KEY. "},
	{"THERE ARE MORE MATCHING NAMES. PRESS PA2 TO CONTINUE.       "}
	};
#define MESG msg_text[msg_no].txt
static struct {
         char *txtx;
          } msgx_text[16] =
	{
	{"ENTER 'Y' TO CONFIRM OR 'CLEAR' TO CANCEL.                  "},
	{"FILL IN AND PRESS 'ENTER,' OR 'CLEAR' TO CANCEL.            "},
	{"MAKE CHANGES AND 'ENTER' OR 'CLEAR' TO CANCEL.              "},
	{"PRESS 'CLEAR' OR 'ENTER' WHEN FINISHED.                     "}
	};
#define MESGX(a) msgx_text[a].txtx

#if defined(__STDC__) || defined(__cplusplus)
int is_it_alpha(char *p1,int p2)
#else
int is_it_alpha(p1,p2)
char *p1;
int p2;
#endif
{
	int i;

	for ( i=0; i < p2; i++)
	   {
	   if (!isalpha(*(p1 + i)) && *(p1 +i) != ' ') return(0);
	   }
	return(1);
}
#if defined(__STDC__) || defined(__cplusplus)
int is_it_digit(char *p1,int p2)
#else
int is_it_digit(p1,p2)
char *p1;
int p2;
#endif
{
	int i;

	for ( i=0; i < p2; i++)
	   {
	   if (!isdigit(*(p1 + i)) && *(p1 +i) != ' ') return(0);
	   }
	return(1);
}
#if defined(__STDC__) || defined(__cplusplus)
void xform_sp2(char *p1,int p2,char c)
#else
void xform_sp2(p1,p2,c)
char *p1;
int p2;
char c;
#endif
{
	int i;

	for (i=0; i < p2; i++)
	   {
	   if (*(p1 + i) == ' ') *(p1 + i) = c;
	   }
	return;
}
int main()
{
/* added by dv133961     */
           EXEC SQL WHENEVER NOT FOUND goto srch_done;
	   EXEC SQL WHENEVER SQLERROR goto srch_done;
	   EXEC SQL WHENEVER SQLWARNING goto srch_done;

/* end add              */

	   memset((char *)&stars,'*',sizeof(stars));
	   memset((char *)&SPACES,' ',sizeof(SPACES));
	   memset((char *)&in_area,' ',sizeof(in_area));
	   memset((char *)&srch_ctrl,' ',sizeof(srch_ctrl));
	   memcpy(USE_QID1,"BC0",sizeof(USE_QID1));
	   srch_ctrl.filr1 = 'S';
	   com_area.ctype = 'S';
	   IN_TYPE = 'R';
	   EXEC CICS ADDRESS EIB(prm1) COMMAREA(prm2);
	   if ((unsigned long)prm2 != 0xff000000)
	      {
	      memcpy((char *)&com_area,prm2,prm1->eibcalen);
	      }

	   memset((char *)&MNUI,0,sizeof(MNUI));
	   memset((char *)&acctdtl.acctdtli,0,sizeof(acctdtl.acctdtli));
	   line_cnt = 0;
	   msg_no = 0;
	   /* CHECK BASIC  REQUEST TYPE. */
	   if (prm1->eibaid == DFHCLEAR)
	      {
	      if (prm1->eibcalen == 0)
		 {
		 EXEC CICS SEND CONTROL FREEKB;
		 EXEC CICS RETURN;
		 }
	      else
		 {
		 goto new_menu;
		 }
	      }
	   if ((prm1->eibaid == DFHPA2) &&
	       (prm1->eibcalen > 0)     &&
	       (com_area.ctype == 'S'))
	      {
	      memcpy((char *)&srch_ctrl,com_area.srch_comm,prm1->eibcalen);
	      goto srch_resume;
	      }
	   if ((prm1->eibcalen > 0) && (com_area.ctype == 'R'))
	      {
	      memcpy((char *)&IN_AREA,com_area.srch_comm,prm1->eibcalen);
	      }

	   /* GET INPUT AND CHECK REQUEST TYPE FURTHER. */
	   EXEC CICS RECEIVE MAP("acctmnu")
		     MAPSET("ACCTSET")
		     RESP(myresp)
		     RESP2(myresp2);
	   if (myresp == DFHRESP(MAPFAIL))
	      goto no_map;

	   if (MNUI.reqml) REQC = MNUI.reqmi;
	   if (MNUI.reqmf != '\0') REQC = ' ';

	   if (MNUI.acctml) memcpy(ACCTC,MNUI.acctmi,sizeof(MNUI.acctmi));
	   if (MNUI.acctmf != '\0') memset((char *)&ACCTC,' ',sizeof(ACCTC));

	   if (MNUI.prtrml) memcpy(PRTRC,MNUI.prtrmi,sizeof(MNUI.prtrmi));
	   if (MNUI.prtrmf != '\0') memset((char *)&PRTRC,' ',sizeof(PRTRC));

	   if (MNUI.snameml) memcpy(SNAMEC,MNUI.snamemi,sizeof(MNUI.snamemi));
	   if (MNUI.snamemf != '\0') memset((char *)&SNAMEC,' ',sizeof(SNAMEC));

	   if (MNUI.fnameml) FNAMEC[0] = MNUI.fnamemi;

	   if (MNUI.fnamemf != '\0') memset((char *)&FNAMEC,' ',sizeof(FNAMEC));

	   memset((char *)&MNUI,0,sizeof(MNUI));

	   if (memcmp
	    ((char *)&in_area.in_names,SPACES,sizeof(in_area.in_names)) == 0)
	      {
	      goto ck_any;
	      }
	   if (!isalpha(FNAMEC[0]) &&
	       FNAMEC[0] != ' ')
	      {
	      msg_no = 1;
	      MNUI.fnameml = -1;
	      MNUO.fnamema = DFHBMBRY;
	      }

	   if (memcmp((char *)&SNAMEC,SPACES,sizeof(SNAMEC)) == 0)
	      {
	      memcpy(MNUO.snamemo,stars,sizeof(stars));
	      }
	   else
	   if (is_it_alpha(SNAMEC,sizeof(SNAMEC)))
	      {
	      goto ck_name;
	      }
	   else
	      {
	      msg_no = 1;
	      MNUI.snameml = -1;
	      MNUO.snamema = DFHBMBRY;
	      }
ck_name:
	   if (msg_no > 0) goto menu_resend;
srch_init:
	   memcpy(BRKEY_SNAME,SNAMEC,sizeof(BRKEY_SNAME));
	   memcpy(MAX_SNAME,SNAMEC,sizeof(MAX_SNAME));
	   memset((char *)&BRKEY_ACCT,0,sizeof(BRKEY_ACCT));
	   xform_sp2(MAX_SNAME,sizeof(MAX_SNAME),(char)0xff);

	   memcpy(MIN_FNAME,FNAMEC,sizeof(MIN_FNAME));
	   memcpy(MAX_FNAME,FNAMEC,sizeof(MAX_FNAME));
	   xform_sp2(MIN_FNAME,sizeof(MIN_FNAME),(char)0x00);
	   xform_sp2(MAX_FNAME,sizeof(MAX_FNAME),(char)0xff);
srch_resume:
  /*   commented by dv133961    */
  /*         EXEC CICS STARTBR DATASET("ACCTIX")    */
  /*			     RIDFLD(BRKEY)          */
  /*			     GTEQ                   */
  /*			     RESP(myresp)           */
  /*			     RESP2(myresp2);        */
  /*   end comment                                  */

  /*   added by dv133961                            */
             memcpy (acctrec.snamedo, BRKEY_SNAME, sizeof(BRKEY_SNAME));
             EXEC SQL
                 DECLARE C1 CURSOR FOR
			SELECT DOACCT, DOSNAME, DOSFNAME,
                           DOMI, DOTTL, DOADDR1, DOLIMIT
                           FROM ACTREC
                           WHERE DOSNAME >= :acctrec.snamedo
                           ORDER BY DOSNAME;


  /*   end add                                      */
  /*   commented by dv133961                        */
  /*	   if (myresp == DFHRESP(NOTFND))           */
  /*	      goto srch_any;                        */
  /*   end comment                                  */


/* added by dv133961                */
           EXEC SQL
                   OPEN C1;

/* end add                         */
srch_loop:

           EXEC SQL FETCH C1 INTO
                        :acixrec.acctdo, :acixrec.snamedo,
                        :acixrec.fnamedo,
                        :acixrec.mido, :acixrec.ttldo,
                        :acixrec.addr1do, :acixrec.limitdo;
/* commented by dv133961            */
/*	   EXEC CICS READNEXT DATASET("ACCTIX")    */
/*			      INTO(ACIXREC)        */
	/*		      LENGTH(acix_lng)     */
	/*		      RIDFLD(BRKEY)        */
	/*		      RESP(myresp)         */
	/*		      RESP2(myresp2);      */
	/*   if (myresp == DFHRESP(ENDFILE))       */
	 /*     goto srch_done;                    */
/* end comment                                     */
fetch_done:

	   if (memcmp((char *)&SNAMEDO,MAX_SNAME,sizeof(MAX_SNAME)) > 0)
	      goto srch_done;

	   if ((memcmp((char *)&FNAMEDO,MIN_FNAME,sizeof(MIN_FNAME)) < 0) ||
	       (memcmp((char *)&FNAMEDO,MAX_FNAME,sizeof(MAX_FNAME)) > 0))
	      goto srch_loop;
	   line_cnt += 1;
	   if (line_cnt > max_lines)
	      {
	      msg_no = 15;
	      memcpy((char *)&MNUO.msgmo,MESG,strlen(MESG));
	      MNUO.msgma = DFHBMBRY;
	      goto srch_done;
	      }
	   memset((char *)&SL_SUM_LINE,' ',sizeof(SL_SUM_LINE));
	   memcpy(SL_SNAMEDO,SNAMEDO,sizeof(SL_SNAMEDO));
	   memcpy(SL_ACCTDO,ACCTDO,sizeof(SL_ACCTDO));
	   memcpy(SL_FNAMEDO,FNAMEDO,sizeof(SL_FNAMEDO));
	   SL_MIDO = MIDO[0];
	   memcpy(SL_TTLDO,TTLDO,sizeof(SL_TTLDO));
	   memcpy(SL_ADDR1DO,ADDR1DO,sizeof(SL_ADDR1DO));
	   memcpy(SL_STATDO,STATDO,sizeof(SL_STATDO));
	   memcpy(SL_LIMITDO,LIMITDO,sizeof(SL_LIMITDO));

	   memcpy(MNUO.sumlnmd[line_cnt - 1].sumlnmo,(char *)&SL_SUM_LINE,
	      sizeof(MNUO.sumlnmd[line_cnt - 1].sumlnmo));
	   goto srch_loop;
srch_done:
	      xx=0;
/*           EXEC CICS ENDBR DATASET("ACCTIX");   */
srch_any:
	   if (line_cnt == 0)
	      {
	      msg_no = 7;
	      MNUI.snameml = -1;
	      goto menu_resend;
	      }

	   for (xx=0; xx < 6; xx++) {
	       MNUO.sumlnmd[xx].sumlnma = DFHBMUNP;
           }

	   MNUO.msgma = DFHBMBRY;
	   MNUO.sumttlma = DFHBMASB;

           EXEC CICS SEND MAP("acctmnu")
			  MAPSET("acctset")
			  DATAONLY
			  ERASEAUP
			  FREEKB;
	   if (!(line_cnt > max_lines))
	      {
               EXEC CICS RETURN
                         TRANSID     ("AC01");
	      }
	   else
	      {
               EXEC CICS RETURN
                         TRANSID     ("AC01")
		         COMMAREA(SRCH_CTRL)
		         LENGTH(44);
	      }
ck_any:
	   if (memcmp((char *)&IN_REQ,SPACES,sizeof(IN_REQ)) == 0)
	      {
	      MNUI.snameml = -1;
	      msg_no = 8;
	      goto menu_resend;
	      }

	   if (memcmp((char *)&ACCTC,SPACES,sizeof(ACCTC)) == 0)
	      {
	      memcpy(MNUO.acctmo,stars,sizeof(MNUO.acctmo));
	      msg_no = 5;
	      goto acct_err;
	      }
	   else
	   if ((memcmp((char *)&ACCTC,"10000",sizeof(ACCTC)) < 0) ||
	       (memcmp((char *)&ACCTC,"79999",sizeof(ACCTC)) > 0) ||
	       (!(is_it_digit(ACCTC,sizeof(ACCTC)))))
	      {
	      msg_no = 6;
	      goto acct_err;
	      }

/* commented by dv133961     */
	   /*  EXEC CICS READ DATASET("ACCTFIL")  */
	/*		  INTO(AR_ACCTREC)        */
	/*		  LENGTH(acct_lng)        */
	/*		  RIDFLD(ACCTC)           */
	/*		  RESP(myresp)            */
	/*		  RESP2(myresp2);         */

	 /*  if (myresp == DFHRESP(NOTFND))       */
	  /*    goto no_acct_record;              */
/* end comment  */

/* added by dv133961   */
   EXEC SQL WHENEVER NOT FOUND goto no_acct_record;   
         memcpy(acctrec.acctdo, ACCTC, sizeof(ACCTC));
           EXEC SQL
           SELECT DOACCT, DOSNAME, DOSFNAME,
           DOMI, DOTTL, DOTEL, DOADDR1,
           DOADDR2, DOADDR3,
           DOAUTH1, DOAUTH2,
           DOAUTH3, DOAUTH4,
           DOCARDS, DOIMO, DOIDAY, DOIYR,
           DORSN, DOCCODE, DOAPPR, DOSCODE1,
           DOSCODE2, DOSODE3, DOSTAT, DOLIMIT
           INTO :acctrec.acctdo, :acctrec.snamedo, :acctrec.fnamedo,
                  :acctrec.mido, :acctrec.ttldo, :acctrec.teldo, 
                  :acctrec.addr1do,
                  :acctrec.addr2do, :acctrec.addr3do,
                  :acctrec.auth1do, :acctrec.auth2do,
                  :acctrec.auth3do, :acctrec.auth4do,
                  :acctrec.cardsdo, :acctrec.imodo, :acctrec.idaydo, 
                  :acctrec.iyrdo,
                  :acctrec.rsndo, :acctrec.ccodedo, :acctrec.apprdo, 
                  :acctrec.scode1do,
                  :acctrec.scode2do, :acctrec.scode3do, :acctrec.statdo, 
                  :acctrec.limitdo
           FROM ACTREC
           WHERE DOACCT = :acctrec.acctdo;
/*  end add   */
           if (REQC == 'A')
	      {
	      msg_no = 9;
	      goto acct_err;
	      }
           else goto ck_req;
no_acct_record:
           if (REQC == 'A') goto ck_req;
	   msg_no = 10;
acct_err:
	   MNUI.acctml = -1;
	   MNUO.acctma = DFHBMBRY;
ck_req:
           if ((REQC == 'D') ||
	       (REQC == 'P') ||
	       (REQC == 'A') ||
	       (REQC == 'M') ||
	       (REQC == 'X'))
	       {
	       if (msg_no == 0) goto ck_use;
	       else             goto menu_resend;
	       }

           if (REQC == ' ') MNUO.reqmo = '*';
	   MNUI.reqml = -1;
	   MNUO.reqma = DFHBMBRY;
	   msg_no = 3;
	   goto menu_resend;
ck_use:
           if ((REQC == 'P') ||
	       (REQC == 'D'))
	       goto build_map;

	   memcpy(USE_QID2,ACCTC,sizeof(USE_QID2));
	   EXEC CICS READQ TS QUEUE(&USE_QID)
			      INTO(&USE_REC)
			      ITEM(use_item)
			      LENGTH(use_lng)
			      RESP(myresp)
			      RESP2(myresp2);

	   if (myresp == DFHRESP(QIDERR))
	      goto q_iderr;

	   use_limit += USE_TIME;
	   if (use_limit > 236000)
	      {
	      USE_DATE += 1;
	      USE_TIME -= 236000;
	      }

	   memcpy((char *)&tmp_time,prm1->eibtime,sizeof(tmp_time));
	   memcpy((char *)&tmp_date,prm1->eibdate,sizeof(tmp_date));
	   if ((USE_DATE > tmp_date) ||
	      ((USE_DATE == tmp_date) && (USE_TIME >= tmp_time)))
	      {
	      msg_no = 11;
	      MNUI.acctml = -1;
	      MNUO.acctma = DFHBMBRY;
	      goto menu_resend;
	      }
q_iderr:
	   memcpy(USE_TERM,prm1->eibtrmid,sizeof(USE_TERM));
	   memcpy((char *)&USE_TIME,prm1->eibtime,sizeof(USE_TIME));
	   memcpy((char *)&USE_DATE,prm1->eibdate,sizeof(USE_DATE));
	   EXEC CICS WRITEQ TS QUEUE(&USE_QID)
			       FROM(&USE_REC)
			       LENGTH(use_lng);
build_map:
	   if (REQC == 'X')
	      {
	      memcpy(DTLO.titledo,"DELETION",8);
	      DTLI.vfydl = -1;
	      DTLO.vfyda = DFHBMUNP;
	      memcpy(DTLO.msgdo,MESGX(0),strlen(MESGX(0)));
	      }
	   else
	      DTLI.snamedl = -1;

	   if (REQC == 'A')
	      {
	      memcpy(DTLO.titledo,"NEW RECORD",10);
	      DTLO.stattlda = DFHPROTN;
	      DTLO.limitda = DFHPROTN;
	      DTLO.histtlda = DFHPROTN;
	      memcpy(DTLI.acctdi,ACCTC,sizeof(DTLI.acctdi));
	      memcpy(DTLO.msgdo,MESGX(1),strlen(MESGX(1)));
	      goto send_detail;
	      }

	   if (REQC == 'M')
	      {
	      memcpy(DTLO.titledo,"RECORD CHANGE",13);
	      memcpy(DTLO.msgdo,MESGX(2),strlen(MESGX(2)));
	      }
	   else
	   if (REQC == 'D')
	      memcpy(DTLO.msgdo,MESGX(3),strlen(MESGX(3)));

           memcpy(DTLO.acctdo,AR_ACCTDO,sizeof(DTLO.acctdo));
           memcpy(DTLO.snamedo,AR_SNAMEDO,sizeof(DTLO.snamedo));
           memcpy(DTLO.fnamedo,AR_FNAMEDO,sizeof(DTLO.fnamedo));
           DTLO.mido = AR_MIDO[0];
           memcpy(DTLO.ttldo,AR_TTLDO,sizeof(DTLO.ttldo));
           memcpy(DTLO.teldo,AR_TELDO,sizeof(DTLO.teldo));
           memcpy(DTLO.addr1do,AR_ADDR1DO,sizeof(DTLO.addr1do));
           memcpy(DTLO.addr2do,AR_ADDR2DO,sizeof(DTLO.addr2do));
           memcpy(DTLO.addr3do,AR_ADDR3DO,sizeof(DTLO.addr3do));
           memcpy(DTLO.auth1do,AR_AUTH1DO,sizeof(DTLO.auth1do));
           memcpy(DTLO.auth2do,AR_AUTH2DO,sizeof(DTLO.auth2do));
           memcpy(DTLO.auth3do,AR_AUTH3DO,sizeof(DTLO.auth3do));
           memcpy(DTLO.auth4do,AR_AUTH4DO,sizeof(DTLO.auth4do));
           DTLO.cardsdo = AR_CARDSDO[0];
           memcpy(DTLO.imodo,AR_IMODO,sizeof(DTLO.imodo));
           memcpy(DTLO.idaydo,AR_IDAYDO,sizeof(DTLO.idaydo));
           memcpy(DTLO.iyrdo,AR_IYRDO,sizeof(DTLO.iyrdo));
           DTLO.rsndo = AR_RSNDO[0];
           DTLO.ccodedo = AR_CCODEDO[0];
           memcpy(DTLO.apprdo,AR_APPRDO,sizeof(DTLO.apprdo));
           DTLO.scode1do = AR_SCODE1DO[0];
           DTLO.scode2do = AR_SCODE2DO[0];
           DTLO.scode3do = AR_SCODE3DO[0];
           memcpy(DTLO.statdo,AR_STATDO,sizeof(DTLO.statdo));
           memcpy(DTLO.limitdo,AR_LIMITDO,sizeof(DTLO.limitdo));

/* added by dv133961    */
/*	   memset ((char *)&req_commarea, ' ', sizeof(req_commarea));  */
           req_commarea.req_type = 'O';
           strncpy (req_commarea.req_acct, AR_ACCTDO, 5);
           EXEC CICS LINK PROGRAM ("ACCTFET")
                    COMMAREA (req_commarea)
                    LENGTH (53);  
           if (req_commarea.req_status == 'C') 
              goto lines_moved;
           xx = 0;
           memcpy(AR_BAL(xx),req_commarea.bal,sizeof(AR_BAL(xx))); 
           memcpy(AR_BMO(xx),req_commarea.bmo,sizeof(AR_BMO(xx)));
           memcpy(AR_BDAY(xx),req_commarea.bday,sizeof(AR_BDAY(xx)));
           memcpy(AR_BYR(xx),req_commarea.byr,sizeof(AR_BYR(xx)));
           memcpy(AR_BAMT(xx),req_commarea.bamt,sizeof(AR_BAMT(xx)));
           memcpy(AR_PMO(xx),req_commarea.pmo,sizeof(AR_PMO(xx)));
           memcpy(AR_PDAY(xx),req_commarea.pday,sizeof(AR_PDAY(xx)));
           memcpy(AR_PYR(xx),req_commarea.pyr,sizeof(AR_PYR(xx)));
           memcpy(AR_PAMT(xx),req_commarea.pamt,sizeof(AR_PAMT(xx)));
	   memset((char *)&PL_PAY_LINE,' ',sizeof(PL_PAY_LINE));
	   PL_PAY_LINE.fil09 = '/';
	   PL_PAY_LINE.fil10 = '/';
	   PL_PAY_LINE.fil13 = '/';
	   PL_PAY_LINE.fil14 = '/';
           memcpy(PL_BAL,AR_BAL(xx),sizeof(PL_BAL));
           memcpy(PL_BMO,AR_BMO(xx),sizeof(PL_BMO));
           memcpy(PL_BDAY,AR_BDAY(xx),sizeof(PL_BDAY));
           memcpy(PL_BYR,AR_BYR(xx),sizeof(PL_BYR));
           memcpy(PL_BAMT,AR_BAMT(xx),sizeof(PL_BAMT));
           memcpy(PL_PMO,AR_PMO(xx),sizeof(PL_PMO));
           memcpy(PL_PDAY,AR_PDAY(xx),sizeof(PL_PDAY));
           memcpy(PL_PYR,AR_PYR(xx),sizeof(PL_PYR));
           memcpy(PL_PAMT,AR_PAMT(xx),sizeof(PL_PAMT));
           memcpy(DTLO.hist1do,(char *)&PL_PAY_LINE,sizeof(DTLO.hist1do));
           req_commarea.req_type = 'F';
           memcpy (req_commarea.req_acct, AR_ACCTDO, 5);
           EXEC CICS LINK PROGRAM ("ACCTFET")
                    COMMAREA (req_commarea)
                    LENGTH (53);
           if (req_commarea.req_status == 'C') 
              goto lines_moved;
           xx = 1;
           memcpy(AR_BAL(xx),req_commarea.bal,sizeof(AR_BAL(xx))); 
           memcpy(AR_BMO(xx),req_commarea.bmo,sizeof(AR_BMO(xx)));
           memcpy(AR_BDAY(xx),req_commarea.bday,sizeof(AR_BDAY(xx)));
           memcpy(AR_BYR(xx),req_commarea.byr,sizeof(AR_BYR(xx)));
           memcpy(AR_BAMT(xx),req_commarea.bamt,sizeof(AR_BAMT(xx)));
           memcpy(AR_PMO(xx),req_commarea.pmo,sizeof(AR_pMO(xx)));
           memcpy(AR_PDAY(xx),req_commarea.pday,sizeof(AR_PDAY(xx)));
           memcpy(AR_PYR(xx),req_commarea.pyr,sizeof(AR_PYR(xx)));
           memcpy(AR_PAMT(xx),req_commarea.pamt,sizeof(AR_PAMT(xx)));
	   memset((char *)&PL_PAY_LINE,' ',sizeof(PL_PAY_LINE));
	   PL_PAY_LINE.fil09 = '/';
	   PL_PAY_LINE.fil10 = '/';
	   PL_PAY_LINE.fil13 = '/';
	   PL_PAY_LINE.fil14 = '/';

           memcpy(PL_BAL,AR_BAL(xx),sizeof(PL_BAL));
           memcpy(PL_BMO,AR_BMO(xx),sizeof(PL_BMO));
           memcpy(PL_BDAY,AR_BDAY(xx),sizeof(PL_BDAY));
           memcpy(PL_BYR,AR_BYR(xx),sizeof(PL_BYR));
           memcpy(PL_BAMT,AR_BAMT(xx),sizeof(PL_BAMT));
           memcpy(PL_PMO,AR_PMO(xx),sizeof(PL_PMO));
           memcpy(PL_PDAY,AR_PDAY(xx),sizeof(PL_PDAY));
           memcpy(PL_PYR,AR_PYR(xx),sizeof(PL_PYR));
           memcpy(PL_PAMT,AR_PAMT(xx),sizeof(PL_PAMT));
           memcpy(DTLO.hist2do,(char *)&PL_PAY_LINE,sizeof(DTLO.hist2do));


           req_commarea.req_type = 'F';
           memcpy (req_commarea.req_acct, AR_ACCTDO, 5);
           EXEC CICS LINK PROGRAM ("ACCTFET")
                    COMMAREA (req_commarea)
                    LENGTH (53);
           if (req_commarea.req_status == 'C') 
              goto lines_moved;
           xx = 2;
           memcpy(AR_BAL(xx),req_commarea.bal,sizeof(AR_BAL(xx))); 
           memcpy(AR_BMO(xx),req_commarea.bmo,sizeof(AR_BMO(xx)));
           memcpy(AR_BDAY(xx),req_commarea.bday,sizeof(AR_BDAY(xx)));
           memcpy(AR_BYR(xx),req_commarea.byr,sizeof(AR_BYR(xx)));
           memcpy(AR_BAMT(xx),req_commarea.bamt,sizeof(AR_BAMT(xx)));
           memcpy(AR_PMO(xx),req_commarea.pmo,sizeof(AR_pMO(xx)));
           memcpy(AR_PDAY(xx),req_commarea.pday,sizeof(AR_PDAY(xx)));
           memcpy(AR_PYR(xx),req_commarea.pyr,sizeof(AR_PYR(xx)));
           memcpy(AR_PAMT(xx),req_commarea.pamt,sizeof(AR_PAMT(xx)));
	   memset((char *)&PL_PAY_LINE,' ',sizeof(PL_PAY_LINE));
	   PL_PAY_LINE.fil09 = '/';
	   PL_PAY_LINE.fil10 = '/';
	   PL_PAY_LINE.fil13 = '/';
	   PL_PAY_LINE.fil14 = '/';

           memcpy(PL_BAL,AR_BAL(xx),sizeof(PL_BAL));
           memcpy(PL_BMO,AR_BMO(xx),sizeof(PL_BMO));
           memcpy(PL_BDAY,AR_BDAY(xx),sizeof(PL_BDAY));
           memcpy(PL_BYR,AR_BYR(xx),sizeof(PL_BYR));
           memcpy(PL_BAMT,AR_BAMT(xx),sizeof(PL_BAMT));
           memcpy(PL_PMO,AR_PMO(xx),sizeof(PL_PMO));
           memcpy(PL_PDAY,AR_PDAY(xx),sizeof(PL_PDAY));
           memcpy(PL_PYR,AR_PYR(xx),sizeof(PL_PYR));
           memcpy(PL_PAMT,AR_PAMT(xx),sizeof(PL_PAMT));
           memcpy(DTLO.hist3do,(char *)&PL_PAY_LINE,sizeof(DTLO.hist3do));
lines_moved:
           req_commarea.req_type = 'C';
           EXEC CICS LINK PROGRAM ("ACCTFET")
                    COMMAREA (req_commarea)
                    LENGTH (53);
/*  End add   */


	   if (REQC == 'M') goto send_detail;
	   else
	   if (REQC == 'P') goto print_proc;

           DTLO.snameda  = DFHBMASK;
           DTLO.fnameda  = DFHBMASK;
           DTLO.mida     = DFHBMASK;
           DTLO.ttlda    = DFHBMASK;
           DTLO.telda    = DFHBMASK;
           DTLO.addr1da  = DFHBMASK;
           DTLO.addr2da  = DFHBMASK;
           DTLO.addr3da  = DFHBMASK;
           DTLO.auth1da  = DFHBMASK;
           DTLO.auth2da  = DFHBMASK;
           DTLO.auth3da  = DFHBMASK;
           DTLO.auth4da  = DFHBMASK;
           DTLO.cardsda  = DFHBMASK;
           DTLO.imoda    = DFHBMASK;
           DTLO.idayda   = DFHBMASK;
           DTLO.iyrda    = DFHBMASK;
           DTLO.rsnda    = DFHBMASK;
           DTLO.ccodeda  = DFHBMASK;
           DTLO.apprda   = DFHBMASK;
           DTLO.scode1da = DFHBMASK;
           DTLO.scode2da = DFHBMASK;
           DTLO.scode3da = DFHBMASK;

send_detail:
           EXEC CICS SEND MAP("acctdtl")
			  MAPSET("acctset")
			  ERASE
			  FREEKB
			  CURSOR;

	   if (REQC == 'D')
	      {
              EXEC CICS RETURN
                        TRANSID("ACCT");
	      }
	   else
	      {
              EXEC CICS RETURN
                        TRANSID("AC02")
		        COMMAREA(IN_REQ)
		        LENGTH(6);
	      }
print_proc:
	   if (memcmp((char *)&PRTRC,SPACES,sizeof(PRTRC)) == 0)
	      {
	      memset((char *)&PRTRC,'*',sizeof(PRTRC));
	      msg_no = 4;
	      goto termid_err1;
	      }
           EXEC CICS START INTERVAL(12)
			   TRANSID("AC03")
			   FROM(DTLO)
			   LENGTH(dtl_lng)
			   TERMID(PRTRC)
			   RESP(myresp)
			   RESP2(myresp2);
	   if (myresp == DFHRESP(TERMIDERR))
	      goto termid_err;

	   msg_no = 12;
	   memcpy(MNUO.msgmo,MESG,strlen(MESG));
           EXEC CICS SEND MAP("acctmnu")
			  MAPSET("acctset")
			  DATAONLY
			  ERASEAUP
			  FREEKB;
              EXEC CICS RETURN
                        TRANSID("AC01");
termid_err:
	   msg_no = 13;
termid_err1:
	      MNUI.prtrml = -1;
	      MNUO.prtrma = DFHBMBRY;
menu_resend:
	/* ERROR PROCESSING, FOR ALL REQUESTS. */
	/* RESEND MENU SCREEN */
	   memcpy(MNUO.msgmo,MESG,strlen(MESG));
           EXEC CICS SEND MAP("acctmnu")
			  MAPSET("acctset")
			  CURSOR
			  DATAONLY
			  FRSET
			  FREEKB;
           EXEC CICS RETURN
                     TRANSID     ("AC01")
		     COMMAREA(IN_AREA)
		     LENGTH(41);
no_map:
	   if ((prm1->eibaid == DFHPA1) ||
	       (prm1->eibaid == DFHPA2) ||
	       (prm1->eibaid == DFHPA3) ||
	       (prm1->eibaid == DFHENTER))
	      {
	      msg_no = 2;
	      MNUI.snameml = -1;
	      goto menu_resend;
	      }
new_menu:
	   EXEC CICS SEND MAP("acctmnu")
		MAPSET("acctset")
		FREEKB
		ERASE;
           EXEC CICS RETURN TRANSID("AC01");
}
#if defined(__cplusplus)
}
#endif
