/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.jcics;

public class ByteAreaElement {
    public boolean bDebug = false;
    private int iSize;
    private int iDisplacement;
    private String sType;
    private String sDefaultValue;
    private String sName;

    public ByteAreaElement(String string, String string2, int n, String string3, int n2) {
        this.printMsg("Creating element=" + string + ", type=" + string2 + ", default=" + string3 + ", size=" + n + ", displacement=" + n2 + "<");
        this.sName = string;
        this.iSize = n;
        this.iDisplacement = n2;
        if (string2.equals("C") || string2.equals("N") || string2.equals("B2") || string2.equals("B4")) {
            this.sType = string2;
        } else {
            System.out.println("--> invalid value for byteArea element type, assuming character (C).");
            this.sType = "C";
        }
        this.sDefaultValue = string3;
    }

    public void printMsg(String string) {
        if (this.bDebug) {
            System.out.println(string);
        }
    }

    public String toString() {
        return "--> Element name=" + this.sName + ", size=" + this.iSize + ", type=" + this.sType + ", disp =" + this.iDisplacement + "<--";
    }

    public String toString(byte[] byArray) {
        if (this.sType.equals("B2") || this.sType.equals("B4")) {
            return "--> Element name=" + this.sName + ", size=" + this.iSize + ", type=" + this.sType + ", disp =" + this.iDisplacement + ", value=" + this.getIValue(byArray) + "<--";
        }
        return "--> Element name=" + this.sName + ", size=" + this.iSize + ", type=" + this.sType + ", disp =" + this.iDisplacement + ", value=" + this.getValue(byArray) + "<--";
    }

    public int getLength() {
        this.printMsg("The size for element=" + this.sName + " is " + this.iSize);
        return this.iSize;
    }

    public void setToDefaultValue(byte[] byArray) {
        this.printMsg("Setting element=" + this.sName + ", to the default value of >" + this.sDefaultValue + "<");
        this.setValue(byArray, this.sDefaultValue);
    }

    public String getValue(byte[] byArray) {
        this.printMsg("Getting the value for element=" + this.sName + "<");
        if (this.sType.equals("C") || this.sType.equals("N")) {
            return new String(this.getByteValue(byArray));
        }
        if (this.sType.equals("B2") || this.sType.equals("B4")) {
            return new Integer(this.getIValue(byArray)).toString();
        }
        return " ";
    }

    public int getIValue(byte[] byArray) {
        this.printMsg("Getting the integer value for element=" + this.sName + "<");
        if (this.sType.equals("C")) {
            System.out.println("*** ERROR *** Integer value was requested for the " + this.sName + " field");
            return 0;
        }
        if (this.sType.equals("N")) {
            try {
                return Integer.parseInt(this.getValue(byArray));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("*** ERROR *** getIValue problem for type N");
                return 0;
            }
        }
        if (this.sType.equals("B2")) {
            return this.TwoBytesToInt(this.getByteValue(byArray));
        }
        if (this.sType.equals("B4")) {
            return this.FourBytesToInt(this.getByteValue(byArray));
        }
        return 0;
    }

    public byte[] getByteValue(byte[] byArray) {
        this.printMsg("Getting byte value");
        byte[] byArray2 = new byte[this.iSize];
        int n = 0;
        for (int i = this.iDisplacement; i < this.iDisplacement + this.iSize; ++i) {
            byArray2[n] = byArray[i];
            ++n;
        }
        return byArray2;
    }

    public int getDisplacement() {
        this.printMsg("Element=" + this.sName + ", displacement=" + this.iDisplacement);
        return this.iDisplacement;
    }

    public String getType() {
        this.printMsg("Element=" + this.sName + ", type=" + this.sType + "<");
        return this.sType;
    }

    public void setByteValue(byte[] byArray, byte[] byArray2) {
        this.printMsg("Setting the byte values: element=" + this.sName + ", size=" + this.iSize + ", bytes to be moved =" + byArray2.length + ", displacement =" + this.iDisplacement);
        int n = this.iSize;
        if (byArray2.length < n) {
            n = byArray2.length;
        }
        int n2 = 0;
        for (int i = this.iDisplacement; i < this.iDisplacement + n; ++i) {
            this.printMsg("i=" + i + ", j=" + n2);
            byArray[i] = byArray2[n2];
            ++n2;
        }
    }

    public byte[] setValue(byte[] byArray, byte[] byArray2) {
        this.setByteValue(byArray, byArray2);
        return byArray2;
    }

    public int setValue(byte[] byArray, int n) {
        this.printMsg("Setting the intger values for element=" + this.sName + ", value=" + n);
        if (this.sType.equals("C") || this.sType.equals("N")) {
            this.setValue(byArray, new Integer(n).toString());
        }
        if (this.sType.equals("B2")) {
            if (n > 65535) {
                System.out.println("*** ERROR *** Value of a 2 byte binary location cannot be greater then 65,535; changing to 0, element=" + this.sName);
                n = 0;
            }
            byte[] byArray2 = new byte[2];
            if (n > 255) {
                int n2 = n / 256;
                byArray2[0] = new Integer(n2).byteValue();
                byArray2[1] = new Integer(n - n2 * 256).byteValue();
            } else {
                byArray2[0] = 0;
                byArray2[1] = (byte)n;
            }
            this.setByteValue(byArray, byArray2);
        }
        if (this.sType.equals("B4")) {
            int n3;
            if (n > Integer.MAX_VALUE) {
                System.out.println("*** ERROR *** Value of a 4 byte binary location cannot be greater then 2,147,483,647; changing to 0, element=" + this.sName);
                n = 0;
            }
            int n4 = n;
            byte[] byArray3 = new byte[4];
            if (n4 > 0xFFFFFF) {
                n3 = n4 / 0x1000000;
                byArray3[0] = new Integer(n3).byteValue();
                n4 -= n3 * 0x1000000;
            } else {
                byArray3[0] = 0;
            }
            if (n4 > 65535) {
                n3 = n4 / 65536;
                byArray3[1] = new Integer(n3).byteValue();
                n4 -= n3 * 65536;
            } else {
                byArray3[1] = 0;
            }
            if (n4 > 255) {
                n3 = n4 / 256;
                byArray3[2] = new Integer(n3).byteValue();
                byArray3[3] = new Integer(n4 - n3 * 256).byteValue();
            } else {
                byArray3[2] = 0;
                byArray3[3] = (byte)n4;
            }
            this.setByteValue(byArray, byArray3);
        }
        return n;
    }

    public String setValue(byte[] byArray, String string) {
        this.printMsg("Setting the string value for element=" + this.sName + ", value=" + string + "<");
        if (this.sType.equals("C")) {
            this.setByteValue(byArray, new String((string + "                                                                                                                                                                                                                                                                ").substring(0, this.iSize)).getBytes());
        }
        if (this.sType.equals("N")) {
            String string2 = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000" + string;
            int n = string2.length() - this.iSize;
            this.setByteValue(byArray, string2.substring(n).getBytes());
        }
        if (this.sType.equals("B2") || this.sType.equals("B4")) {
            try {
                this.setValue(byArray, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("The value for " + this.sName + " is not numeric, setting value to 0");
                this.setValue(byArray, 0);
            }
        }
        this.printMsg("=> value set:" + this.toString(byArray));
        return string;
    }

    private int TwoBytesToInt(byte[] byArray) {
        int n;
        this.printMsg("Converting bytes to integer");
        int n2 = byArray[1];
        if (n2 < 0) {
            n2 = 129 + n2 + 127;
        }
        if ((n = byArray[0]) < 0) {
            n = 129 + n + 127;
        }
        return n * 256 + n2;
    }

    private int FourBytesToInt(byte[] byArray) {
        this.printMsg("Converting bytes to integer");
        byte[] byArray2 = new byte[]{byArray[2], byArray[3]};
        int n = this.TwoBytesToInt(byArray2);
        int n2 = this.TwoBytesToInt(byArray);
        return n2 * 256 * 256 + n;
    }
}

