/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.TransactionClassData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class TransactionClass
extends BaseMBean {
    public TransactionClass(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public TransactionClass(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new TransactionClassData());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("txTotal", "Total number of transactions executed"));
        treeSet.add(new TMonitorAttribute("txAbort", "Total number of transactions aborted"));
        treeSet.add(new TMonitorAttribute("txRate", "Current transaction rate per second"));
        treeSet.add(new TMonitorAttribute("txMaxRate", "Peak transaction rate per second"));
        treeSet.add(new TMonitorAttribute("txWaiting", "Current number of transactions waiting to be processed"));
        treeSet.add(new TMonitorAttribute("txMaxWaiting", "Maximum number of transactions forced to wait for a transaction processor"));
        treeSet.add(new TMonitorAttribute("txDeadlock", "Total number of transactions that encountered a deadlock"));
        treeSet.add(new TMonitorAttribute("serverRestarts", "Total number of transaction processor restarts"));
        treeSet.add(new TMonitorAttribute("txSystemProcessorTime", "Total system processor (CPU) time used by this transaction class"));
        treeSet.add(new TMonitorAttribute("txUserProcessorTime", "Total user processor (CPU) time used by this transaction class"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("txServers", "Total number of transaction processors assigned to this class", true, false));
        treeSet.add(new TConfigAttribute("group", "Group assigned to this transaction class", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTxTotal() {
        return ((TransactionClassData)this.getData()).txTotal;
    }

    public float getTxRate() {
        return ((TransactionClassData)this.getData()).txRate;
    }

    public float getTxMaxRate() {
        return ((TransactionClassData)this.getData()).txMaxRate;
    }

    public int getTxAbort() {
        return ((TransactionClassData)this.getData()).txAbort;
    }

    public int getTxWaiting() {
        return ((TransactionClassData)this.getData()).txWaiting;
    }

    public int getTxMaxWaiting() {
        return ((TransactionClassData)this.getData()).txMaxWaiting;
    }

    public int getTxDeadlock() {
        return ((TransactionClassData)this.getData()).txDeadlock;
    }

    public int getServerRestarts() {
        return ((TransactionClassData)this.getData()).serverRestarts;
    }

    public int getTxSystemProcessorTime() {
        return ((TransactionClassData)this.getData()).systemProcessorTime;
    }

    public int getTxUserProcessorTime() {
        return ((TransactionClassData)this.getData()).userProcessorTime;
    }

    public short getTxServers() {
        return ((TransactionClassData)this.getData()).txServers;
    }

    public String getGroup() {
        return ((TransactionClassData)this.getData()).group;
    }
}

