/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.util;

import com.sun.emp.mtp.ipc.MessageQueue;
import com.sun.emp.mtp.ipc.MessageQueueFactory;
import com.sun.emp.mtp.ipc.PrintMessage;
import com.sun.emp.mtp.util.Constants;

public class PrintTrace
implements Constants {
    private static PrintTrace singleton = new PrintTrace();
    private MessageQueue printQueue;
    private PrintMessage printMessage;

    public static PrintTrace getInstance() {
        return singleton;
    }

    private PrintTrace() {
        try {
            this.printQueue = MessageQueueFactory.getQueue(6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.printQueue == null) {
            System.out.println("*** PrintTrace[constructor] Failed to open print queue");
            System.exit(1);
        }
        this.printMessage = new PrintMessage();
    }

    public synchronized void log(String string, String string2) {
        if (!this.printQueue.send(this.printMessage.getBuffer(string, string2, 0), true)) {
            System.out.println(string + "\t:" + string2);
        }
    }

    public synchronized void err(String string, String string2) {
        if (!this.printQueue.send(this.printMessage.getBuffer(string, string2, 1), true)) {
            System.out.println(string + "\t:" + string2);
        }
    }

    public synchronized void dbg(String string, String string2) {
        if (!this.printQueue.send(this.printMessage.getBuffer(string, string2, 2), true)) {
            System.out.println(string + "\t:" + string2);
        }
    }
}

