#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2003 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#

# ***********************************************
# Setup up local variables
# ***********************************************
echo "Setting up local variables"

COBOL=cob

#
# Default Cobol flag settings (none).
#

COBFLAGS=-ia

# cobol option for online programs
COBOPT="cics ibmcomp noalter notrunc defaultbyte=0 ans85"

# cobol option for batch programs
COBOPT1="ibmcomp noalter notrunc defaultbyte=0 ans85"       
PCC=procob
# does an Oracle 32 bit lib exist ?
if test -d ${ORACLE_HOME}/lib32;
        then
        if test -f ${ORACLE_HOME}/bin/procob32;
            then
                PCC=procob32
        else
                PCC=procob
         fi
        fi                                              
echo "Note: using $PCC for Oracle precompiles"
echo " "
sleep 3
# ***********************************************

#
# ACCTSET
#
echo "Compiling ACCTSET.bms"
kixbms -a -c ACCTSET.bms


#
# ACCT00
#
echo "Translating ACCT00"
kixclt -d oracle ACCT00.clt
echo "Compiling ACCT00.cbl"
$COBOL $COBFLAGS -C $COBOPT ACCT00.cbl


#
# ACCT01
#
echo "Precompiling ACCT01"
$PCC ACCT01.pco ACCT01.clt \
include=$ORACLE_HOME/precomp/public \
include=$UNIKIX/src/CICS_structures \
ireclen=132 maxliteral=161 mode=ansi hold_cursor=no release_cursor=yes \
maxopencursors=50 dbms=v7 
echo "Translating ACCT01"
kixclt -d oracle ACCT01.clt
echo "Compiling ACCT01.cbl"
$COBOL $COBFLAGS -C $COBOPT ACCT01.cbl


#
# ACCT02
#
echo "Precompiling ACCT02"
$PCC ACCT02.pco ACCT02.clt \
include=$ORACLE_HOME/precomp/public \
include=$UNIKIX/src/CICS_structures \
ireclen=132 maxliteral=161 mode=ansi hold_cursor=no release_cursor=yes \
maxopencursors=50 dbms=v7 
echo "Translating ACCT02"
kixclt -d oracle ACCT02.clt
echo "Compiling ACCT02.cbl"
$COBOL $COBFLAGS -C $COBOPT ACCT02.cbl


#
# ACCTFET
#
echo "Precompiling ACCTFET"
$PCC ACCTFET.pco ACCTFET.clt \
include=$ORACLE_HOME/precomp/public \
include=$UNIKIX/src/CICS_structures \
ireclen=132 maxliteral=161 mode=ansi hold_cursor=no release_cursor=yes \
maxopencursors=50 dbms=v7 
echo "Translating ACCTFET"
kixclt -d oracle ACCTFET.clt
echo "Compiling ACCTFET.cbl"
$COBOL $COBFLAGS -C $COBOPT ACCTFET.cbl


#
# ACCTBTCH 
#
echo "Precompiling ACCTBTCH"
$PCC ACCTBTCH.bth ACCTBTCH.cob \
include=$ORACLE_HOME/precomp/public \
include=$UNIKIX/src/CICS_structures \
ireclen=132 maxliteral=161 mode=ansi hold_cursor=no release_cursor=yes \
maxopencursors=50 dbms=v7 
echo "compiling ACCTBTCH.cob"
$COBOL $COBFLAGS -C $COBOPT1 ACCTBTCH.cob
