/**********************************************************************/
/*                                                                    */
/* Copyright (c) 2003 by Sun Microsystems, Inc.                       */
/* All rights reserved.                                               */
/*                                                                    */
/**********************************************************************/

package scouser;

import javax.jms.*;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import com.ibm.cics.server.Program;
import com.ibm.mq.MQException;
import com.ibm.mq.jms.*;
import com.sun.emp.mtp.MQJMS.*;

public class GetAliasJMSListenerExMQJMS implements MessageListener
{
/*
        ****************************************************************
	This program class is a user JMS application example:
	It 1). Reads in a name from an MQSeries input queue using JMS.
	   2). Passes the name to a JCICS 'alias' finder program
	       using the JCICS a.p.i.
	   3). Builds message with the name and alias from 'finder' pgm.
           4). Builds a connection to an MQSeries output queue using JMS.
	   5). Places the constructed message on the MQSeries output queue.
        ****************************************************************
*/
	QueueConnection c = null;
	QueueSession s = null;
	QueueSender qs = null;
	byte[]  buf2 = new byte[80];
	char inline[] = null;
	int length = 0;
	String name = null;
	
	public void onMessage(Message message)
	{
		// Initialize a queue connection for the output 
		// name + alias response
		init();

	try     {
		if (message instanceof BytesMessage) {

		// BytesMessage Format:
		// Created by the 'kixmqtst' queue loading program
		do {
                   length = ((BytesMessage)message).readBytes(buf2);
                   if (length != -1)    
		      {
		      inline = new char[length];
                      for (int i = 0; i < length; i++) {
                        inline[i] = (char)buf2[i];
                        }
                      }
                   } while (length >= 80);
		name = String.copyValueOf(inline);
		}
		else if (message instanceof TextMessage) {

		// TextMessage Format:
		// Created by the 'amqsputc' queue loading program
		name = ((TextMessage)message).getText();
		}
  
		// The following code prepares a COMMAREA with
		// name and passes it on a JCICS A.P.I. link
		// to another program 'JMQGTAL' that will find and return
		// the corresponding alias

		Program theProgram = new Program();
		theProgram.setName("JMQGTAL");	// = DPL version of GetAlias
		GetAliasCommAreaRecord ca = new GetAliasCommAreaRecord();
		
		// populate the COMMAREA with the name to lookup
		ca.CA.setValue("name", name);
		
		// Do the JCICS api link
		theProgram.link( ca );

		// retrieve alias from the COMMAREA
		String alias = ca.CA.getValue("alias").trim();	

		// Prepare a TextMessage using the name and alias
		TextMessage m = s.createTextMessage();
		String msg = "Alias for " + name + " = " + alias;

		// Send it to the queue
		m.setText(msg);
		qs.send(m);		
		} catch (JMSException e) {e.printStackTrace();}
		  catch (Exception e) {e.printStackTrace();}
	}
	
	private static MQJMSProps dp = null;
	
	private void init() {

		// The following method illustrates an example of what
		// must be done to setup an MQSeries queue using the
		// JMS facility. The output response from the application
		// 'GetAlias' can then be sent to this queue.

		// Avoid unecessary trips thru here
		if ( dp != null) return;

		dp= new MQJMSProps(); 
		try {
		MQQueueConnectionFactory qcf = new MQQueueConnectionFactory();
		qcf.setHostName(dp.defHost);	// from MQJMS.properties
		qcf.setChannel(dp.defChann);	// from MQJMS.properties
		Integer portn = new Integer((String)dp.defPort);
		qcf.setPort(portn.intValue()); // Use MQJMS.properties 'port'
		
		if (dp.defHost.equals("localhost"))
		   qcf.setTransportType(JMSC.MQJMS_TP_BINDINGS_MQ);
		else
		   qcf.setTransportType(JMSC.MQJMS_TP_CLIENT_MQ_TCPIP);
		
		MQQueue q = new MQQueue();
		q.setBaseQueueName("UNIKIXMQ2");
		q.setTargetClient(JMSC.MQJMS_CLIENT_NONJMS_MQ);
		c = qcf.createQueueConnection();
		s = c.createQueueSession(dp.defTransact, 
					    Session.AUTO_ACKNOWLEDGE);
		qs = s.createSender(q);
		} 
		catch (JMSException e)
		{
			e.printStackTrace();
		}		
	}
}
