
      *****************************************************************
      *                                                               *
      * Copyright (c) 2001 by Sun Microsystems, Inc.                  *
      * All rights reserved.                                          *
      *                                                               *
      *****************************************************************

      * $Workfile:   KIXMQ01.cl2  $ $Revision:   1.0  $

       IDENTIFICATION DIVISION.
       PROGRAM-ID. KIXMQ01.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       working-storage section.

       01 MYRESP		PIC S9(8) COMP.

       01 TRIG-DATA-LENGTH      PIC S9(4) COMP VALUE IS 1024.

       01 TRIG-DATA.
       COPY CMQTML.
         15 MQTM-QMGR-NAME      PIC X(48).

      *
      **  Declare MQI structures needed
      * MQI named constants
       01 MY-MQ-CONSTANTS.
          COPY CMQV.
      * Object Descriptor
       01 OBJECT-DESCRIPTOR.
          COPY CMQODV.
      * Message Descriptor
       01 MESSAGE-DESCRIPTOR.
          COPY CMQMDV.
      * Get message options
       01 GMOPTIONS.
          COPY CMQGMOV.
      ** note, sample uses defaults where it can
       01 HCONN                      PIC S9(9) BINARY.
       01 Q-HANDLE                   PIC S9(9) BINARY.
       01 OPTIONS                    PIC S9(9) BINARY.
       01 COMPLETION-CODE            PIC S9(9) BINARY.
       01 OPEN-CODE                  PIC S9(9) BINARY.
       01 CON-REASON                 PIC S9(9) BINARY.
       01 REASON                     PIC S9(9) BINARY.
       01 BUFFER                     PIC X(256).
       01 BUFFER-LENGTH              PIC S9(9) BINARY.
       01 DATA-LENGTH                PIC S9(9) BINARY.
       01 WRITE-LENGTH               PIC S9(4) BINARY.

      ****************************************************************
       LINKAGE SECTION.
       PROCEDURE DIVISION.
       P0.

      *
      * Get the data we were started with.
      *
	   EXEC CICS RETRIEVE INTO(TRIG-DATA)
			      LENGTH(TRIG-DATA-LENGTH)
		END-EXEC.


           DISPLAY 'KIXMQ01: Queue Manager is ' MQTM-QMGR-NAME.
           DISPLAY 'KIXMQ01: Queue is ' MQTM-QNAME.

      ****************************************************************
      *                                                              *
      *   Connect to default queue manager                           *
      *                                                              *
      ****************************************************************
           CALL 'MQCONN'
            USING MQTM-QMGR-NAME, HCONN,
            COMPLETION-CODE, CON-REASON.

      *      report reason and stop if it failed
           IF COMPLETION-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'MQCONN ended with reason code ' CON-REASON
             DISPLAY TRIG-DATA
             EXEC CICS RETURN END-EXEC
             END-IF.
      *
      ****************************************************************
      *                                                              *
      *   Open the message queue (and fail if MQM is quiescing)      *
      *                                                              *
      ****************************************************************
       OPENS.
           MOVE MQTM-QNAME TO MQOD-OBJECTNAME.
           ADD MQOO-INPUT-AS-Q-DEF MQOO-FAIL-IF-QUIESCING
                     GIVING OPTIONS.
           CALL 'MQOPEN'
            USING HCONN, OBJECT-DESCRIPTOR,
            OPTIONS, Q-HANDLE,
            OPEN-CODE, REASON.

      *      report reason, if any; stop if failed
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQOPEN ended with reason code ' REASON
             DISPLAY TRIG-DATA
             END-IF.

           IF OPEN-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'unable to open queue for input'
             EXEC CICS RETURN END-EXEC
             END-IF.

      ****************************************************************
      *                                                              *
      *   Get messages from the message queue                        *
      *                                                              *
      ****************************************************************
       GETS.
           MOVE OPEN-CODE TO COMPLETION-CODE.
           PERFORM GETR THRU DISPR WITH TEST BEFORE
             UNTIL COMPLETION-CODE IS EQUAL TO MQCC-FAILED.

      ****************************************************************
      *                                                              *
      *   Close the source queue                                     *
      *                                                              *
      ****************************************************************
       CLOSES.
           MOVE MQCO-NONE TO OPTIONS.
           CALL 'MQCLOSE'
            USING HCONN, Q-HANDLE, OPTIONS,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQCLOSE ended with reason code ' REASON
             END-IF.

      ****************************************************************
      *                                                              *
      *  Disconnect from queue manager (if not previously connected) *
      *                                                              *
      ****************************************************************
       DISCS.
           IF CON-REASON IS NOT EQUAL TO MQRC-ALREADY-CONNECTED
             CALL 'MQDISC'
              USING HCONN, COMPLETION-CODE, REASON

      *      report reason, if any
             IF REASON IS NOT EQUAL TO MQRC-NONE
               DISPLAY 'MQDISC ended with reason code ' REASON
             END-IF
           END-IF.

       OVER.
      ** indicate that sample program has finished
           DISPLAY 'KIXMQ01: ended'.
             EXEC CICS RETURN END-EXEC.

      ****************************************************************
      *                                                              *
      *   Get one message                                            *
      *                                                              *
      *   In order to read the messages in sequence, MSGID and       *
      *   CORRELID must have the default value.  MQGET sets them     *
      *   to the values for the message it returns, so re-initialise *
      *   them each time                                             *
      *                                                              *
      ****************************************************************
       GETR.
           MOVE MQMI-NONE TO MQMD-MSGID.
           MOVE MQCI-NONE TO MQMD-CORRELID.
           MOVE SPACES TO BUFFER.
           MOVE MQGMO-NO-WAIT TO MQGMO-OPTIONS.
           MOVE 0 TO MQGMO-WAITINTERVAL.
           MOVE 256 to BUFFER-LENGTH.

           CALL 'MQGET'
            USING HCONN, Q-HANDLE,
            MESSAGE-DESCRIPTOR, GMOPTIONS,
            BUFFER-LENGTH, BUFFER, DATA-LENGTH,
            COMPLETION-CODE, REASON.

      ****************************************************************
      *                                                              *
      *   Display message received                                   *
      *                                                              *
      ****************************************************************
       DISPM.
           IF COMPLETION-CODE IS NOT EQUAL TO MQCC-FAILED
	     MOVE DATA-LENGTH TO WRITE-LENGTH
	     IF DATA-LENGTH IS NOT EQUAL TO 0
	     EXEC CICS WRITEQ TS QUEUE('MQTEST01') FROM(BUFFER)
		LENGTH(WRITE-LENGTH)
		END-EXEC
		END-IF
      *      DISPLAY 'message: <' BUFFER '>'
           END-IF.

      ****************************************************************
      *                                                              *
      *  Report reason, if any                                       *
      *                                                              *
      ****************************************************************
       DISPR.
           IF REASON IS NOT EQUAL TO MQRC-NONE
             IF REASON IS NOT EQUAL TO MQRC-NO-MSG-AVAILABLE
               DISPLAY 'MQGET ended with reason code ' REASON
             END-IF
           END-IF.

      ****************************************************************
      *                                                              *
      * END OF AMQ0GET0                                              *
      *                                                              *
      ****************************************************************
