/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.util;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EntryExitTrace {
    private static EntryExitTrace singleton = new EntryExitTrace();
    private CallDepth callDepth = new CallDepth();
    private SimpleDateFormat formatter = new SimpleDateFormat("MM.dd.yyyy hh:mm:ss.SSS");
    private PrintStream out;

    public static EntryExitTrace getInstance() {
        return singleton;
    }

    private EntryExitTrace() {
        this.outputTo(System.out);
    }

    public synchronized void entry(String string) {
        this.output(string + " {");
        ++((CallDepth)this.callDepth.get()).depth;
    }

    public synchronized void exit(String string) {
        --((CallDepth)this.callDepth.get()).depth;
        this.output("} " + string);
    }

    public synchronized void output(String string) {
        if (this.out != null) {
            int n = ((CallDepth)this.callDepth.get()).depth;
            StringBuffer stringBuffer = new StringBuffer(n * 4);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append("    ");
                ++n2;
            }
            this.out.println(this.formatter.format(new Date()) + " " + Thread.currentThread().getName() + " " + stringBuffer.toString() + string);
        }
    }

    public synchronized void outputTo(PrintStream printStream) {
        this.out = printStream;
    }

    class CallDepth
    extends ThreadLocal {
        public int depth;

        CallDepth() {
        }

        protected Object initialValue() {
            return new CallDepth();
        }
    }
}

