/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.server;

import com.ibm.cics.server.API;
import com.ibm.cics.server.CicsConditionException;
import com.ibm.cics.server.Cursor;
import com.ibm.cics.server.EndOfDataException;
import com.ibm.cics.server.IOErrorException;
import com.ibm.cics.server.InvalidRequestException;
import com.ibm.cics.server.InvalidRetrieveOptionException;
import com.ibm.cics.server.LengthErrorException;
import com.ibm.cics.server.RecordNotFoundException;
import com.ibm.cics.server.RetrieveBits;
import com.ibm.cics.server.RetrievedData;
import com.ibm.cics.server.RetrievedDataHolder;
import com.ibm.cics.server.RolledBackException;
import com.ibm.cics.server.TWAHolder;
import com.ibm.cics.server.TerminalPrincipalFacility;
import com.sun.emp.mtp.jcics.ExceptionHelper;
import com.sun.emp.mtp.jcics.NotImplementedException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.BitSet;

public class Task
extends API
implements RetrieveBits {
    public PrintWriter out;
    public PrintWriter err;
    public static final byte FCI_START_NO_DATA = 0;
    public static final byte FCI_START_WITH_DATA = 16;
    public static final byte FCI_TASK_WITH_FACILITY = 1;
    public static final byte FCI_TRIGGERED_NO_FACILITY = 8;
    private static Task instance = null;
    private static PrintWriter defaultOut;
    private static PrintWriter defaultErr;
    private static TerminalWriter terminalWriter;
    private static PrintWriter terminalPrintWriter;
    private Object principalFacility;
    private int twaLength;
    private byte fci;

    private Task() {
    }

    private static void initialize(byte by, byte[] byArray, int n) {
        if (instance == null) {
            defaultOut = new PrintWriter(System.out);
            defaultErr = new PrintWriter(System.err);
            terminalWriter = new TerminalWriter();
            terminalPrintWriter = new PrintWriter(terminalWriter);
            instance = new Task();
        }
        instance.initializeInstance(by, byArray, n);
    }

    private void initializeInstance(byte by, byte[] byArray, int n) {
        this.fci = by;
        this.twaLength = n;
        if (byArray != null) {
            String string = new String(byArray);
            if (!string.equals("    ")) {
                this.principalFacility = new TerminalPrincipalFacility(string);
                terminalWriter.reset();
                this.out = terminalPrintWriter;
                this.err = terminalPrintWriter;
            } else {
                this.principalFacility = null;
                this.out = defaultOut;
                this.err = defaultErr;
            }
        } else {
            this.principalFacility = null;
            this.out = defaultOut;
            this.err = defaultErr;
        }
        this.setProperties();
    }

    private native void setProperties();

    public void abend(String string) {
        if (string == null) {
            throw new NullPointerException("abcode is null");
        }
        if (string.length() != 4) {
            throw new IllegalArgumentException("abcode length is not 4");
        }
        this.performAbend(string);
    }

    public void commit() throws InvalidRequestException, RolledBackException {
        this.performCommit();
    }

    public void disableTaskTrace() {
        throw new NotImplementedException();
    }

    public void enableTaskTrace() {
        throw new NotImplementedException();
    }

    public void forceAbend(String string) {
        throw new NotImplementedException();
    }

    public byte getFCI() {
        return this.fci;
    }

    public Object getPrincipalFacility() {
        return this.principalFacility;
    }

    public String getQNAME() {
        return this.obtainQNameFromTCB();
    }

    public String getSTARTCODE() {
        return this.obtainStartCodeFromTCB();
    }

    public static Task getTask() {
        return instance;
    }

    public int getTaskNumber() {
        return this.obtainTaskNumberFromTCB();
    }

    public String getTransactionName() {
        return this.obtainTransactionName();
    }

    public void getTWA(TWAHolder tWAHolder) {
        tWAHolder.value = this.obtainTWAFromTCB();
    }

    public void setTWA(byte[] byArray) throws InvalidRequestException {
        if (this.twaLength == 0) {
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[]{2, 2};
            byArray2[0] = -32;
            byArray2[1] = 0;
            byArray2[2] = 0;
            byArray2[3] = 0;
            byArray2[4] = 0;
            byArray2[5] = 0;
            throw new InvalidRequestException(new ExceptionHelper(0, byArray2, byArray3));
        }
        if (byArray.length != this.twaLength) {
            throw new IllegalArgumentException("data.length != TWA length");
        }
        this.setTWAInTCB(byArray);
    }

    public String getUSERID() throws InvalidRequestException {
        if (this.principalFacility == null || !(this.principalFacility instanceof TerminalPrincipalFacility)) {
            byte[] byArray = new byte[6];
            byte[] byArray2 = new byte[]{2, 8};
            byArray[0] = -32;
            byArray[1] = 0;
            byArray[2] = 0;
            byArray[3] = 0;
            byArray[4] = 0;
            byArray[5] = 0;
            throw new InvalidRequestException(new ExceptionHelper(0, byArray, byArray2));
        }
        return this.obtainUserIdentifierFromTCB();
    }

    public void retrieve(BitSet bitSet, RetrievedDataHolder retrievedDataHolder) throws EndOfDataException, InvalidRequestException, InvalidRetrieveOptionException, IOErrorException, LengthErrorException, RecordNotFoundException {
        if (bitSet == null) {
            throw new NullPointerException("whatToRetrieve");
        }
        if (retrievedDataHolder == null) {
            throw new NullPointerException("holder");
        }
        byte by = 0;
        int n = 0;
        while (n < 4) {
            if (bitSet.get(n)) {
                by = (byte)(by | 1 << n);
            }
            ++n;
        }
        RetrievedData retrievedData = new RetrievedData();
        this.retrieveImpl(by, retrievedData);
        retrievedDataHolder.value = retrievedData;
    }

    public void rollback() throws InvalidRequestException {
        this.performRollback();
    }

    static byte[] getNextCOMMAREA() {
        Object object = instance.getPrincipalFacility();
        if (object == null) {
            return null;
        }
        if (!(object instanceof TerminalPrincipalFacility)) {
            return null;
        }
        return ((TerminalPrincipalFacility)object).getNextCOMMAREA();
    }

    static byte[] getNextTransaction() {
        Object object = instance.getPrincipalFacility();
        if (object == null) {
            return null;
        }
        if (!(object instanceof TerminalPrincipalFacility)) {
            return null;
        }
        return ((TerminalPrincipalFacility)object).getNextTransaction();
    }

    private native void performCommit() throws InvalidRequestException, RolledBackException;

    private native void performRollback() throws InvalidRequestException;

    private native void performAbend(String var1);

    private native String obtainQNameFromTCB();

    private native String obtainStartCodeFromTCB();

    private native int obtainTaskNumberFromTCB();

    private native String obtainTransactionName();

    private native String obtainUserIdentifierFromTCB();

    private native byte[] obtainTWAFromTCB();

    private native void setTWAInTCB(byte[] var1);

    private native void retrieveImpl(byte var1, RetrievedData var2);

    static {
        System.loadLibrary("kixjs2");
    }

    private static class TerminalWriter
    extends Writer {
        private Cursor cursor = new Cursor(80, 24);
        private boolean firstTime;

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            boolean bl = false;
            TerminalPrincipalFacility terminalPrincipalFacility = (TerminalPrincipalFacility)Task.getTask().principalFacility;
            if (this.firstTime) {
                try {
                    terminalPrincipalFacility.sendControl(this.cursor);
                }
                catch (CicsConditionException cicsConditionException) {
                    throw new IOException();
                }
                this.firstTime = false;
            }
            if (cArray[n + n2 - 1] == '\n') {
                bl = true;
                if (--n2 > 0 && cArray[n + n2 - 1] == '\r') {
                    --n2;
                }
            }
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                switch (cArray[n + n3]) {
                    case '\t': {
                        byArray[n3] = 32;
                        break;
                    }
                    default: {
                        byArray[n3] = (byte)cArray[n + n3];
                    }
                }
                ++n3;
            }
            this.cursor.increment(n2);
            if (bl) {
                this.cursor.incrementRow();
                this.cursor.setColumn(1);
            }
            try {
                terminalPrincipalFacility.send(byArray);
                terminalPrincipalFacility.sendControl(this.cursor);
            }
            catch (CicsConditionException cicsConditionException) {
                throw new IOException();
            }
        }

        void reset() {
            this.firstTime = true;
            this.cursor.setRow(1);
            this.cursor.setColumn(1);
        }
    }
}

