/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.TransactionConfig;
import com.sun.emp.mtp.admin.data.TransactionData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Transaction
extends BaseMBean {
    public Transaction(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public Transaction(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new TransactionData());
        this.setLocalConfig(new TransactionConfig());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("totalExecutions", "Total number of times this transaction has been executed"));
        treeSet.add(new TMonitorAttribute("totalAborts", "Total number of times this transaction has aborted"));
        treeSet.add(new TMonitorAttribute("totalProcessorTime", "Total processor (CPU) time used by this transaction (seconds)"));
        treeSet.add(new TMonitorAttribute("systemProcessorTime", "System processor (CPU) time used by this transaction (seconds)"));
        treeSet.add(new TMonitorAttribute("userProcessorTime", "User processor (CPU) time used by this transaction (seconds)"));
        treeSet.add(new TMonitorAttribute("totalStarts", "Total number of times this transaction START'ed"));
        treeSet.add(new TMonitorAttribute("totalInboundStarts", "Total number of inbound ISC Asynchronous Processing (AP) requests"));
        treeSet.add(new TMonitorAttribute("totalOutboundStarts", "Total number of outbound ISC Asynchronous Processing (AP) requests"));
        treeSet.add(new TMonitorAttribute("averageInboundStartMessageSize", "Average number of bytes per inbound AP request"));
        treeSet.add(new TMonitorAttribute("averageOutboundStartMessageSize", "Average number of bytes per outbound AP request"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("initialProgramName", "The initial program to be loaded for this transaction", true, false));
        treeSet.add(new TConfigAttribute("transactionClass", "Transaction Class assigned to this transaction", true, false));
        treeSet.add(new TConfigAttribute("screenSize", "Default/Alternate screen size", true, false));
        treeSet.add(new TConfigAttribute("accounting", "Accounting Option", true, false));
        treeSet.add(new TConfigAttribute("localQueueEnabled", "TRUE if local queueing enabled for this transaction", true, false));
        treeSet.add(new TConfigAttribute("appcEnabled", "TRUE if this is an APPC capable transaction", true, false));
        treeSet.add(new TConfigAttribute("remoteTransID", "Transaction ID if this transaction is remote", true, false));
        treeSet.add(new TConfigAttribute("remoteSystemID", "System ID where remote transaction configured", true, false));
        treeSet.add(new TConfigAttribute("group", "Group assigned to this transaction", true, false));
        treeSet.add(new TConfigAttribute("transactionSecurity", "Transaction security value (0 thru 64)", true, false));
        treeSet.add(new TConfigAttribute("fileID", "File ID assigned for accounting", true, false));
        treeSet.add(new TConfigAttribute("transactionWorkAreaSize", "Transaction Work Area size (bytes) for this transaction", true, false));
        treeSet.add(new TConfigAttribute("disabled", "TRUE if this transaction is disabled", true, false));
        treeSet.add(new TConfigAttribute("dumpSuppressed", "TRUE if dump processing is suppressed for this transaction", true, false));
        treeSet.add(new TConfigAttribute("AIDKey", "AID Key assigned to this transaction", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTotalExecutions() {
        return ((TransactionData)this.getData()).totalExecutions;
    }

    public int getTotalAborts() {
        return ((TransactionData)this.getData()).totalAborts;
    }

    public int getTotalProcessorTime() {
        return ((TransactionData)this.getData()).totalProcessorTime;
    }

    public int getSystemProcessorTime() {
        return ((TransactionData)this.getData()).systemProcessorTime;
    }

    public int getUserProcessorTime() {
        return ((TransactionData)this.getData()).userProcessorTime;
    }

    public int getTotalStarts() {
        return ((TransactionData)this.getData()).totalStarts;
    }

    public int getTotalInboundStarts() {
        return ((TransactionData)this.getData()).totalInboundStarts;
    }

    public int getTotalOutboundStarts() {
        return ((TransactionData)this.getData()).totalOutboundStarts;
    }

    public short getAverageInboundStartMessageSize() {
        return ((TransactionData)this.getData()).averageInboundStartMessageSize;
    }

    public short getAverageOutboundStartMessageSize() {
        return ((TransactionData)this.getData()).averageOutboundStartMessageSize;
    }

    public String getInitialProgramName() {
        return ((TransactionConfig)this.getConfig()).initialProgramName;
    }

    public String getTransactionClass() {
        return ((TransactionConfig)this.getConfig()).transactionClass;
    }

    public String getScreenSize() {
        return ((TransactionConfig)this.getConfig()).screenSize;
    }

    public char getAccounting() {
        return ((TransactionConfig)this.getConfig()).accounting;
    }

    public boolean isLocalQueueEnabled() {
        return ((TransactionConfig)this.getConfig()).localQueueEnabled;
    }

    public boolean isAppcEnabled() {
        return ((TransactionConfig)this.getConfig()).appcEnabled;
    }

    public boolean isDisabled() {
        return ((TransactionConfig)this.getConfig()).disabled;
    }

    public boolean isDumpSuppressed() {
        return ((TransactionConfig)this.getConfig()).nodump;
    }

    public String getRemoteTransID() {
        return ((TransactionConfig)this.getConfig()).remoteTransID;
    }

    public String getRemoteSystemID() {
        return ((TransactionConfig)this.getConfig()).remoteSystemID;
    }

    public String getGroup() {
        return ((TransactionConfig)this.getConfig()).group;
    }

    public short getTransactionSecurity() {
        return ((TransactionConfig)this.getConfig()).transactionSecurity;
    }

    public int getFileID() {
        return ((TransactionConfig)this.getConfig()).fileID;
    }

    public short getTransactionWorkAreaSize() {
        return ((TransactionConfig)this.getConfig()).transactionWorkAreaSize;
    }

    public String getAIDKey() {
        return ((TransactionConfig)this.getConfig()).AIDKey;
    }
}

