/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.RemoteConfig;
import com.sun.emp.mtp.admin.data.RemoteData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Remote
extends BaseMBean {
    public Remote(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public Remote(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new RemoteData());
        this.setLocalConfig(new RemoteConfig());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("totalRequestsInbound", "Total number of inbound ISC requests"));
        treeSet.add(new TMonitorAttribute("totalRequestsOutbound", "Total number of outbound ISC requests"));
        treeSet.add(new TMonitorAttribute("averageBytesInbound", "Average number of bytes per inbound ISC request"));
        treeSet.add(new TMonitorAttribute("averageBytesOutbound", "Average number of bytes per outbound ISC request"));
        treeSet.add(new TMonitorAttribute("statistics", "Inter System statistics array"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("hostName", "Host name of the LU server", true, false));
        treeSet.add(new TConfigAttribute("remoteLUName", "LU name of the remote system", true, false));
        treeSet.add(new TConfigAttribute("localLUName", "LU name of the local system", true, false));
        treeSet.add(new TConfigAttribute("modeName", "Mode name for session parameters", true, false));
        treeSet.add(new TConfigAttribute("accessMethod", "Access method; 'TCP/IP' or 'SNA'", true, false));
        treeSet.add(new TConfigAttribute("accessMethodParameter", "Additional access method information", true, false));
        treeSet.add(new TConfigAttribute("traceEnabled", "TRUE when tracing is enabled", true, false));
        treeSet.add(new TConfigAttribute("inService", "TRUE when remote system is in service", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTotalRequestsInbound() {
        return ((RemoteData)this.getData()).totalRequestsInbound;
    }

    public int getTotalRequestsOutbound() {
        return ((RemoteData)this.getData()).totalRequestsOutbound;
    }

    public int getAverageBytesInbound() {
        return ((RemoteData)this.getData()).averageBytesInbound;
    }

    public int getAverageBytesOutbound() {
        return ((RemoteData)this.getData()).averageBytesOutbound;
    }

    public RemoteData.ISCStatistics[] getStatistics() {
        return ((RemoteData)this.getData()).statistics;
    }

    public String getHostName() {
        return ((RemoteConfig)this.getConfig()).hostName;
    }

    public String getRemoteLUName() {
        return ((RemoteConfig)this.getConfig()).remoteLUName;
    }

    public String getLocalLUName() {
        return ((RemoteConfig)this.getConfig()).localLUName;
    }

    public String getModeName() {
        return ((RemoteConfig)this.getConfig()).modeName;
    }

    public String getAccessMethod() {
        return ((RemoteConfig)this.getConfig()).accessMethod;
    }

    public String getAccessMethodParameter() {
        return ((RemoteConfig)this.getConfig()).accessMethodParameter;
    }

    public boolean isTraceEnabled() {
        return ((RemoteConfig)this.getConfig()).traceEnabled;
    }

    public boolean isInService() {
        return ((RemoteConfig)this.getConfig()).inService;
    }
}

