/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.mbeans.support.TMBean;
import com.sun.emp.mtp.admin.mbeans.support.TOperation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class RegionLog
extends TMBean {
    private String kixsys;

    public RegionLog(String string) {
        super("RegionLog");
        this.setDescription("Region log information");
        this.kixsys = string;
    }

    public SortedSet getOperationInfo() {
        TreeSet<TOperation> treeSet = new TreeSet<TOperation>(super.getOperationInfo());
        treeSet.add(new TOperation("getLogTail", "Return the last n bytes of the log file"));
        treeSet.add(new TOperation("getDbgTail", "Return the last n bytes of the debug file"));
        treeSet.add(new TOperation("getErrTail", "Return the last n bytes of the error file"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public char[] getLogTail(int n, int n2) {
        char[] cArray = this.getLast(new File(this.kixsys, "unikixmain.log"), n, n2);
        return cArray;
    }

    public char[] getDbgTail(int n, int n2) {
        char[] cArray = this.getLast(new File(this.kixsys, "unikixmain.dbg"), n, n2);
        return cArray;
    }

    public char[] getErrTail(int n, int n2) {
        char[] cArray = this.getLast(new File(this.kixsys, "unikixmain.err"), n, n2);
        return cArray;
    }

    private char[] getLast(File file, int n, int n2) {
        char[] cArray = null;
        try {
            FileReader fileReader = new FileReader(file);
            int n3 = (int)file.length();
            int n4 = 0;
            int n5 = 0;
            if (n == -1 && n2 == -1) {
                n4 = 0;
                n5 = n3;
            } else if (n == -1) {
                if (n2 < n3) {
                    n4 = n3 - n2;
                    n5 = n2;
                } else {
                    n4 = 0;
                    n5 = n3;
                }
            } else if (n < n3) {
                n4 = n;
                int n6 = n3 - n4;
                n5 = n2 == -1 ? n6 : Math.min(n2, n6);
            } else {
                n5 = Math.min(n3, n2);
                n4 = n3 - n5;
            }
            if (n4 > 0) {
                fileReader.skip(n4);
            }
            cArray = new char[38 + n5];
            char[] cArray2 = Integer.toHexString(n4).toCharArray();
            char[] cArray3 = Integer.toHexString(n5).toCharArray();
            int n7 = 0;
            while (n7 < 16) {
                cArray[n7] = 48;
                ++n7;
            }
            cArray[8] = 58;
            cArray[17] = 91;
            cArray[37] = 93;
            char[] cArray4 = this.getToken();
            System.arraycopy(cArray2, 0, cArray, 8 - cArray2.length, cArray2.length);
            System.arraycopy(cArray3, 0, cArray, 9 + (8 - cArray3.length), cArray3.length);
            System.arraycopy(cArray4, 0, cArray, 18, 19);
            fileReader.read(cArray, 38, n5);
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.err.println("IO Error reading " + file.getAbsolutePath());
        }
        return cArray;
    }

    private char[] getToken() {
        char[] cArray = new char[19];
        File file = new File(this.kixsys, "unikixmain.log");
        int n = (int)file.length();
        int n2 = Math.min(n, 19);
        int n3 = 0;
        try {
            FileReader fileReader = new FileReader(file);
            n3 = fileReader.read(cArray, 0, n2);
            fileReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int n4 = n3;
        while (n4 < 19) {
            cArray[n4] = 33;
            ++n4;
        }
        return cArray;
    }
}

