/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.ProgramConfig;
import com.sun.emp.mtp.admin.data.ProgramData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Program
extends BaseMBean {
    public Program(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public Program(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new ProgramData());
        this.setLocalConfig(new ProgramConfig());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("totalExecutions", "Total number of times this program has been executed"));
        treeSet.add(new TMonitorAttribute("totalAborts", "Total number of times this program has aborted"));
        treeSet.add(new TMonitorAttribute("processorTime", "Total processor (CPU) time used by this program"));
        treeSet.add(new TMonitorAttribute("currentUsers", "Current number of transactions using this program"));
        treeSet.add(new TMonitorAttribute("totalDPLInbound", "Total number of times this program invoked by Distributed Program Link (DPL)"));
        treeSet.add(new TMonitorAttribute("averageDPLSizeInbound", "Average size of COMMAREA for inbound DPL invocations"));
        treeSet.add(new TMonitorAttribute("totalDPLOutbound", "Total number of times this program issued Distributed Program Link (DPL)"));
        treeSet.add(new TMonitorAttribute("averageDPLSizeOutbound", "Average size of COMMAREA for outbound DPL invocations"));
        treeSet.add(new TMonitorAttribute("loaded", "TRUE if this program has been used"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("language", "Programming language used to implement the program", true, false));
        treeSet.add(new TConfigAttribute("javaClassName", "Optional, fully-qualified Java class name", true, false));
        treeSet.add(new TConfigAttribute("remoteProgramName", "Optional, program name in remote system", true, false));
        treeSet.add(new TConfigAttribute("remoteTransID", "Optional, remote Trans ID in remote system", true, false));
        treeSet.add(new TConfigAttribute("apiSet", "Level of API supported; 'F[ull]' or 'D[PL]'", true, false));
        treeSet.add(new TConfigAttribute("group", "Group assigned to this program", true, false));
        treeSet.add(new TConfigAttribute("sharedLibraryName", "Optional, shared library name for this program", true, false));
        treeSet.add(new TConfigAttribute("preload", "Program is preloaded indicator", true, false));
        treeSet.add(new TConfigAttribute("disabled", "TRUE if this program is disabled", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTotalExecutions() {
        return ((ProgramData)this.getData()).totalExecutions;
    }

    public int getTotalAborts() {
        return ((ProgramData)this.getData()).totalAborts;
    }

    public int getProcessorTime() {
        return 0;
    }

    public int getCurrentUsers() {
        int n = ((ProgramData)this.getData()).currentTasks;
        if (n > 0) {
            --n;
        }
        return n;
    }

    public int getTotalDPLInbound() {
        return ((ProgramData)this.getData()).totalInboundDPL;
    }

    public int getAverageDPLSizeInbound() {
        return ((ProgramData)this.getData()).averageInboundCommAreaSize;
    }

    public int getTotalDPLOutbound() {
        return ((ProgramData)this.getData()).totalOutboundDPL;
    }

    public int getAverageDPLSizeOutbound() {
        return ((ProgramData)this.getData()).averageOutboundCommAreaSize;
    }

    public boolean isLoaded() {
        return ((ProgramData)this.getData()).currentTasks != 0;
    }

    public String getLanguage() {
        return ((ProgramConfig)this.getConfig()).language;
    }

    public String getJavaClassName() {
        return ((ProgramConfig)this.getConfig()).javaClassName;
    }

    public String getRemoteProgramName() {
        return ((ProgramConfig)this.getConfig()).remoteProgramName;
    }

    public String getRemoteTransID() {
        return ((ProgramConfig)this.getConfig()).remoteTransID;
    }

    public String getApiSet() {
        return ((ProgramConfig)this.getConfig()).apiSet;
    }

    public String getGroup() {
        return ((ProgramConfig)this.getConfig()).group;
    }

    public String getSharedLibraryName() {
        return ((ProgramConfig)this.getConfig()).sharedLibraryName;
    }

    public String getPreload() {
        return ((ProgramConfig)this.getConfig()).preloadEnabled;
    }

    public boolean isDisabled() {
        return ((ProgramConfig)this.getConfig()).disabled;
    }
}

