/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.MapConfig;
import com.sun.emp.mtp.admin.data.MapData;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Map
extends BaseMBean {
    public Map(String string) {
        this(string, "Table BootStrap Instance", null);
    }

    public Map(String string, String string2, DataPoint dataPoint) {
        super(string, string2, dataPoint);
        this.setLocalData(new MapData());
        this.setLocalConfig(new MapConfig());
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("totalExecutions", "Total number of times this map has been used"));
        treeSet.add(new TMonitorAttribute("currentUsers", "Current number of transactions that are using this map"));
        treeSet.add(new TMonitorAttribute("loaded", "TRUE if this map is currently loaded in memory"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("group", "The group assigned to this map entry", true, false));
        treeSet.add(new TConfigAttribute("disabled", "TRUE if this map is disabled", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTotalExecutions() {
        return ((MapData)this.getData()).totalExecutions;
    }

    public int getCurrentUsers() {
        int n = ((MapData)this.getData()).currentTasks;
        if (n > 0) {
            --n;
        }
        return n;
    }

    public boolean isLoaded() {
        return ((MapData)this.getData()).currentTasks != 0;
    }

    public String getGroup() {
        return ((MapConfig)this.getConfig()).group;
    }

    public boolean isDisabled() {
        return ((MapConfig)this.getConfig()).disabled;
    }
}

