/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.datapoints;

import com.sun.emp.mtp.admin.Data;
import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.server.unikixAdmin;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public abstract class DataPointImpl
extends UnicastRemoteObject
implements DataPoint {
    protected Data data;
    protected Data config;
    private static final int DEFAULT_CACHE_LIFESPAN = 1;
    private static long cacheExpiry = 0L;
    private static int cacheLifespan = 1000;
    private static Object gate = new Object();
    private volatile boolean enableLocking = true;

    DataPointImpl() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Data refreshMonitor() {
        ++unikixAdmin.totalMonitorRequests;
        boolean bl = this.isLockingEnabled();
        if (bl) {
            Object object = gate;
            synchronized (object) {
                DataPointImpl.CheckCacheAge();
                Data data = this.getMonitor();
                return data;
            }
        }
        DataPointImpl.CheckCacheAge();
        return this.getMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Data refreshConfig() {
        ++unikixAdmin.totalConfigurationRequests;
        boolean bl = this.isLockingEnabled();
        if (bl) {
            Object object = gate;
            synchronized (object) {
                Data data = this.getConfig();
                return data;
            }
        }
        return this.getConfig();
    }

    public boolean enableLocking() {
        boolean bl = this.enableLocking;
        this.enableLocking = true;
        return bl;
    }

    public boolean disableLocking() {
        boolean bl = this.enableLocking;
        this.enableLocking = false;
        return bl;
    }

    public boolean isLockingEnabled() {
        return this.enableLocking;
    }

    protected Data getMonitor() {
        return this.data;
    }

    protected Data getConfig() {
        return this.config;
    }

    public static int getDefaultCacheLifespan() {
        return 1;
    }

    public static int getCacheLifespan() {
        return cacheLifespan / 1000;
    }

    public static int setCacheLifespan(int n) {
        int n2 = cacheLifespan / 1000;
        cacheLifespan = n * 1000;
        return n2;
    }

    private static final synchronized void CheckCacheAge() {
        long l = System.currentTimeMillis();
        if (l > cacheExpiry) {
            ++unikixAdmin.totalCacheRefreshes;
            cacheExpiry = l + (long)cacheLifespan;
            DataPointImpl.internalSetDataBlocks();
        }
    }

    private static final native void internalSetDataBlocks();
}

