: $Workfile:   kix_dbg.sh  $ $Revision:   1.0  $
#**********************************************************************#
#*                                                                    *#
#* Copyright (c) 2001 by Sun Microsystems, Inc.                       *#
#* All rights reserved.                                               *#
#*                                                                    *#
#**********************************************************************#


# This script can be modified to conform to whatever the user desires
# in the way of 3rd party debuggers. The only arguments that UniKix passes
# to this script are:
#        1) the PID# of the xaction server that the debugger needs to attach to 
#        2) the full pathname of the transaction server executable
#        3) the DISPLAY name of the user's terminal

PID=""
TRAN=""
DISP=""

set -- `getopt p:t:d: $*`

while test "$1" != "--"
do
   if test "$1" = "-p"
   then
      shift
      PID=$1
   elif test "$1" = "-t"
   then
      shift
      TRAN=$1
   elif test "$1" = "-d"
   then
      shift
      DISP=$1
   else
      echo Illegal option $1 encountered, no code found to support this option
      exit 1
   fi
   shift
done

#
# Place 3rd party debugger commands and arguments
#

cd `dirname $TRAN`
TRANEXEC=./`basename $TRAN`
xterm -e dbx -a $PID $TRANEXEC &
echo "Launching debugger and attaching to PID# $PID"

sleep 5

# Create a 'kix_dbg.PID#' killer script to de-instantiate the debugger.
#
# Different debuggers have differing 'footprints' with respect to the
# output from a 'ps -ef'.  It may be necessary for the user to modify
# the 'grep' below to properly recognize various debuggers.
#
#      The contents of a typical script looks like the following:
#                  sleep 2
#                  kill -9 13033
#                  rm -f /home/coredev/kixsys.rrh/kix_dbg.13002

rm -f $KIXSYS/kix_dbg.$PID
touch $KIXSYS/kix_dbg.$PID
chmod 777 $KIXSYS/kix_dbg.$PID
echo "sleep 2" > $KIXSYS/kix_dbg.$PID
ps -ef | \
grep "dbx .* $PID" | \
sed -e 's/^[ ]*//' | \
sed -e 's/ [ ]*/ /' | \
cut -f2 -d' ' | \
sed -e 's/^/kill -9 /' \
   >> $KIXSYS/kix_dbg.$PID
echo "rm -f $KIXSYS/kix_dbg.$PID" >> $KIXSYS/kix_dbg.$PID
exit 0
