/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.server;

import com.sun.emp.mtp.admin.datapoints.DataPointImpl;
import com.sun.emp.mtp.admin.datapoints.RegionDataPointImpl;
import com.sun.emp.mtp.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.rmi.Naming;
import java.rmi.registry.LocateRegistry;

public class unikixAdmin {
    private static String exportedName;
    private static String regionName;
    private static int port;
    public static int totalMonitorRequests;
    public static int totalConfigurationRequests;
    public static int totalCacheRefreshes;

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            regionName = stringArray[0];
        }
        if (stringArray.length > 1) {
            port = Integer.parseInt(stringArray[1]);
        }
        try {
            String string = "_admin" + File.separator;
            String string2 = System.getProperty("KIXSYS");
            String string3 = System.getProperty("cache_lifespan", String.valueOf(DataPointImpl.getDefaultCacheLifespan()));
            DataPointImpl.setCacheLifespan(Integer.parseInt(string3));
            String string4 = string2 + File.separator + string + "admin.port";
            RegionDataPointImpl regionDataPointImpl = new RegionDataPointImpl();
            exportedName = "//:" + port + "/MTP" + string2 + ":unikixAdmin";
            LocateRegistry.createRegistry(port);
            Naming.bind(exportedName, regionDataPointImpl);
            File file = new File(string4);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write("" + port);
                bufferedWriter.close();
            }
            catch (Exception exception) {
                System.out.println("Error processing admin.port:" + exception.toString());
            }
            unikixAdmin.debug("registered as " + exportedName);
        }
        catch (Throwable throwable) {
            unikixAdmin.error("Exception raised is " + throwable.toString());
            throwable.printStackTrace();
            System.exit(0);
        }
    }

    public static void debug(String string) {
        Log.kxprtd((String)string, (int)1);
    }

    public static void error(String string) {
        Log.kxprte((String)string);
    }

    public static void log(String string) {
        Log.kxprtf((String)string);
    }

    public static int getPortNumber() {
        return port;
    }

    public static String getRegionName() {
        return regionName;
    }

    static {
        regionName = "DefaultRegion";
        port = 1099;
        try {
            System.loadLibrary("unikixAdmin");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unikixAdmin.error("Error loading the admin JNI library");
            unikixAdmin.error(unsatisfiedLinkError.toString());
        }
        String string = System.getProperty("MTPADMINTRACE", "0");
        Log.setLevel((int)Integer.parseInt(string));
        Log.setName((String)"unikixadmin");
    }
}

