/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans.support;

import com.sun.emp.mtp.admin.mbeans.support.Mangler;
import com.sun.emp.mtp.admin.mbeans.support.TAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TOperation;
import com.sun.emp.mtp.admin.mbeans.support.TStaticData;
import com.sun.emp.mtp.admin.mbeans.support.TSystemAttribute;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class TMBean
implements DynamicMBean,
MBeanRegistration {
    private String name;
    private String description;
    private TMBean parent;
    private Vector children = new Vector();
    private static HashMap staticDataMap = new HashMap();
    private MBeanServer mbs;
    private static TreeSet sats;
    private static SortedSet cats;
    private static SortedSet ots;
    private static SortedSet mats;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$javax$management$ObjectName;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeData;

    private TMBean() {
    }

    public TMBean(String string) {
        this.name = string;
        this.init();
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final ObjectName getObjectName() {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("SunEMP:fullName=" + this.getFullName());
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            System.out.println("ASSERT " + malformedObjectNameException);
        }
        return objectName;
    }

    public final ObjectName getParentObjectName() {
        ObjectName objectName = null;
        if (this.parent != null) {
            objectName = this.parent.getObjectName();
        }
        return objectName;
    }

    public final synchronized ObjectName[] getChildObjectNames() {
        ObjectName[] objectNameArray = new ObjectName[this.children.size()];
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TMBean tMBean = (TMBean)iterator.next();
            objectNameArray[n++] = tMBean.getObjectName();
        }
        return objectNameArray;
    }

    public Collection getChildren() {
        return this.children;
    }

    public void removeChildren() {
        Object[] objectArray = this.children.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.removeChild((TMBean)objectArray[n]);
            ++n;
        }
    }

    public Class getChildClass() {
        return null;
    }

    public final String getFullName() {
        String string = this.parent == null ? "MTP." + Mangler.mangle(this.name) : this.parent.getFullName() + "." + Mangler.mangle(this.name);
        return string;
    }

    public void beforeGetAllMonitorAttributes() {
    }

    public final CompositeData getAllMonitorAttributes() {
        this.beforeGetAllMonitorAttributes();
        TStaticData tStaticData = this.getStaticData();
        SortedSet sortedSet = tStaticData.getMonitorAttributeInfo();
        CompositeDataSupport compositeDataSupport = null;
        if (this.getChildClass() == null) {
            Map map = this.getAttributeValues(sortedSet, true);
            try {
                compositeDataSupport = new CompositeDataSupport(tStaticData.getMonitorAttributeCompositeType(), map);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
        } else {
            Map map = this.getAttributeValues(sortedSet, true);
            TabularType tabularType = tStaticData.getChildMonitorAttributesTabularType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TMBean tMBean = (TMBean)iterator.next();
                tabularDataSupport.put(tMBean.getAllMonitorAttributes());
            }
            map.put("childMonitorAttributes", tabularDataSupport);
            try {
                compositeDataSupport = new CompositeDataSupport(tStaticData.getMonitorAttributeCompositeType(), map);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
        }
        return compositeDataSupport;
    }

    public void beforeGetAllConfigAttributes() {
    }

    public final CompositeData getAllConfigAttributes() {
        this.beforeGetAllConfigAttributes();
        TStaticData tStaticData = this.getStaticData();
        SortedSet sortedSet = tStaticData.getConfigAttributeInfo();
        CompositeDataSupport compositeDataSupport = null;
        if (this.getChildClass() == null) {
            Map map = this.getAttributeValues(sortedSet, true);
            try {
                compositeDataSupport = new CompositeDataSupport(tStaticData.getConfigAttributeCompositeType(), map);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
        } else {
            Map map = this.getAttributeValues(sortedSet, true);
            TabularType tabularType = tStaticData.getChildConfigAttributesTabularType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TMBean tMBean = (TMBean)iterator.next();
                tabularDataSupport.put(tMBean.getAllConfigAttributes());
            }
            map.put("childConfigAttributes", tabularDataSupport);
            try {
                compositeDataSupport = new CompositeDataSupport(tStaticData.getConfigAttributeCompositeType(), map);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
        }
        return compositeDataSupport;
    }

    public final synchronized void addChild(TMBean tMBean) {
        Class clazz = this.getChildClass();
        if (clazz != null && tMBean.getClass() != clazz) {
            System.out.println("ASSERT: invalid attempt to add child of type " + tMBean.getClass().getName() + " to " + this.getClass().getName());
            System.exit(-1);
        }
        this.children.add(tMBean);
        tMBean.setParent(this);
        if (this.mbs != null && this.mbs.isRegistered(this.getObjectName())) {
            this.registerTMBean(tMBean);
        }
    }

    public final synchronized void removeChild(TMBean tMBean) {
        if (this.children.contains(tMBean)) {
            this.unregisterTMBean(tMBean);
            tMBean.setParent(null);
            this.children.remove(tMBean);
        }
    }

    public final synchronized void remove() {
        if (this.parent == null) {
            this.unregisterTMBean(this);
        } else {
            this.parent.removeChild(this);
        }
    }

    private void registerTMBean(TMBean tMBean) {
        try {
            this.mbs.registerMBean(tMBean, null);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            System.out.println("ASSERT " + instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            System.out.println("ASSERT " + mBeanRegistrationException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            System.out.println("ASSERT " + notCompliantMBeanException);
        }
    }

    private synchronized void unregisterTMBean(TMBean tMBean) {
        block3: {
            if (this.mbs == null || !this.mbs.isRegistered(tMBean.getObjectName())) break block3;
            try {
                this.mbs.unregisterMBean(tMBean.getObjectName());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                System.out.println("ASSERT " + instanceNotFoundException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                System.out.println("ASSERT " + mBeanRegistrationException);
            }
        }
    }

    protected final TMBean getParent() {
        return this.parent;
    }

    protected final void setParent(TMBean tMBean) {
        this.parent = tMBean;
    }

    public final TreeSet getSystemAttributeInfo() {
        if (sats == null) {
            sats = new TreeSet();
            sats.add(new TSystemAttribute("name", "name of this object"));
            sats.add(new TSystemAttribute("description", "description of this object"));
            sats.add(new TSystemAttribute("objectName", "JMX ObjectName of this object"));
            sats.add(new TSystemAttribute("parentObjectName", "JMX ObjectName of parent"));
            sats.add(new TSystemAttribute("childObjectNames", "JMX ObjectName of children"));
            sats.add(new TSystemAttribute("allMonitorAttributes", "All of this objects monitor attributes"));
            sats.add(new TSystemAttribute("allConfigAttributes", "All of this object's config attributes"));
        }
        return sats;
    }

    private void setStaticData(TStaticData tStaticData) {
        staticDataMap.put(this.getClass(), tStaticData);
    }

    private TStaticData getStaticData() {
        return (TStaticData)staticDataMap.get(this.getClass());
    }

    public SortedSet getConfigAttributeInfo() {
        if (cats == null) {
            cats = new TreeSet();
        }
        return Collections.unmodifiableSortedSet(cats);
    }

    public SortedSet getOperationInfo() {
        if (ots == null) {
            ots = new TreeSet();
        }
        return Collections.unmodifiableSortedSet(ots);
    }

    public SortedSet getMonitorAttributeInfo() {
        if (mats == null) {
            mats = new TreeSet();
        }
        return Collections.unmodifiableSortedSet(mats);
    }

    public final Object getAttribute(String string) {
        TStaticData tStaticData = this.getStaticData();
        TAttribute tAttribute = (TAttribute)tStaticData.getHashMap().get(string);
        Method method = tAttribute.getGetterMethod();
        Object[] objectArray = new Object[]{};
        Object object = null;
        try {
            object = method.invoke((Object)this, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("ASSERT: while calling method " + method);
            illegalAccessException.printStackTrace();
            System.exit(-1);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("ASSERT: while calling method " + method);
            invocationTargetException.printStackTrace();
            System.exit(-1);
        }
        if (tAttribute.getReturnClassName().equals("javax.management.openmbean.TabularData")) {
            object = this.convertToTabularData(tAttribute, object);
        }
        return object;
    }

    public final void setAttribute(Attribute attribute) {
        System.out.println("TODO: setAttribute");
    }

    public final AttributeList getAttributes(String[] stringArray) {
        System.out.println("TODO: getAttributes");
        return null;
    }

    public final AttributeList setAttributes(AttributeList attributeList) {
        System.out.println("TODO: setAttributes");
        return null;
    }

    public final MBeanInfo getMBeanInfo() {
        TStaticData tStaticData = this.getStaticData();
        return tStaticData.getMBeanInfo();
    }

    public final Object invoke(String string, Object[] objectArray, String[] stringArray) {
        TStaticData tStaticData = this.getStaticData();
        HashMap hashMap = tStaticData.getOpHashMap();
        TOperation tOperation = (TOperation)hashMap.get(string);
        Method method = tOperation.getMethod();
        Object object = null;
        try {
            object = method.invoke((Object)this, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("ASSERT: while calling method " + method);
            illegalAccessException.printStackTrace();
            System.exit(-1);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("ASSERT: while calling method " + method);
            invocationTargetException.printStackTrace();
            System.out.println("        Cause: " + invocationTargetException.getTargetException());
            System.exit(-1);
        }
        return object;
    }

    public final ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.mbs = mBeanServer;
        return this.getObjectName();
    }

    public final synchronized void postRegister(Boolean bl) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TMBean tMBean = (TMBean)iterator.next();
            this.registerTMBean(tMBean);
        }
    }

    public final synchronized void preDeregister() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TMBean tMBean = (TMBean)iterator.next();
            this.unregisterTMBean(tMBean);
        }
    }

    public final void postDeregister() {
        this.mbs = null;
        this.terminate();
    }

    public void terminate() {
    }

    public final void dump() {
        System.out.println("---------------------------------------------");
        System.out.println("name is       : " + this.getName());
        System.out.println("fullName is   : " + this.getFullName());
        System.out.println("objectName is : " + this.getObjectName());
        int n = 0;
        while (n < this.children.size()) {
            TMBean tMBean = (TMBean)this.children.elementAt(n);
            tMBean.dump();
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        HashMap hashMap = staticDataMap;
        synchronized (hashMap) {
            if (this.getStaticData() == null) {
                this.initAttributeInfo();
                this.initOperationInfo();
                this.initMBeanInfo();
            }
        }
    }

    private void initOperationInfo() {
        SortedSet sortedSet = this.getOperationInfo();
        TStaticData tStaticData = this.getStaticData();
        tStaticData.setOperationInfo(sortedSet);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TOperation tOperation = (TOperation)iterator.next();
            String string = tOperation.getName();
            Method[] methodArray = this.getClass().getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    tOperation.setMethod(methodArray[n]);
                }
                ++n;
            }
        }
    }

    private void initAttributeInfo() {
        TAttribute tAttribute;
        TStaticData tStaticData = new TStaticData();
        this.setStaticData(tStaticData);
        tStaticData.setConfigAttributeInfo(this.getConfigAttributeInfo());
        tStaticData.setMonitorAttributeInfo(this.getMonitorAttributeInfo());
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.getSystemAttributeInfo());
        treeSet.addAll(tStaticData.getConfigAttributeInfo());
        treeSet.addAll(tStaticData.getMonitorAttributeInfo());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            tAttribute = (TAttribute)iterator.next();
            this.determineGetterMethod(tAttribute);
            this.determineSetterMethod(tAttribute);
            this.determineAccessorConsistency(tAttribute);
            this.determineReturnClassName(tAttribute);
            this.determineOpenTypePhase1(tAttribute);
        }
        this.determineChildTabularTypes();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            tAttribute = (TAttribute)iterator.next();
            this.determineOpenTypePhase2(tAttribute);
        }
    }

    private void determineChildTabularTypes() {
        Class clazz = this.getChildClass();
        if (clazz != null) {
            Object object;
            Object object2;
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TMBean.class$("java.lang.String")) : class$java$lang$String};
            TMBean tMBean = null;
            try {
                object2 = clazz.getConstructor(classArray);
                object = new Object[]{"DUMMY"};
                tMBean = (TMBean)((Constructor)object2).newInstance(object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("ASSERT: Class " + clazz + " must have a String constructor");
                noSuchMethodException.printStackTrace();
                System.exit(-1);
            }
            catch (InstantiationException instantiationException) {
                System.out.println("ASSERT: Class " + clazz + " could not be instantiated");
                instantiationException.printStackTrace();
                System.exit(-1);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("ASSERT: Class " + clazz + " could not be instantiated");
                illegalAccessException.printStackTrace();
                System.exit(-1);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("ASSERT: Class " + clazz + " could not be instantiated");
                invocationTargetException.printStackTrace();
                System.exit(-1);
            }
            object2 = tMBean.getAllMonitorAttributes();
            object = object2.getCompositeType();
            CompositeData compositeData = tMBean.getAllConfigAttributes();
            CompositeType compositeType = compositeData.getCompositeType();
            TStaticData tStaticData = this.getStaticData();
            String[] stringArray = new String[]{"name"};
            TabularType tabularType = null;
            try {
                tabularType = new TabularType("childMonitorAttributesTable", "desc", (CompositeType)object, stringArray);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
            tStaticData.setChildMonitorAttributesTabularType(tabularType);
            String[] stringArray2 = new String[]{"name"};
            TabularType tabularType2 = null;
            try {
                tabularType2 = new TabularType("childConfigAttributesTable", "desc", compositeType, stringArray2);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
            tStaticData.setChildConfigAttributesTabularType(tabularType2);
        }
    }

    private void initMBeanInfo() {
        Object object;
        Object object2;
        MBeanAttributeInfo[] mBeanAttributeInfoArray = null;
        MBeanConstructorInfo[] mBeanConstructorInfoArray = null;
        MBeanOperationInfo[] mBeanOperationInfoArray = null;
        MBeanNotificationInfo[] mBeanNotificationInfoArray = null;
        TStaticData tStaticData = this.getStaticData();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.getSystemAttributeInfo());
        treeSet.addAll(tStaticData.getConfigAttributeInfo());
        treeSet.addAll(tStaticData.getMonitorAttributeInfo());
        mBeanAttributeInfoArray = new MBeanAttributeInfo[treeSet.size()];
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object2 = (TAttribute)iterator.next();
            mBeanAttributeInfoArray[n] = new MBeanAttributeInfo(((TAttribute)object2).getName(), ((TAttribute)object2).getReturnClassName(), ((TAttribute)object2).getDescription(), ((TAttribute)object2).exposesGetterMethod(), ((TAttribute)object2).exposesSetterMethod(), false);
            hashMap.put(((TAttribute)object2).getName(), object2);
            ++n;
        }
        object2 = new HashMap();
        SortedSet sortedSet = tStaticData.getOperationInfo();
        mBeanOperationInfoArray = new MBeanOperationInfo[sortedSet.size()];
        Iterator iterator2 = sortedSet.iterator();
        n = 0;
        while (iterator2.hasNext()) {
            object = (TOperation)iterator2.next();
            mBeanOperationInfoArray[n] = new MBeanOperationInfo(((TOperation)object).getName(), ((TOperation)object).getMethod());
            ((HashMap)object2).put(((TOperation)object).getName(), object);
            ++n;
        }
        tStaticData.setOpHashMap((HashMap)object2);
        object = new MBeanInfo(this.getClass().getName(), this.getDescription(), mBeanAttributeInfoArray, mBeanConstructorInfoArray, mBeanOperationInfoArray, mBeanNotificationInfoArray);
        tStaticData.setHashMap(hashMap);
        tStaticData.setMBeanInfo((MBeanInfo)object);
    }

    private void determineGetterMethod(TAttribute tAttribute) {
        Class<?>[] classArray;
        if (!tAttribute.exposesGetterMethod()) {
            return;
        }
        Method[] methodArray = this.getClass().getMethods();
        Method method = null;
        String string = TMBean.constructGetMethodName(tAttribute);
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                Class<?>[] classArray2 = methodArray[n].getParameterTypes();
                if (classArray2.length != 0) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n].getName());
                    System.out.println("    Attribute accessor method must NOT take a parameter");
                    System.exit(-1);
                }
                if ((classArray = methodArray[n].getReturnType()) == Boolean.TYPE) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n].getName());
                    System.out.println("    Attribute accessor method for 'boolean' must use 'is' not 'get'");
                    System.exit(-1);
                }
                method = methodArray[n];
            }
            ++n;
        }
        string = TMBean.constructIsMethodName(tAttribute);
        int n2 = 0;
        while (n2 < methodArray.length) {
            if (methodArray[n2].getName().equals(string)) {
                Class<?> clazz;
                classArray = methodArray[n2].getParameterTypes();
                if (classArray.length != 0) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n2].getName());
                    System.out.println("    Attribute accessor method must NOT take a parameter");
                    System.exit(-1);
                }
                if ((clazz = methodArray[n2].getReturnType()) != Boolean.TYPE) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n2].getName());
                    System.out.println("    Attribute accessor method must return 'boolean'");
                    System.exit(-1);
                }
                if (method != null) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n2].getName());
                    System.out.println("    Attribute accessor 'get' method also declared");
                    System.exit(-1);
                }
                method = methodArray[n2];
            }
            ++n2;
        }
        tAttribute.setGetterMethod(method);
    }

    private void determineSetterMethod(TAttribute tAttribute) {
        if (!tAttribute.exposesSetterMethod()) {
            return;
        }
        Method[] methodArray = this.getClass().getMethods();
        Method method = null;
        String string = TMBean.constructSetMethodName(tAttribute);
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals(string)) {
                Class<?> clazz;
                Class<?>[] classArray = methodArray[n].getParameterTypes();
                if (classArray.length != 1) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n].getName());
                    System.out.println("    Attribute set method must have exactly one parameter");
                    System.exit(-1);
                }
                if ((clazz = methodArray[n].getReturnType()) != Void.TYPE) {
                    System.out.println("ASSERT:");
                    System.out.println("  Class : " + this.getClass().getName());
                    System.out.println("  Method: " + methodArray[n].getName());
                    System.out.println("    Attribute set method must return void");
                    System.exit(-1);
                }
                method = methodArray[n];
            }
            ++n;
        }
        tAttribute.setSetterMethod(method);
    }

    private void determineAccessorConsistency(TAttribute tAttribute) {
        if (tAttribute.getGetterMethod() == null && tAttribute.getSetterMethod() == null) {
            System.out.println("ASSERT:");
            System.out.println("  Class : " + this.getClass().getName());
            System.out.println("   Must provide at least 1 get/is/set method for attribute " + tAttribute.getName());
            System.exit(-1);
        }
        if (tAttribute.exposesGetterMethod() && tAttribute.getGetterMethod() == null) {
            System.out.println("ASSERT:");
            System.out.println("  Class : " + this.getClass().getName());
            System.out.println("  Attribute: " + tAttribute.getName());
            System.out.println("   Attribute declared as needing 'is/get' method but none present");
            System.exit(-1);
        }
        if (tAttribute.exposesSetterMethod() && tAttribute.getSetterMethod() == null) {
            System.out.println("ASSERT:");
            System.out.println("  Class : " + this.getClass().getName());
            System.out.println("  Attribute: " + tAttribute.getName());
            System.out.println("   Attribute declared as needing 'set' method but none present");
            System.exit(-1);
        }
        if (tAttribute.getGetterMethod() != null && tAttribute.getSetterMethod() != null && tAttribute.getSetterMethod().getParameterTypes()[0] != tAttribute.getGetterMethod().getReturnType()) {
            System.out.println("ASSERT:");
            System.out.println("  Class : " + this.getClass().getName());
            System.out.println("  Attribute: " + tAttribute.getName());
            System.out.println("    Inconsistent 'get/is/set' types");
            System.exit(-1);
        }
    }

    private void determineReturnClassName(TAttribute tAttribute) {
        Method method = tAttribute.getGetterMethod();
        Class<?> clazz = method.getReturnType();
        String string = null;
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                string = (class$java$lang$Void == null ? (class$java$lang$Void = TMBean.class$("java.lang.Void")) : class$java$lang$Void).getName();
            } else if (clazz == Boolean.TYPE) {
                string = (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName();
            } else if (clazz == Byte.TYPE) {
                string = (class$java$lang$Byte == null ? (class$java$lang$Byte = TMBean.class$("java.lang.Byte")) : class$java$lang$Byte).getName();
            } else if (clazz == Character.TYPE) {
                string = (class$java$lang$Character == null ? (class$java$lang$Character = TMBean.class$("java.lang.Character")) : class$java$lang$Character).getName();
            } else if (clazz == Short.TYPE) {
                string = (class$java$lang$Short == null ? (class$java$lang$Short = TMBean.class$("java.lang.Short")) : class$java$lang$Short).getName();
            } else if (clazz == Integer.TYPE) {
                string = (class$java$lang$Integer == null ? (class$java$lang$Integer = TMBean.class$("java.lang.Integer")) : class$java$lang$Integer).getName();
            } else if (clazz == Long.TYPE) {
                string = (class$java$lang$Long == null ? (class$java$lang$Long = TMBean.class$("java.lang.Long")) : class$java$lang$Long).getName();
            } else if (clazz == Float.TYPE) {
                string = (class$java$lang$Float == null ? (class$java$lang$Float = TMBean.class$("java.lang.Float")) : class$java$lang$Float).getName();
            } else if (clazz == Double.TYPE) {
                string = (class$java$lang$Double == null ? (class$java$lang$Double = TMBean.class$("java.lang.Double")) : class$java$lang$Double).getName();
            }
        } else if (clazz == (class$java$lang$String == null ? (class$java$lang$String = TMBean.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = TMBean.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            string = clazz.getName();
        } else if (clazz.isArray()) {
            if (clazz.getComponentType() == (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = TMBean.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
                string = clazz.getName();
            } else if (clazz.getComponentType() instanceof Object && !clazz.getComponentType().isPrimitive()) {
                string = (class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TMBean.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName();
            } else {
                System.out.println("ASSERT: Attributes that are arrays of primitives are not yet supported");
                System.out.println(" Attribute name : " + tAttribute.getName());
                System.exit(-1);
            }
        } else if (clazz == (class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = TMBean.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData)) {
            string = (class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = TMBean.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData).getName();
        } else {
            System.out.println("ASSERT: Unsupported attribute type: " + clazz.getName());
            Thread.dumpStack();
            System.exit(1);
        }
        tAttribute.setReturnClassName(string);
    }

    private void determineOpenTypePhase1(TAttribute tAttribute) {
        Class<?> clazz;
        Method method = tAttribute.getGetterMethod();
        Class<?> clazz2 = method.getReturnType();
        Object var4_4 = null;
        OpenType openType = null;
        if (clazz2.isPrimitive()) {
            openType = this.getSimpleType(tAttribute.getReturnClassName());
        } else if (clazz2 == (class$java$lang$String == null ? (class$java$lang$String = TMBean.class$("java.lang.String")) : class$java$lang$String) || clazz2 == (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = TMBean.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            openType = this.getSimpleType(tAttribute.getReturnClassName());
        } else if (clazz2.isArray() && (clazz = clazz2.getComponentType()) != (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = TMBean.class$("javax.management.ObjectName")) : class$javax$management$ObjectName)) {
            CompositeType compositeType = this.determineCompositeType(tAttribute, clazz);
            String[] stringArray = new String[]{"key"};
            try {
                openType = new TabularType(tAttribute.getName(), tAttribute.getDescription(), compositeType, stringArray);
            }
            catch (OpenDataException openDataException) {
                System.out.println("ASSERT");
                openDataException.printStackTrace();
                System.exit(-1);
            }
        }
        tAttribute.setOpenType(openType);
    }

    private void determineOpenTypePhase2(TAttribute tAttribute) {
        Method method = tAttribute.getGetterMethod();
        Class<?> clazz = method.getReturnType();
        Object var4_4 = null;
        CompositeType compositeType = null;
        TStaticData tStaticData = this.getStaticData();
        if (clazz == (class$javax$management$openmbean$CompositeData == null ? (class$javax$management$openmbean$CompositeData = TMBean.class$("javax.management.openmbean.CompositeData")) : class$javax$management$openmbean$CompositeData)) {
            if (tAttribute.getName().equals("allMonitorAttributes")) {
                CompositeType compositeType2 = this.getMonitorCompositeType();
                tStaticData.setMonitorAttributeCompositeType(compositeType2);
                compositeType = compositeType2;
            } else if (tAttribute.getName().equals("allConfigAttributes")) {
                CompositeType compositeType3 = this.getConfigCompositeType();
                tStaticData.setConfigAttributeCompositeType(compositeType3);
                compositeType = compositeType3;
            }
        }
        if (compositeType != null) {
            tAttribute.setOpenType(compositeType);
        }
    }

    private CompositeType determineCompositeType(TAttribute tAttribute, Class clazz) {
        String[] stringArray;
        GenericDeclaration genericDeclaration;
        CompositeType compositeType = null;
        Field[] fieldArray = clazz.getFields();
        Vector<SimpleType<Comparable<Boolean>>> vector = new Vector<SimpleType<Comparable<Boolean>>>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < fieldArray.length) {
            int n2 = fieldArray[n].getModifiers();
            if (Modifier.isPublic(n2)) {
                genericDeclaration = fieldArray[n].getType();
                SimpleType<Object> simpleType = null;
                if (genericDeclaration == Boolean.TYPE) {
                    simpleType = SimpleType.BOOLEAN;
                } else if (genericDeclaration == Character.TYPE) {
                    simpleType = SimpleType.CHARACTER;
                } else if (genericDeclaration == Byte.TYPE) {
                    simpleType = SimpleType.BYTE;
                } else if (genericDeclaration == Short.TYPE) {
                    simpleType = SimpleType.SHORT;
                } else if (genericDeclaration == Integer.TYPE) {
                    simpleType = SimpleType.INTEGER;
                } else if (genericDeclaration == Long.TYPE) {
                    simpleType = SimpleType.LONG;
                } else if (genericDeclaration == Float.TYPE) {
                    simpleType = SimpleType.FLOAT;
                } else if (genericDeclaration == Double.TYPE) {
                    simpleType = SimpleType.DOUBLE;
                } else if (genericDeclaration == (class$java$lang$String == null ? TMBean.class$("java.lang.String") : class$java$lang$String)) {
                    simpleType = SimpleType.STRING;
                } else {
                    System.out.println("ASSERT: could not find simpletype for class " + genericDeclaration);
                    Thread.dumpStack();
                    System.exit(-1);
                }
                vector.addElement(simpleType);
                vector2.addElement(fieldArray[n].getName());
                if (fieldArray[n].getName().equals("key")) {
                    System.out.println("ASSERT: Class may not have a public field called 'key': " + clazz);
                    Thread.dumpStack();
                    System.exit(-1);
                }
            }
            ++n;
        }
        Class[] classArray = new Class[]{};
        try {
            genericDeclaration = clazz.getDeclaredMethod("getKey", classArray);
            int n3 = ((Method)genericDeclaration).getModifiers();
            if (Modifier.isPublic(n3)) {
                stringArray = ((Method)genericDeclaration).getReturnType();
                SimpleType<Object> simpleType = null;
                if (stringArray == Boolean.TYPE) {
                    simpleType = SimpleType.BOOLEAN;
                } else if (stringArray == Character.TYPE) {
                    simpleType = SimpleType.CHARACTER;
                } else if (stringArray == Byte.TYPE) {
                    simpleType = SimpleType.BYTE;
                } else if (stringArray == Short.TYPE) {
                    simpleType = SimpleType.SHORT;
                } else if (stringArray == Integer.TYPE) {
                    simpleType = SimpleType.INTEGER;
                } else if (stringArray == Long.TYPE) {
                    simpleType = SimpleType.LONG;
                } else if (stringArray == Float.TYPE) {
                    simpleType = SimpleType.FLOAT;
                } else if (stringArray == Double.TYPE) {
                    simpleType = SimpleType.DOUBLE;
                } else if (stringArray == (class$java$lang$String == null ? (class$java$lang$String = TMBean.class$("java.lang.String")) : class$java$lang$String)) {
                    simpleType = SimpleType.STRING;
                } else {
                    System.out.println("ASSERT: could not find simpletype for class " + stringArray + " returned by 'getKey()' method of " + clazz);
                    Thread.dumpStack();
                    System.exit(-1);
                }
                vector.addElement(simpleType);
                vector2.addElement("key");
            } else {
                System.out.println("ASSERT: 'getKey()' method is not public: " + clazz);
                Thread.dumpStack();
                System.exit(-1);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            vector.addElement(SimpleType.INTEGER);
            vector2.addElement("key");
        }
        genericDeclaration = new OpenType[vector.size()];
        String[] stringArray2 = new String[vector.size()];
        stringArray = new String[vector.size()];
        int n4 = 0;
        while (n4 < vector.size()) {
            genericDeclaration[n4] = (OpenType)vector.elementAt(n4);
            stringArray2[n4] = (String)vector2.elementAt(n4);
            stringArray[n4] = "desc";
            ++n4;
        }
        try {
            compositeType = new CompositeType(tAttribute.getName() + "CT", "desc", stringArray2, stringArray, (OpenType<?>[])genericDeclaration);
        }
        catch (OpenDataException openDataException) {
            System.out.println("ASSERT");
            openDataException.printStackTrace();
            System.exit(-1);
        }
        return compositeType;
    }

    private static String constructIsMethodName(TAttribute tAttribute) {
        return "is" + TMBean.ucFirst(tAttribute.getName());
    }

    private static String constructGetMethodName(TAttribute tAttribute) {
        return "get" + TMBean.ucFirst(tAttribute.getName());
    }

    private static String constructSetMethodName(TAttribute tAttribute) {
        return "set" + TMBean.ucFirst(tAttribute.getName());
    }

    private static String ucFirst(String string) {
        return string.toUpperCase().substring(0, 1) + string.substring(1);
    }

    private CompositeType getMonitorCompositeType() {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        OpenType[] openTypeArray;
        TStaticData tStaticData = this.getStaticData();
        SortedSet sortedSet = tStaticData.getMonitorAttributeInfo();
        Class clazz = this.getChildClass();
        if (clazz == null) {
            openTypeArray = new OpenType[sortedSet.size() + 1];
            stringArray2 = new String[sortedSet.size() + 1];
            stringArray = new String[sortedSet.size() + 1];
        } else {
            openTypeArray = new OpenType[sortedSet.size() + 2];
            stringArray2 = new String[sortedSet.size() + 2];
            stringArray = new String[sortedSet.size() + 2];
        }
        int n = 0;
        openTypeArray[n] = SimpleType.STRING;
        stringArray2[n] = "name";
        stringArray[n] = "desc";
        ++n;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            object = (TAttribute)iterator.next();
            openTypeArray[n] = ((TAttribute)object).getOpenType();
            stringArray2[n] = ((TAttribute)object).getName();
            stringArray[n] = "desc";
            ++n;
        }
        if (clazz != null) {
            openTypeArray[n] = tStaticData.getChildMonitorAttributesTabularType();
            stringArray2[n] = "childMonitorAttributes";
            stringArray[n] = "desc";
        }
        object = null;
        try {
            object = new CompositeType(this.getName() + ".monitor.attributes", "monitor attribute set for " + this.getName(), stringArray2, stringArray, openTypeArray);
        }
        catch (OpenDataException openDataException) {
            System.out.println("ASSERT");
            openDataException.printStackTrace();
            System.exit(-1);
        }
        return object;
    }

    private CompositeType getConfigCompositeType() {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        OpenType[] openTypeArray;
        TStaticData tStaticData = this.getStaticData();
        SortedSet sortedSet = tStaticData.getConfigAttributeInfo();
        Class clazz = this.getChildClass();
        if (clazz == null) {
            openTypeArray = new OpenType[sortedSet.size() + 1];
            stringArray2 = new String[sortedSet.size() + 1];
            stringArray = new String[sortedSet.size() + 1];
        } else {
            openTypeArray = new OpenType[sortedSet.size() + 2];
            stringArray2 = new String[sortedSet.size() + 2];
            stringArray = new String[sortedSet.size() + 2];
        }
        Iterator iterator = sortedSet.iterator();
        int n = 0;
        openTypeArray[n] = SimpleType.STRING;
        stringArray2[n] = "name";
        stringArray[n] = "desc";
        ++n;
        while (iterator.hasNext()) {
            object = (TAttribute)iterator.next();
            openTypeArray[n] = ((TAttribute)object).getOpenType();
            stringArray2[n] = ((TAttribute)object).getName();
            stringArray[n] = "desc";
            ++n;
        }
        if (clazz != null) {
            openTypeArray[n] = tStaticData.getChildConfigAttributesTabularType();
            stringArray2[n] = "childConfigAttributes";
            stringArray[n] = "desc";
            ++n;
        }
        object = null;
        try {
            object = new CompositeType(this.getName() + ".config.attributes", "config attribute set for " + this.getName(), stringArray2, stringArray, openTypeArray);
        }
        catch (OpenDataException openDataException) {
            System.out.println("ASSERT");
            openDataException.printStackTrace();
            System.exit(-1);
        }
        return object;
    }

    private Map getAttributeValues(Collection collection, boolean bl) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("name", this.getAttribute("name"));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TAttribute tAttribute = (TAttribute)iterator.next();
            String string = tAttribute.getName();
            Object object = this.getAttribute(string);
            treeMap.put(string, object);
        }
        return treeMap;
    }

    private TabularData convertToTabularData(TAttribute tAttribute, Object object) {
        if (object == null) {
            return null;
        }
        TabularType tabularType = (TabularType)tAttribute.getOpenType();
        CompositeType compositeType = tabularType.getRowType();
        TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
        Object[] objectArray = (Object[])object;
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (object2 == null) {
                System.out.println("RFN: WARNING: ASSERT: array row is null!");
                System.out.println("                      row is " + n);
                System.out.println("                      array obj is " + object);
            } else {
                Object object3;
                Class<?> clazz = object2.getClass();
                Set<String> set = compositeType.keySet();
                Iterator<String> iterator = set.iterator();
                Object[] objectArray2 = new Object[set.size()];
                String[] stringArray = new String[set.size()];
                int n2 = 0;
                while (iterator.hasNext()) {
                    object3 = iterator.next();
                    stringArray[n2] = object3;
                    try {
                        Object object4;
                        objectArray2[n2] = object4 = clazz.getField((String)object3).get(object2);
                        ++n2;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        if (((String)object3).equals("key")) {
                            Object[] objectArray3;
                            Class[] classArray = new Class[]{};
                            try {
                                Object object5;
                                Method method = clazz.getDeclaredMethod("getKey", classArray);
                                objectArray3 = new Object[]{};
                                objectArray2[n2] = object5 = method.invoke(object2, objectArray3);
                                ++n2;
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                objectArray2[n2] = objectArray3 = new Integer(n);
                                ++n2;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                System.out.println("ASSERT: ");
                                invocationTargetException.printStackTrace();
                                System.exit(-1);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                System.out.println("ASSERT: ");
                                illegalAccessException.printStackTrace();
                                System.exit(-1);
                            }
                            continue;
                        }
                        System.out.println("ASSERT");
                        noSuchFieldException.printStackTrace();
                        System.exit(-1);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.out.println("ASSERT");
                        illegalAccessException.printStackTrace();
                        System.exit(-1);
                    }
                }
                object3 = null;
                try {
                    object3 = new CompositeDataSupport(compositeType, stringArray, objectArray2);
                }
                catch (OpenDataException openDataException) {
                    System.out.println("ASSERT");
                    openDataException.printStackTrace();
                    System.exit(-1);
                }
                tabularDataSupport.put((CompositeData)object3);
            }
            ++n;
        }
        return tabularDataSupport;
    }

    private SimpleType getSimpleType(String string) {
        SimpleType<Object> simpleType = null;
        if (string.equals("java.lang.Void")) {
            simpleType = SimpleType.VOID;
        } else if (string.equals("java.lang.Boolean")) {
            simpleType = SimpleType.BOOLEAN;
        } else if (string.equals("java.lang.Character")) {
            simpleType = SimpleType.CHARACTER;
        } else if (string.equals("java.lang.Byte")) {
            simpleType = SimpleType.BYTE;
        } else if (string.equals("java.lang.Short")) {
            simpleType = SimpleType.SHORT;
        } else if (string.equals("java.lang.Integer")) {
            simpleType = SimpleType.INTEGER;
        } else if (string.equals("java.lang.Long")) {
            simpleType = SimpleType.LONG;
        } else if (string.equals("java.lang.Float")) {
            simpleType = SimpleType.FLOAT;
        } else if (string.equals("java.lang.Double")) {
            simpleType = SimpleType.DOUBLE;
        } else if (string.equals("java.lang.String")) {
            simpleType = SimpleType.STRING;
        } else if (string.equals("java.math.BigDecimal")) {
            simpleType = SimpleType.BIGDECIMAL;
        } else if (string.equals("java.math.BigInteger")) {
            simpleType = SimpleType.BIGINTEGER;
        } else if (string.equals("javax.management.ObjectName")) {
            simpleType = SimpleType.OBJECTNAME;
        } else {
            System.out.println("ASSERT: Invalid class for SimpleType: " + string);
            Thread.dumpStack();
            System.exit(-1);
        }
        return simpleType;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

