/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mtp.admin.mbeans;

import com.sun.emp.mtp.admin.DataPoint;
import com.sun.emp.mtp.admin.data.RegionConfig;
import com.sun.emp.mtp.admin.data.RegionData;
import com.sun.emp.mtp.admin.data.TablesData;
import com.sun.emp.mtp.admin.mbeans.AdvancedStuff;
import com.sun.emp.mtp.admin.mbeans.BaseMBean;
import com.sun.emp.mtp.admin.mbeans.CICSCommand;
import com.sun.emp.mtp.admin.mbeans.CommunicationServers;
import com.sun.emp.mtp.admin.mbeans.FileTable;
import com.sun.emp.mtp.admin.mbeans.GroupTable;
import com.sun.emp.mtp.admin.mbeans.JournalTable;
import com.sun.emp.mtp.admin.mbeans.Languages;
import com.sun.emp.mtp.admin.mbeans.MapTable;
import com.sun.emp.mtp.admin.mbeans.ProgramTable;
import com.sun.emp.mtp.admin.mbeans.Recovery;
import com.sun.emp.mtp.admin.mbeans.RegionLog;
import com.sun.emp.mtp.admin.mbeans.RegionPerformance;
import com.sun.emp.mtp.admin.mbeans.RemoteTable;
import com.sun.emp.mtp.admin.mbeans.TemporaryStorageQueue;
import com.sun.emp.mtp.admin.mbeans.TemporaryStorageTable;
import com.sun.emp.mtp.admin.mbeans.TerminalTable;
import com.sun.emp.mtp.admin.mbeans.TransactionClassTable;
import com.sun.emp.mtp.admin.mbeans.TransactionTable;
import com.sun.emp.mtp.admin.mbeans.TransientDataQueues;
import com.sun.emp.mtp.admin.mbeans.UserTable;
import com.sun.emp.mtp.admin.mbeans.support.TConfigAttribute;
import com.sun.emp.mtp.admin.mbeans.support.TMonitorAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.rmi.Naming;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

public class Region
extends BaseMBean {
    private String hostname = "localhost";
    private int port = 1099;
    private boolean connected = false;
    private String regionName;
    private String mySource;
    private String kixsys;
    private RegionLog regionLogMBean;
    private volatile boolean thingsToDo = true;

    public Region(String string, String string2, String string3) {
        super(string);
        this.regionName = string;
        this.kixsys = string2;
        this.mySource = string3;
        this.setDescription("Region MBean");
        this.setLocalData(new RegionData());
        this.setLocalConfig(new RegionConfig());
        this.regionLogMBean = new RegionLog(string2);
        this.addChild(this.regionLogMBean);
        new WatchDogThread(this).start();
    }

    private void createChildren(RegionData regionData) {
        try {
            TablesData tablesData = (TablesData)regionData.TablesDP.refreshMonitor();
            this.addChild(new ProgramTable("ProgramTable", "Programs", tablesData.ProgramTableDP));
            this.addChild(new TransactionTable("TransactionTable", "Transactions", tablesData.TransactionTableDP));
            this.addChild(new TerminalTable("TerminalTable", "Terminals", tablesData.TerminalTableDP));
            this.addChild(new FileTable("FileTable", "Files", tablesData.FileTableDP));
            this.addChild(new MapTable("MapTable", "Maps", tablesData.MapTableDP));
            this.addChild(new RemoteTable("RemoteTable", "Remotes", tablesData.RemoteTableDP));
            this.addChild(new TemporaryStorageTable("TemporaryStorageTable", "Temporary Storage Table", tablesData.TemporaryStorageTableDP));
            this.addChild(new TemporaryStorageQueue("TemporaryStorageQueue", "Temporary Storage Queue", tablesData.TemporaryStorageQueueDP));
            this.addChild(new TransientDataQueues("TransientDataQueueTable", "Transient Data Queues", tablesData.TransientDataQueueDP));
            this.addChild(new UserTable("UserTable", "Users", tablesData.UserTableDP));
            this.addChild(new GroupTable("GroupTable", "Groups", tablesData.GroupTableDP));
            this.addChild(new JournalTable("JournalTable", "Journals", tablesData.JournalTableDP));
            this.addChild(new Languages("ConfiguredLanguages", "Languages", tablesData.LanguagesDP));
            this.addChild(new TransactionClassTable("TransactionClasses", "TxClasses", tablesData.TransactionClassesDP));
            this.addChild(new RegionPerformance("RegionPerformance", "Region Performance Metrics", regionData.PerformanceDP));
            this.addChild(new AdvancedStuff("AdvancedData", "Advanced Information", regionData.AdvancedDP));
            this.addChild(new Recovery("Recovery", "Recovery Information", regionData.RecoveryDP));
            this.addChild(new CommunicationServers("CommunicationServers", "Communication Servers", regionData.CommServerDP));
            this.addChild(new CICSCommand("CICSAPICounts", "CICS API Usage", tablesData.CICSCommandDP));
        }
        catch (Exception exception) {}
    }

    public SortedSet getMonitorAttributeInfo() {
        TreeSet<TMonitorAttribute> treeSet = new TreeSet<TMonitorAttribute>(super.getMonitorAttributeInfo());
        treeSet.add(new TMonitorAttribute("state", "Region Status"));
        treeSet.add(new TMonitorAttribute("running", "TRUE if Region is accessible"));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public SortedSet getConfigAttributeInfo() {
        TreeSet<TConfigAttribute> treeSet = new TreeSet<TConfigAttribute>(super.getConfigAttributeInfo());
        treeSet.add(new TConfigAttribute("regionName", "Region name as defined in the SIT", true, false));
        treeSet.add(new TConfigAttribute("regionHome", "Region home location", true, false));
        treeSet.add(new TConfigAttribute("version", "MTP version number", true, false));
        treeSet.add(new TConfigAttribute("startTime", "Date and Time Region was started", true, false));
        treeSet.add(new TConfigAttribute("startTimeRaw", "Region start time in seconds since Jan01 1970", true, false));
        treeSet.add(new TConfigAttribute("maxTxServersConfigured", "Number of transaction servers configured", true, false));
        treeSet.add(new TConfigAttribute("maxTxServersLicensed", "Number of transaction servers licensed", true, false));
        treeSet.add(new TConfigAttribute("maxUsersConfigured", "Number of concurrent users configured", true, false));
        treeSet.add(new TConfigAttribute("maxUsersLicensed", "Number of concurrent users licensed", true, false));
        treeSet.add(new TConfigAttribute("maxDebugTerminals", "Number of debug terminals configured", true, false));
        treeSet.add(new TConfigAttribute("maxBackgroundTasks", "Number of background tasks configured", true, false));
        treeSet.add(new TConfigAttribute("maxBatchJobs", "Number of batch jobs configured", true, false));
        treeSet.add(new TConfigAttribute("maxQueryJobs", "Number of query jobs configured", true, false));
        treeSet.add(new TConfigAttribute("batchNodeName", "Node name of configured Batch system", true, false));
        treeSet.add(new TConfigAttribute("batchSearchInterval", "Batch Search Interval", true, false));
        treeSet.add(new TConfigAttribute("terminalTimeout", "Configured terminal timeout in seconds", true, false));
        treeSet.add(new TConfigAttribute("systemAccounting", "TRUE if system accounting is enabled", true, false));
        treeSet.add(new TConfigAttribute("userAccounting", "TRUE if default user accounting is enabled", true, false));
        treeSet.add(new TConfigAttribute("transactionAccounting", "TRUE if default transaction accounting is enabled", true, false));
        treeSet.add(new TConfigAttribute("totalTxClasses", "Total Number of Transaction Classes", true, false));
        treeSet.add(new TConfigAttribute("totalTransactions", "Total Number of Transactions", true, false));
        treeSet.add(new TConfigAttribute("totalPrograms", "Total Number of Programs", true, false));
        treeSet.add(new TConfigAttribute("totalFiles", "Total Number of Files", true, false));
        treeSet.add(new TConfigAttribute("totalMaps", "Total Number of Maps", true, false));
        treeSet.add(new TConfigAttribute("totalRemotes", "Total Number of Remote Systems", true, false));
        treeSet.add(new TConfigAttribute("totalTerminals", "Total Number of Terminals", true, false));
        treeSet.add(new TConfigAttribute("totalUsers", "Total Number of Users in Sign-On Table", true, false));
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public int getTxServers() {
        return ((RegionConfig)this.getConfig()).maxTxServersConfigured;
    }

    public String getState() {
        if (this.connected) {
            return "UP";
        }
        return "DOWN";
    }

    public boolean isRunning() {
        return this.connected;
    }

    public String getRegionName() {
        return ((RegionConfig)this.getConfig()).regionName;
    }

    public String getRegionHome() {
        return ((RegionConfig)this.getConfig()).regionHome;
    }

    public String getVersion() {
        return ((RegionConfig)this.getConfig()).version;
    }

    public String getStartTime() {
        return ((RegionConfig)this.getConfig()).startDateTime;
    }

    public long getStartTimeRaw() {
        return ((RegionConfig)this.getConfig()).regionStartTimeRaw;
    }

    public short getMaxTxServersConfigured() {
        return ((RegionConfig)this.getConfig()).maxTxServersConfigured;
    }

    public short getMaxTxServersLicensed() {
        return ((RegionConfig)this.getConfig()).maxTxServersLicensed;
    }

    public int getMaxUsersConfigured() {
        return ((RegionConfig)this.getConfig()).maxUsersConfigured;
    }

    public int getMaxUsersLicensed() {
        return ((RegionConfig)this.getConfig()).maxUsersLicensed;
    }

    public short getMaxDebugTerminals() {
        return ((RegionConfig)this.getConfig()).maxDebugTerminals;
    }

    public short getMaxBackgroundTasks() {
        return ((RegionConfig)this.getConfig()).maxBackgroundTasks;
    }

    public short getMaxBatchJobs() {
        return ((RegionConfig)this.getConfig()).maxBatchJobs;
    }

    public short getMaxQueryJobs() {
        return ((RegionConfig)this.getConfig()).maxQueryJobs;
    }

    public String getBatchNodeName() {
        return ((RegionConfig)this.getConfig()).batchNodeName;
    }

    public int getBatchSearchInterval() {
        return ((RegionConfig)this.getConfig()).batchSearchInterval;
    }

    public int getTerminalTimeout() {
        return ((RegionConfig)this.getConfig()).terminalTimeout;
    }

    public boolean isSystemAccounting() {
        return ((RegionConfig)this.getConfig()).accounting;
    }

    public boolean isUserAccounting() {
        return ((RegionConfig)this.getConfig()).userAccounting;
    }

    public boolean isTransactionAccounting() {
        return ((RegionConfig)this.getConfig()).txAccounting;
    }

    public int getTotalTxClasses() {
        return ((RegionConfig)this.getConfig()).totalTxClasses;
    }

    public int getTotalTransactions() {
        return ((RegionConfig)this.getConfig()).totalTransactions;
    }

    public int getTotalPrograms() {
        return ((RegionConfig)this.getConfig()).totalPrograms;
    }

    public int getTotalFiles() {
        return ((RegionConfig)this.getConfig()).totalFiles;
    }

    public int getTotalMaps() {
        return ((RegionConfig)this.getConfig()).totalMaps;
    }

    public int getTotalRemotes() {
        return ((RegionConfig)this.getConfig()).totalRemotes;
    }

    public int getTotalTerminals() {
        return ((RegionConfig)this.getConfig()).totalTerminals;
    }

    public int getTotalUsers() {
        return ((RegionConfig)this.getConfig()).totalUsers;
    }

    public String getHostName() {
        return this.hostname;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    public int getPortNumber() {
        return this.port;
    }

    public void setPortNumber(int n) {
        this.port = n;
    }

    private void stopWatchDogThread() {
        this.thingsToDo = false;
    }

    public void terminate() {
        this.stopWatchDogThread();
    }

    static /* synthetic */ String access$000(Region region) {
        return region.hostname;
    }

    static /* synthetic */ int access$100(Region region) {
        return region.port;
    }

    static /* synthetic */ String access$200(Region region) {
        return region.kixsys;
    }

    static /* synthetic */ boolean access$302(Region region, boolean bl) {
        region.connected = bl;
        return region.connected;
    }

    static /* synthetic */ boolean access$400(Region region) {
        return region.thingsToDo;
    }

    static /* synthetic */ boolean access$300(Region region) {
        return region.connected;
    }

    static /* synthetic */ String access$500(Region region) {
        return region.mySource;
    }

    static /* synthetic */ boolean access$402(Region region, boolean bl) {
        region.thingsToDo = bl;
        return region.thingsToDo;
    }

    static /* synthetic */ int access$102(Region region, int n) {
        region.port = n;
        return region.port;
    }

    static /* synthetic */ String access$600(Region region) {
        return region.regionName;
    }

    static /* synthetic */ void access$700(Region region, RegionData regionData) {
        region.createChildren(regionData);
    }

    static /* synthetic */ RegionLog access$800(Region region) {
        return region.regionLogMBean;
    }

    class WatchDogThread
    extends Thread {
        private int delay = 2000;
        private Region myRegion;

        public WatchDogThread(Region region2) {
            this.myRegion = region2;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = null;
            var3_2 = "_admin" + File.separator;
            var6_3 = false;
            var7_4 = false;
            var8_5 = "//" + Region.access$000(Region.this) + ":" + Region.access$100(Region.this) + "/MTP" + Region.access$200(Region.this) + ":unikixAdmin";
            var4_6 = Region.access$200(Region.this) + File.separator + var3_2 + "mtp.location";
            var5_7 = Region.access$200(Region.this) + File.separator + var3_2 + "admin.port";
            Region.access$302(Region.this, false);
            ** GOTO lbl72
            {
                var2_8 = new File(var4_6);
                try {
                    var9_9 = new BufferedReader(new FileReader(var2_8));
                    var10_14 = var9_9.readLine();
                    var9_9.close();
                    var7_4 = false;
                    if (!var10_14.equals(Region.access$500(Region.this))) {
                        Region.access$402(Region.this, false);
                    }
                }
                catch (FileNotFoundException var9_10) {
                }
                catch (Exception var10_15) {
                    if (!var7_4) {
                        var7_4 = true;
                    }
                    ** GOTO lbl59
                }
                var2_8 = new File(var5_7);
                try {
                    var9_9 = new BufferedReader(new FileReader(var2_8));
                    var10_14 = var9_9.readLine();
                    var9_9.close();
                    var11_17 = new Integer(var10_14);
                    if (var11_17 != Region.access$100(Region.this)) {
                        Region.access$102(Region.this, var11_17);
                        var8_5 = "//" + Region.access$000(Region.this) + ":" + Region.access$100(Region.this) + "/MTP" + Region.access$200(Region.this) + ":unikixAdmin";
                        System.out.println("WatchDog: Monitoring " + var8_5);
                    }
                    var6_3 = false;
                }
                catch (FileNotFoundException var9_11) {
                    ** GOTO lbl59
                }
                catch (Exception var10_16) {
                    if (!var6_3) {
                        var6_3 = true;
                    }
                    ** GOTO lbl59
                }
                try {
                    var1_1 = Naming.lookup(var8_5);
                }
                catch (Exception var9_12) {
                    ** GOTO lbl59
                }
                System.out.println("WatchDog: " + var8_5 + " is active: Creating " + Region.access$600(Region.this) + " MBeans");
                Region.this.setDataPoint((DataPoint)var1_1);
                Region.access$700(Region.this, (RegionData)Region.this.getData());
                Region.access$302(Region.this, true);
                do {
                    if (!Region.access$300(Region.this)) continue block10;
lbl59:
                    // 8 sources

                    while (Region.access$300(Region.this)) {
                        try {
                            var1_1 = Naming.lookup(var8_5);
                            break;
                        }
                        catch (Exception var9_13) {
                            System.out.println("WatchDog: " + var8_5 + " is inactive: Removing " + Region.access$600(Region.this) + " MBeans");
                            Region.this.setDataPoint(null);
                            Region.this.removeChildren();
                            Region.this.addChild(Region.access$800(Region.this));
                            Region.access$302(Region.this, false);
                        }
                    }
                    this.internalSleep(this.delay);
lbl72:
                    // 2 sources

                } while (Region.access$400(Region.this));
            }
            this.myRegion.remove();
        }

        private void internalSleep(int n) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

