<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0" 
  >
<!-- The possible parametrizations :
   provType - Which determines whether to create a remote provider or hosted provider
   defaultUrlPrefix - the prefix used for autopopulation that would be needed for hosted provider
-->

<xsl:param name="provType"/>
<xsl:param name="defaultUrlPrefix"/>

<!-- When the IDPDescriptor is specified, generate xml snippet
   that corresponds to either remote or hosted provider, depending on
   the parameter provType.

   The provider name is an attribute that is specific to the current 
   implementation and as this attribute is not part of the liberty 
   metadata, it is being assigned the value of the provider id itself.
-->
	
<xsl:template match="IDPDescriptor">
  <xsl:variable name="idValue" select="ProviderID"/>
  <xsl:if test="$provType='remote'">
   <xsl:element name="CreateRemoteProvider">
    <!-- The attributes of the element are:
 	 	1)id
         	2)role
		
    -->
    <xsl:attribute name="id">
     <xsl:value-of select="$idValue"/>
    </xsl:attribute>
    <xsl:attribute name="role">IDP</xsl:attribute>
    <xsl:apply-templates select="ProviderSuccinctID|KeyInfo|SoapEndpoint|SingleLogoutServiceURL|SingleLogoutServiceReturnURL|FederationTerminationServiceURL|FederationTerminationServiceReturnURL|SingleSignOnServiceURL"/>
<xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-name</xsl:with-param>
   <xsl:with-param name="attrVal" select="$idValue"/>
 </xsl:call-template>
<xsl:text> 
</xsl:text>
  </xsl:element>
  </xsl:if>
  <xsl:if test="$provType='hosted'">
   <xsl:element name="CreateHostedProvider">
    <xsl:attribute name="id">
     <xsl:value-of select="$idValue"/>
    </xsl:attribute>
    <xsl:attribute name="role">IDP</xsl:attribute>
    <xsl:attribute name="defaultUrlPrefix">
     <xsl:value-of select="$defaultUrlPrefix"/>
    </xsl:attribute>
    <xsl:apply-templates select="ProviderSuccinctID|KeyInfo|SoapEndpoint|SingleLogoutServiceURL|SingleLogoutServiceReturnURL|FederationTerminationServiceURL|FederationTerminationServiceReturnURL|SingleSignOnServiceURL"/>
<xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-name</xsl:with-param>
   <xsl:with-param name="attrVal" select="$idValue"/>
 </xsl:call-template>
 <xsl:call-template name="attrValPair">
 </xsl:call-template>
<xsl:text> 
</xsl:text>
  </xsl:element>
  </xsl:if>
<xsl:text> 
</xsl:text>
</xsl:template>

<!-- When the SPDescriptor is specified, generate xml snippet
   that corresponds to either remote or hosted provider, depending on
   the parameter provType.
-->

<xsl:template match="SPDescriptor">
  <xsl:variable name="idValue" select="ProviderID"/>
  <xsl:if test="$provType='remote'">
   <xsl:element name="CreateRemoteProvider">
    <xsl:attribute name="id">
     <xsl:value-of select="$idValue"/>
    </xsl:attribute>
    <xsl:attribute name="role">SP</xsl:attribute>
    <xsl:apply-templates select="ProviderSuccinctID|KeyInfo|SoapEndpoint|SingleLogoutServiceURL|SingleLogoutServiceReturnURL|FederationTerminationServiceURL|FederationTerminationServiceReturnURL|AssertionConsumerServiceURL|FederationTerminationNotificationProtocolProfile|SingleLogoutProtocolProfile|AuthnRequestsSigned"/>
<xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-name</xsl:with-param>
   <xsl:with-param name="attrVal" select="$idValue"/>
 </xsl:call-template>
<xsl:text> 
</xsl:text>
  </xsl:element>
  </xsl:if>
  <xsl:if test="$provType='hosted'">
   <!-- If it is a hosted provider, there is yet another attribute that is
    involved that is the defaultUrlPrefix used for autopopulation.
   -->
   <!-- In addition to the specified parameters in the liberty metadata, following 
     attributes are mandatory for creation of hosted provider:
	urlPrefix : used for autopopulation. This parameter is specified
                    while importing a hosted provider.
		    In case, the user needs to change it, he needs to do this explicitly
        metaAlias: This value for the metaalias is derived from the sopeend point specified
		In the soapendpointurl, the value that follows the metaAlias/ is metaAlias.
   -->
   <xsl:element name="CreateHostedProvider">
    <xsl:attribute name="id">
     <xsl:value-of select="$idValue"/>
    </xsl:attribute>
    <xsl:attribute name="role">SP</xsl:attribute>
   <xsl:attribute name="defaultUrlPrefix">
     <xsl:value-of select="$defaultUrlPrefix"/>
   </xsl:attribute>
    <xsl:apply-templates select="ProviderSuccinctID|KeyInfo|SoapEndpoint|SingleLogoutServiceURL|SingleLogoutServiceReturnURL|FederationTerminationServiceURL|FederationTerminationServiceReturnURL|AssertionConsumerServiceURL|FederationTerminationNotificationProtocolProfile|SingleLogoutProtocolProfile|AuthnRequestsSigned"/>
   <!-- Provider Name is something that is specific to IS implementation.
     Hence it is being set the value of the provider Id.
   -->  
<xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-name</xsl:with-param>
   <xsl:with-param name="attrVal" select="$idValue"/>
 </xsl:call-template>
 <xsl:call-template name="attrValPair">
 </xsl:call-template>
  </xsl:element>
  </xsl:if>
<xsl:text> 
</xsl:text>
</xsl:template>

<!-- Subelements possible are:
        ProviderSuccinctID, KeyInfo, SoapEndPoint,
	SingleLogoutServiceURL, SingleLogoutServiceReturnURL,
	FederationTerminationServiceURL, FederationTerminationServiceReturnURL
	AssertionConsumerServiceURL, FederationTerminationNotificationProtocolProfile,
	SingleLogoutProtocolProfile, AuthnRequestsSigned
-->
	
<xsl:template match="ProviderSuccinctID">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-succinctid</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="KeyInfo">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-certificate-alias</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="SoapEndpoint">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-soap-end-point</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-provider-alias</xsl:with-param>
   <xsl:with-param name="attrVal" select="substring-after(.,'metaAlias/')"/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="SingleLogoutServiceURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-slo-service-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="SingleLogoutServiceReturnURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-slo-service-return-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="FederationTerminationServiceURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-federation-termination-service-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="FederationTerminationServiceReturnURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-federation-termination-service-return-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="SingleSignOnServiceURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-sso-service-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="SingleLogoutProtocolProfile">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-slo-protocol-profile</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="FederationTerminationNotificationProtocolProfile">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-federation-termination-protocol-profile</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="AssertionConsumerServiceURL">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-assertion-consumer-service-url</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>
<xsl:template match="AuthnRequestsSigned">
 <xsl:call-template name="attrValPair">
   <xsl:with-param name="attrName">iplanet-am-authnrequest-signed</xsl:with-param>
   <xsl:with-param name="attrVal" select="."/>
 </xsl:call-template>
</xsl:template>

<!-- This is a template which takes two parameters
  attrName and attrVal and generates an AttributeValuePair
  element that sticks to the AVPair as defined by amAdmin.dtd
-->

<xsl:template name="attrValPair">
  <xsl:param name="attrName"/>
  <xsl:param name="attrVal"/>
  <xsl:text> 
  </xsl:text>
  <xsl:element name="AttributeValuePair">
  	<xsl:text> 
  	</xsl:text>
  	<xsl:element name="Attribute">
        <xsl:attribute name="name">
	  <xsl:value-of select="$attrName"/>
	</xsl:attribute>
   	</xsl:element>
  	<xsl:text> 
  	</xsl:text>
  	<xsl:element name="Value">
	  <xsl:value-of select="$attrVal"/>
   	</xsl:element>
  <xsl:text> 
  </xsl:text>
  </xsl:element>
</xsl:template>
</xsl:stylesheet>

