/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.iplanet.am.util.Debug;

public final class ThreadPool {
    private static int nextThreadID = 1;
    private Debug debug;
    private String poolName;
    private IPSThread[] allThreadList;
    private IPSThread[] idleThreadList;
    private volatile int tail = -1;

    public ThreadPool(String string, int n, boolean bl, Debug debug) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Must assign a non-null pool name to ThreadPool");
        }
        this.poolName = string;
        this.debug = debug;
        n = Math.max(1, n);
        this.idleThreadList = new IPSThread[n];
        this.allThreadList = new IPSThread[n];
        int n2 = 0;
        while (n2 < n) {
            this.allThreadList[n2] = new IPSThread(this.getNextIPSThreadID(), bl);
            ++n2;
        }
    }

    private ThreadPool() {
    }

    private synchronized String getNextIPSThreadID() {
        return this.poolName + ".Thread#" + Integer.toString(nextThreadID++);
    }

    public final void run(Runnable runnable) throws InterruptedException {
        IPSThread iPSThread;
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            while (this.tail == -1) {
                if (this.debug != null && this.debug.warningEnabled()) {
                    this.debug.warning(Thread.currentThread().getName() + " waiting for an idle thread in " + this.toString());
                }
                this.idleThreadList.wait();
            }
            iPSThread = this.idleThreadList[this.tail--];
        }
        iPSThread.process(runnable);
    }

    public final void stopIdleThreads() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            while (this.tail >= 0) {
                IPSThread iPSThread = this.idleThreadList[this.tail];
                this.idleThreadList[this.tail--] = null;
                iPSThread.stop();
            }
        }
    }

    public final void destroy() {
        this.stopIdleThreads();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        IPSThread[] iPSThreadArray = this.allThreadList;
        synchronized (iPSThreadArray) {
            int n = this.allThreadList.length;
            int n2 = 0;
            while (n2 < n) {
                IPSThread iPSThread = this.allThreadList[n2];
                this.allThreadList[n2++] = null;
                if (!iPSThread.isAlive()) continue;
                iPSThread.stop();
            }
        }
    }

    public String toString() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (iPSThreadArray) {
            String string = this.poolName + "[" + this.allThreadList.length + " Total threads, " + (this.tail >= 0 ? this.tail + 1 : 0) + " Idle threads]";
            return string;
        }
    }

    public final String getName() {
        return this.poolName;
    }

    private final void logMessage(String string) {
        if (this.debug == null) {
            return;
        }
        this.debug.message(string);
    }

    private final class IPSThread {
        private volatile Runnable task;
        private Thread thread;
        private volatile boolean stopped = false;

        IPSThread(String string, boolean bl) {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ IPSThread this$1;
                {
                    this.this$1 = iPSThread;
                }

                public void run() {
                    block2: {
                        try {
                            IPSThread.access$100(this.this$1);
                        }
                        catch (Throwable throwable) {
                            if (ThreadPool.access$300(IPSThread.access$200(this.this$1)) == null) break block2;
                            ThreadPool.access$300(IPSThread.access$200(this.this$1)).error(IPSThread.access$400(this.this$1).getName() + " caught exception that fell through", throwable);
                        }
                    }
                }
            };
            this.thread = new Thread(runnable, string);
            this.thread.setDaemon(bl);
            this.thread.start();
        }

        private IPSThread() {
        }

        final synchronized void process(Runnable runnable) throws InterruptedException {
            this.task = runnable;
            this.notify();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void runTask() {
            while (true) {
                Object var7_7;
                if (this.stopped) {
                    if (ThreadPool.this.debug != null) {
                        ThreadPool.this.debug.error(this.thread.getName() + " stopped.", null);
                    }
                    return;
                }
                try {
                    try {
                        block21: {
                            IPSThread[] iPSThreadArray = ThreadPool.this.idleThreadList;
                            synchronized (iPSThreadArray) {
                                ((ThreadPool)ThreadPool.this).idleThreadList[++((ThreadPool)ThreadPool.this).tail] = this;
                                if (ThreadPool.this.tail == 0) {
                                    ThreadPool.this.idleThreadList.notifyAll();
                                }
                            }
                            IPSThread iPSThread = this;
                            synchronized (iPSThread) {
                                while (true) {
                                    if (this.task != null) {
                                        Object var5_6;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 7, 13, 14] lbl18 : MonitorExitStatement: MONITOREXIT : iPSThread
                                        try {
                                            try {
                                                this.task.run();
                                            }
                                            catch (Exception exception) {
                                                if (ThreadPool.this.debug != null) {
                                                    ThreadPool.this.debug.error(this.thread.getName() + " caught exception that fell through from " + this.task + ".run()", exception);
                                                }
                                                var5_6 = null;
                                                Thread.interrupted();
                                                break block21;
                                            }
                                            var5_6 = null;
                                            break;
                                        }
                                        catch (Throwable throwable) {
                                            var5_6 = null;
                                            Thread.interrupted();
                                            throw throwable;
                                        }
                                    }
                                    this.wait();
                                }
                            }
                            Thread.interrupted();
                        }
                        var7_7 = null;
                        this.task = null;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        var7_7 = null;
                        this.task = null;
                    }
                    catch (Throwable throwable) {
                        if (ThreadPool.this.debug != null) {
                            ThreadPool.this.debug.error(this.thread.getName() + ": runTask() caught throwable. Investigate the problem", throwable);
                        }
                        var7_7 = null;
                        this.task = null;
                    }
                }
                catch (Throwable throwable) {
                    var7_7 = null;
                    this.task = null;
                    throw throwable;
                }
            }
        }

        private final void stop() {
            ThreadPool.this.logMessage(this.thread.getName() + " received stop() request.");
            this.stopped = true;
            this.thread.interrupt();
        }

        final String getName() {
            return this.thread.getName();
        }

        final boolean isAlive() {
            return this.thread.isAlive();
        }

        static /* synthetic */ void access$100(IPSThread iPSThread) {
            iPSThread.runTask();
        }

        static /* synthetic */ ThreadPool access$200(IPSThread iPSThread) {
            return iPSThread.ThreadPool.this;
        }

        static /* synthetic */ Thread access$400(IPSThread iPSThread) {
            return iPSThread.thread;
        }
    }
}

