/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.client;

import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.client.AlreadyRegisteredException;
import com.iplanet.services.comm.client.NotificationHandler;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.PLLBundle;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.ResponseSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.Cookie;

public class PLLClient {
    private static final String sccsID = "$Id: PLLClient.java,v 1.18.24.3 2005/05/15 23:22:05 gc111264 Exp $ $Date: 2005/05/15 23:22:05 $  Sun Microsystems, Inc.";
    private static Hashtable notificationHandlers = new Hashtable();
    private static Debug debug = Debug.getInstance("PLLClient");

    public static Vector send(URL uRL, RequestSet requestSet) throws SendRequestException {
        return PLLClient.send(uRL, null, requestSet, null);
    }

    public static Vector send(URL uRL, String string, RequestSet requestSet) throws SendRequestException {
        return PLLClient.send(uRL, string, requestSet, null);
    }

    public static Vector send(URL uRL, RequestSet requestSet, HashMap hashMap) throws SendRequestException {
        return PLLClient.send(uRL, null, requestSet, hashMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector send(URL uRL, String string, RequestSet requestSet, HashMap hashMap) throws SendRequestException {
        Vector vector;
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        try {
            try {
                Object object;
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("POST");
                StringBuffer stringBuffer = null;
                if (string != null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string);
                }
                if (hashMap != null && !hashMap.isEmpty()) {
                    object = hashMap.values().iterator();
                    while (object.hasNext()) {
                        Cookie cookie = (Cookie)object.next();
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        } else {
                            stringBuffer.append(";");
                        }
                        stringBuffer.append(cookie.getName()).append("=").append(cookie.getValue());
                    }
                }
                if (stringBuffer != null) {
                    string = stringBuffer.toString();
                    if (debug.messageEnabled()) {
                        debug.message("sending cookies: " + string);
                    }
                    httpURLConnection.setRequestProperty("Cookie", string);
                }
                httpURLConnection.setRequestProperty("Content-Type", "text/xml;charset=UTF-8");
                object = requestSet.toXMLString();
                int n2 = ((String)object).getBytes("UTF-8").length;
                httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write(((String)object).getBytes("UTF-8"));
                outputStream.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
                StringBuffer stringBuffer2 = new StringBuffer();
                char[] cArray = new char[1024];
                while (true) {
                    int n;
                    if ((n = bufferedReader.read(cArray, 0, cArray.length)) == -1) {
                        String string2 = stringBuffer2.toString();
                        PLLClient.parseCookies(httpURLConnection, hashMap);
                        ResponseSet responseSet = ResponseSet.parseXML(string2);
                        vector = responseSet.getResponses();
                        Object var17_18 = null;
                        if (outputStream == null) return vector;
                        break;
                    }
                    stringBuffer2.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                debug.message("PLLClient send exception: ", exception);
                throw new SendRequestException(exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new SendRequestException(iOException.getMessage());
            }
        }
        try {}
        catch (IOException iOException) {
            throw new SendRequestException(iOException.getMessage());
        }
        outputStream.close();
        return vector;
    }

    private static void parseCookies(HttpURLConnection httpURLConnection, HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        int n = 1;
        String string = null;
        String string2 = null;
        while ((string = ((URLConnection)httpURLConnection).getHeaderFieldKey(n)) != null && string.length() != 0) {
            if (string.equals("Set-cookie")) {
                string2 = ((URLConnection)httpURLConnection).getHeaderField(n);
                if (debug.messageEnabled()) {
                    debug.message("Cookie header in parseCookies(): " + string2);
                }
                PLLClient.addCookie2Table(string2, hashMap);
            }
            ++n;
        }
    }

    private static void addCookie2Table(String string, HashMap hashMap) {
        int n = string.indexOf("=");
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1);
        if ((n = string3.indexOf(";")) > 0) {
            string3 = string3.substring(0, n).trim();
        }
        Cookie cookie = new Cookie(string2, string3);
        hashMap.put(string2, cookie);
    }

    public static void addNotificationHandler(String string, NotificationHandler notificationHandler) throws AlreadyRegisteredException {
        if (notificationHandlers.containsKey(string)) {
            throw new AlreadyRegisteredException(PLLBundle.getString("alreadyRegistered") + string);
        }
        notificationHandlers.put(string, notificationHandler);
    }

    public static void removeNotificationHandler(String string) {
        notificationHandlers.remove(string);
    }

    public static NotificationHandler getNotificationHandler(String string) {
        return (NotificationHandler)notificationHandlers.get(string);
    }
}

