/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequestParser;
import com.iplanet.dpro.session.share.SessionResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SessionResponseParser {
    private SessionResponse sessionResponse = null;
    Document document;

    public SessionResponseParser(Document document) {
        this.document = document;
    }

    public SessionResponseParser(String string) {
        this.document = XMLUtils.toDOMDocument(string, SessionRequestParser.debug);
    }

    public SessionResponse parseXML() throws SessionException {
        Object object;
        if (this.document == null) {
            return null;
        }
        Element element = this.document.getDocumentElement();
        this.sessionResponse = new SessionResponse();
        String string = element.getAttribute("vers");
        this.sessionResponse.setResponseVersion(string);
        string = element.getAttribute("reqid");
        this.sessionResponse.setRequestID(string);
        NodeList nodeList = element.getElementsByTagName("GetSession");
        if (nodeList != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(0);
        }
        if ((nodeList = element.getElementsByTagName("GetActiveSessions")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(1);
        }
        if ((nodeList = element.getElementsByTagName("DestroySession")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(2);
        }
        if ((nodeList = element.getElementsByTagName("Logout")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(3);
        }
        if ((nodeList = element.getElementsByTagName("AddSessionListener")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(4);
        }
        if ((nodeList = element.getElementsByTagName("AddSessionListenerOnAllSessions")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(5);
        }
        if ((nodeList = element.getElementsByTagName("SetProperty")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setMethodID(6);
        }
        if ((nodeList = element.getElementsByTagName("Session")) != null && nodeList.getLength() != 0) {
            this.parseSessionElements(nodeList);
        }
        if ((nodeList = element.getElementsByTagName("OK")) != null && nodeList.getLength() != 0) {
            this.sessionResponse.setBooleanFlag(true);
        }
        if ((nodeList = element.getElementsByTagName("Exception")) != null && nodeList.getLength() != 0) {
            object = (Element)nodeList.item(0);
            this.sessionResponse.setException(SessionRequestParser.parseCDATA((Element)object));
        }
        if ((nodeList = element.getElementsByTagName("Status")) != null && nodeList.getLength() != 0) {
            object = SessionRequestParser.parseCDATA((Element)nodeList.item(0));
            try {
                this.sessionResponse.setStatus(Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                SessionRequestParser.debug.error("SessionResponseParse : ", numberFormatException);
                throw new SessionException(numberFormatException.getMessage());
            }
        }
        return this.sessionResponse;
    }

    private void parseSessionElements(NodeList nodeList) {
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            SessionInfo sessionInfo = SessionResponseParser.parseSessionElement(element);
            this.sessionResponse.addSessionInfo(sessionInfo);
            SessionRequestParser.debug.message("In parse session " + sessionInfo.toString());
            ++n2;
        }
    }

    static SessionInfo parseSessionElement(Element element) {
        NodeList nodeList;
        SessionInfo sessionInfo = new SessionInfo();
        String string = element.getAttribute("sid");
        if (string != null) {
            sessionInfo.sid = string;
        }
        if ((string = element.getAttribute("stype")) != null) {
            sessionInfo.stype = string;
        }
        if ((string = element.getAttribute("cid")) != null) {
            sessionInfo.cid = string;
        }
        if ((string = element.getAttribute("cdomain")) != null) {
            sessionInfo.cdomain = string;
        }
        if ((string = element.getAttribute("maxtime")) != null) {
            sessionInfo.maxtime = string;
        }
        if ((string = element.getAttribute("maxidle")) != null) {
            sessionInfo.maxidle = string;
        }
        if ((string = element.getAttribute("maxcaching")) != null) {
            sessionInfo.maxcaching = string;
        }
        if ((string = element.getAttribute("timeleft")) != null) {
            sessionInfo.timeleft = string;
        }
        if ((string = element.getAttribute("timeidle")) != null) {
            sessionInfo.timeidle = string;
        }
        if ((string = element.getAttribute("state")) != null) {
            sessionInfo.state = string;
        }
        if ((nodeList = element.getElementsByTagName("Property")) != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                String string2 = element2.getAttribute("name");
                if (string2 != null) {
                    sessionInfo.properties.put(string2, element2.getAttribute("value"));
                }
                ++n2;
            }
        }
        return sessionInfo;
    }
}

