/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionResponseParser;
import java.util.Vector;

public class SessionResponse {
    private static final String sccsID = "$Id: SessionResponse.java,v 1.11 2003/07/13 04:01:51 vs125812 Exp $ $Date: 2003/07/13 04:01:51 $  Sun Microsystems, Inc.";
    static final String QUOTE = "\"";
    static final String NL = "\n";
    private String responseVersion = "1.0";
    private String requestID = null;
    private int methodID;
    private Vector sessionInfoVector = new Vector();
    private boolean booleanFlag = false;
    private String exception = null;
    private int status = -1;

    public SessionResponse(String string, int n) {
        this.requestID = string;
        this.methodID = n;
    }

    SessionResponse() {
    }

    public static SessionResponse parseXML(String string) throws SessionException {
        SessionResponseParser sessionResponseParser = new SessionResponseParser(string);
        return sessionResponseParser.parseXML();
    }

    void setResponseVersion(String string) {
        this.responseVersion = string;
    }

    public String getResponseVersion() {
        return this.responseVersion;
    }

    void setRequestID(String string) {
        this.requestID = string;
    }

    public String getRequestID() {
        return this.requestID;
    }

    void setMethodID(int n) {
        this.methodID = n;
    }

    public int getMethodID() {
        return this.methodID;
    }

    public void addSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfoVector.add(sessionInfo);
    }

    public Vector getSessionInfoVector() {
        return this.sessionInfoVector;
    }

    public void setSessionInfoVector(Vector vector) {
        this.sessionInfoVector = vector;
    }

    public void setBooleanFlag(boolean bl) {
        this.booleanFlag = bl;
    }

    public boolean getBooleanFlag() {
        return this.booleanFlag;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String string) {
        this.exception = string;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SessionResponse vers=\"" + this.responseVersion + QUOTE + " reqid=" + QUOTE + this.requestID + QUOTE + ">" + NL);
        switch (this.methodID) {
            case 0: {
                stringBuffer.append("<GetSession>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    if (this.sessionInfoVector.size() != 1) {
                        return null;
                    }
                    SessionInfo sessionInfo = (SessionInfo)this.sessionInfoVector.elementAt(0);
                    stringBuffer.append(sessionInfo.toXMLString());
                }
                stringBuffer.append("</GetSession>\n");
                break;
            }
            case 1: {
                stringBuffer.append("<GetValidSessions>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<SessionList>\n");
                    int n = 0;
                    while (n < this.sessionInfoVector.size()) {
                        SessionInfo sessionInfo = (SessionInfo)this.sessionInfoVector.elementAt(n);
                        stringBuffer.append(sessionInfo.toXMLString());
                        ++n;
                    }
                    stringBuffer.append("</SessionList>\n");
                    stringBuffer.append("<Status>" + Integer.toString(this.status) + "</Status>" + NL);
                }
                stringBuffer.append("</GetValidSessions>\n");
                break;
            }
            case 2: {
                stringBuffer.append("<DestroySession>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<OK></OK>\n");
                }
                stringBuffer.append("</DestroySession>\n");
                break;
            }
            case 3: {
                stringBuffer.append("<Logout>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<OK></OK>\n");
                }
                stringBuffer.append("</Logout>\n");
                break;
            }
            case 4: {
                stringBuffer.append("<AddSessionListener>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<OK></OK>\n");
                }
                stringBuffer.append("</AddSessionListener>\n");
                break;
            }
            case 5: {
                stringBuffer.append("<AddSessionListenerOnAllSessions>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<OK></OK>\n");
                }
                stringBuffer.append("</AddSessionListenerOnAllSessions>\n");
                break;
            }
            case 6: {
                stringBuffer.append("<SetProperty>\n");
                if (this.exception != null) {
                    stringBuffer.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    stringBuffer.append("<OK></OK>\n");
                }
                stringBuffer.append("</SetProperty>\n");
                break;
            }
            default: {
                return null;
            }
        }
        stringBuffer.append("</SessionResponse>");
        return stringBuffer.toString();
    }
}

