/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SecureRandomManager;
import com.iplanet.am.util.Stats;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionNotificationHandler;
import com.iplanet.dpro.session.SessionTimedOutException;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionConfigListener;
import com.iplanet.dpro.session.service.SessionMaxStats;
import com.iplanet.dpro.session.service.SessionMonitor;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionNotification;
import com.iplanet.security.x509.X500Name;
import com.iplanet.services.comm.server.PLLServer;
import com.iplanet.services.comm.share.Notification;
import com.iplanet.services.comm.share.NotificationSet;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.Logger;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.http.HttpSession;

public class SessionService {
    private static final String sccsID = "@(#)SessionService.java       1.26  00/04/06 04/06/00  Sun Microsystems, Inc.";
    private static ThreadPool threadPool;
    static SSOTokenManager ssoManager;
    public static Debug sessionDebug;
    public static int maxSessions;
    private static int numberOfActiveSessions;
    private static String dsameAdminDN;
    public static Stats stats;
    private static SessionMaxStats maxSessionStats;
    private static Logger logger;
    private static boolean logStatus;
    public static final String SHANDLE_SCHEME_PREFIX = "shandle:";
    private static final String amSessionService = "iPlanetAMSessionService";
    private static final String httpSessionTrackingCookieName = "JSESSIONID";
    private static final String httpSessionPropertyName = "DSAMEInternalSession";
    private static final String httpSessionOwnerPropertyName = "DSAMEInternalSession.owner";
    private static final String amSSOLogFile = "amSSO.access";
    private static boolean isEnableHostLookUp;
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_THRESHOLD = 100;
    protected static final String securityCookieName = "DSAMESecurityCookie";
    private static final String webContainer;
    private static boolean isWeblogicFlag;
    protected static final String defaultApplicationMaxCachingTime;
    protected static final long applicationMaxCachingTime;
    private static SSOToken sessionServiceToken;
    public static final String SESSION_SERVICE = "session";
    private SecureRandom secureRandom = null;
    private Hashtable sessionTable = null;
    private Hashtable sessionHandleTable = new Hashtable();
    private String sessionServer;
    private String sessionServerPort;
    private String sessionServerProtocol;
    private String sessionServerID;
    private static volatile SessionService volatileRef;
    private static SessionService sessionService;
    public static String deploymentURI;
    private static boolean isSessionFailoverEnabled;
    private String thisSessionServer;
    private String thisSessionServerPortAsString;
    private int thisSessionServerPort;
    private String thisSessionServerProtocol;
    private String thisSessionServerURL;
    private URL thisSessionServiceURL;
    private InternalSession authSession = null;
    private Vector sessionEventURLs = new Vector();
    private URL sessionServiceID = null;
    static /* synthetic */ Class class$com$iplanet$dpro$session$service$SessionService;

    public static SessionService getSessionService() {
        if (sessionService == null) {
            Class clazz = class$com$iplanet$dpro$session$service$SessionService == null ? (class$com$iplanet$dpro$session$service$SessionService = SessionService.class$("com.iplanet.dpro.session.service.SessionService")) : class$com$iplanet$dpro$session$service$SessionService;
            synchronized (clazz) {
                if (volatileRef == null) {
                    volatileRef = new SessionService();
                }
            }
            sessionService = volatileRef;
            sessionService.postInit();
        }
        return sessionService;
    }

    public static boolean isInitialized() {
        return sessionService != null;
    }

    private static String getHttpSessionTrackingCookieName() {
        return httpSessionTrackingCookieName;
    }

    public Session getAuthenticationSession(String string, HttpSession httpSession) {
        try {
            if (this.authSession == null) {
                this.authSession = this.getServiceSession(string, httpSession);
            }
            return this.authSession != null ? Session.getSession(this.authSession.getID()) : null;
        }
        catch (Exception exception) {
            sessionDebug.error("Error creating service session", exception);
            return null;
        }
    }

    private InternalSession getServiceSession(String string, HttpSession httpSession) {
        try {
            InternalSession internalSession = null;
            internalSession = this.newInternalSession(string, httpSession);
            internalSession.setType(1);
            String string2 = (String)AccessController.doPrivileged(new AdminDNAction());
            internalSession.setClientID(string2);
            internalSession.setClientDomain(string);
            internalSession.setExpire(false);
            internalSession.setState(1);
            SessionService.incrementActiveSessions();
            return internalSession;
        }
        catch (Exception exception) {
            sessionDebug.error("Error creating service session", exception);
            return null;
        }
    }

    public InternalSession newInternalSession(String string, HttpSession httpSession) {
        if (isSessionFailoverEnabled && httpSession == null) {
            return this.createSession(string);
        }
        InternalSession internalSession = null;
        SessionID sessionID = null;
        sessionID = this.generateSessionId(string, httpSession);
        String string2 = SHANDLE_SCHEME_PREFIX + this.generateSessionId(string, null).toString();
        internalSession = new InternalSession(sessionID);
        internalSession.setSessionHandle(string2);
        internalSession.setHttpSession(httpSession);
        this.sessionTable.put(sessionID, internalSession);
        this.sessionHandleTable.put(string2, internalSession);
        internalSession.setCreationTime();
        internalSession.setLatestAccessTime();
        return internalSession;
    }

    private SessionID generateSessionId(String string, HttpSession httpSession) {
        String string2;
        String string3;
        SessionID sessionID;
        do {
            int n;
            string2 = Long.toHexString(this.secureRandom.nextLong());
            string3 = (String)AccessController.doPrivileged(new EncodeAction(string2 + "@" + this.sessionServerID, Crypt.getHardcodedKeyEncryptor()));
            if (!isSessionFailoverEnabled || httpSession == null) continue;
            String string4 = httpSession.getId();
            if (isWeblogicFlag && (n = string4.lastIndexOf(33)) != -1) {
                string4 = string4.substring(0, n);
            }
            string3 = string3 + "@" + string4;
        } while (this.sessionTable.get(sessionID = isSessionFailoverEnabled ? new SessionID(string3, string2, this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString, string) : new SessionID(string3, string2, this.sessionServerProtocol, this.sessionServer, this.sessionServerPort, string)) != null || this.sessionHandleTable.get(sessionID) != null);
        return sessionID;
    }

    InternalSession removeInternalSession(SessionID sessionID) {
        InternalSession internalSession;
        block6: {
            if (sessionID == null) {
                return null;
            }
            internalSession = (InternalSession)this.sessionTable.remove(sessionID);
            if (internalSession == null) {
                internalSession = this.recoverSession(sessionID);
                this.sessionTable.remove(sessionID);
            }
            if (internalSession != null) {
                this.removeSessionHandle(internalSession);
                HttpSession httpSession = internalSession.getHttpSession();
                if (httpSession != null) {
                    try {
                        httpSession.removeAttribute(httpSessionPropertyName);
                        httpSession.invalidate();
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (!sessionDebug.messageEnabled()) break block6;
                        sessionDebug.message("Exception:removeInternalSession: the web containers session timeout could be shorter than the IS session timeout", illegalStateException);
                    }
                }
            }
        }
        return internalSession;
    }

    private void removeSessionHandle(InternalSession internalSession) {
        if (internalSession == null) {
            return;
        }
        String string = internalSession.getSessionHandle();
        if (string != null) {
            this.sessionHandleTable.remove(string);
        }
    }

    public boolean isSessionFailoverEnabled() {
        return isSessionFailoverEnabled;
    }

    public boolean isLocalSession(SessionID sessionID) {
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        return internalSession != null;
    }

    public boolean isLocalSessionService(URL uRL) {
        URL uRL2 = isSessionFailoverEnabled ? this.thisSessionServiceURL : this.sessionServiceID;
        return uRL2 != null && uRL2.getProtocol().equalsIgnoreCase(uRL.getProtocol()) && uRL2.getHost().equalsIgnoreCase(uRL.getHost()) && uRL2.getPort() == uRL.getPort();
    }

    public InternalSession getInternalSession(SessionID sessionID) {
        if (sessionID == null) {
            return null;
        }
        if (sessionID.toString().startsWith(SHANDLE_SCHEME_PREFIX)) {
            return null;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.get(sessionID);
        if (internalSession == null) {
            internalSession = this.recoverSession(sessionID);
        }
        return internalSession;
    }

    public InternalSession getInternalSessionByHandle(String string) {
        return (InternalSession)this.sessionHandleTable.get(string);
    }

    private Vector getValidInternalSessions() {
        Vector<InternalSession> vector = new Vector<InternalSession>();
        Hashtable hashtable = this.sessionTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.sessionTable.elements();
            while (enumeration.hasMoreElements()) {
                InternalSession internalSession = (InternalSession)enumeration.nextElement();
                if (internalSession.getState() != 1 || !internalSession.willExpire()) continue;
                vector.addElement(internalSession);
            }
        }
        return vector;
    }

    private Vector getValidInternalSessions(String string, int[] nArray) throws SessionException {
        Vector<InternalSession> vector = new Vector<InternalSession>();
        if (string == null) {
            string = "*";
        }
        try {
            long l = System.currentTimeMillis();
            string = string.toLowerCase();
            Vector vector2 = this.getValidInternalSessions();
            Enumeration enumeration = vector2.elements();
            String string2 = AMStoreConnection.getUserNamingAttribute();
            boolean bl = string.equals("*");
            while (enumeration.hasMoreElements()) {
                String string3;
                InternalSession internalSession = (InternalSession)enumeration.nextElement();
                if (!bl && ((string3 = new X500Name(internalSession.getClientID()).getAttributeValue(string2)) == null || !SessionService.matchFilter(string3 = string3.toLowerCase(), string))) continue;
                if (vector.size() == SessionConfigListener.getMaxsize()) {
                    nArray[0] = 1;
                } else {
                    vector.addElement(internalSession);
                    if (System.currentTimeMillis() - l < SessionConfigListener.getTimeout()) continue;
                    nArray[0] = 2;
                }
                break;
            }
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService : Unable to get Session Information ", exception);
            throw new SessionException(exception);
        }
        return vector;
    }

    public void destroyInternalSession(SessionID sessionID) {
        InternalSession internalSession = this.removeInternalSession(sessionID);
        internalSession.setIsISStored(false);
        if (internalSession != null && internalSession.getState() != 0) {
            if (internalSession.getState() == 1) {
                SessionService.decrementActiveSessions();
            }
            this.logEvent(internalSession, 5);
            internalSession.setState(3);
            this.sendEvent(internalSession, 5);
        }
    }

    public void logoutInternalSession(SessionID sessionID) {
        InternalSession internalSession = this.removeInternalSession(sessionID);
        if (internalSession != null && internalSession.getState() != 0) {
            if (internalSession.getState() == 1) {
                SessionService.decrementActiveSessions();
            }
            this.logEvent(internalSession, 3);
            internalSession.setState(3);
            this.sendEvent(internalSession, 3);
        }
    }

    public static synchronized void decrementActiveSessions() {
        --numberOfActiveSessions;
    }

    public static synchronized void incrementActiveSessions() {
        ++numberOfActiveSessions;
    }

    public static synchronized int getActiveSessions() {
        return numberOfActiveSessions;
    }

    private void addInternalSessionListener(SessionID sessionID, String string) {
        Vector vector;
        InternalSession internalSession = this.getInternalSession(sessionID);
        if (internalSession != null && !(vector = internalSession.getSessionEventURLs()).contains(string)) {
            vector.addElement(string);
            internalSession.updateForFailover();
        }
    }

    private void addListenerOnAllInternalSessions(String string) {
        if (!this.sessionEventURLs.contains(string)) {
            this.sessionEventURLs.addElement(string);
        }
    }

    public InternalSession getSession(SessionID sessionID, boolean bl) throws SessionException {
        InternalSession internalSession = this.locateSession(sessionID);
        if (internalSession.getState() != 1) {
            if (internalSession.getTimeLeftBeforePurge() > 0L) {
                throw new SessionTimedOutException(SessionBundle.getString("sessionTimedOut") + " " + sessionID.toString());
            }
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sessionID.toString());
        }
        if (bl) {
            internalSession.setLatestAccessTime();
        }
        return internalSession;
    }

    public Vector getValidSessions(Session session) throws SessionException {
        int[] nArray = new int[]{0};
        return this.getValidSessions(session, null, nArray);
    }

    public Vector getValidSessions(Session session, String string, int[] nArray) throws SessionException {
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + session.getID().toString());
        }
        try {
            AMUser aMUser = this.getUser(session);
            Set set = aMUser.getAttribute("iplanet-am-session-get-valid-sessions");
            Vector vector = sessionService.getValidInternalSessions(string, nArray);
            Vector<SessionInfo> vector2 = new Vector<SessionInfo>();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                InternalSession internalSession = (InternalSession)vector.elementAt(n2);
                SessionInfo sessionInfo = internalSession.toSessionInfo();
                sessionInfo.sid = internalSession.getSessionHandle();
                if (this.hasTopLevelAdminRole(session) || set.contains(internalSession.getClientDomain())) {
                    vector2.add(sessionInfo);
                }
                ++n2;
            }
            return vector2;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void destroySession(Session session, SessionID sessionID) throws SessionException {
        if (sessionID == null) {
            return;
        }
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sessionID.toString());
        }
        InternalSession internalSession = sessionService.getInternalSession(sessionID);
        if (internalSession == null) {
            internalSession = sessionService.getInternalSessionByHandle(sessionID.toString());
        }
        if (internalSession != null) {
            sessionID = internalSession.getID();
            try {
                if (session.getID().equals(sessionID) || this.hasTopLevelAdminRole(session)) {
                    sessionService.destroyInternalSession(sessionID);
                    return;
                }
                AMUser aMUser = this.getUser(session);
                Set set = aMUser.getAttribute("iplanet-am-session-destroy-sessions");
                if (!set.contains(session.getClientDomain())) {
                    throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
                }
                sessionService.destroyInternalSession(sessionID);
            }
            catch (Exception exception) {
                throw new SessionException(exception);
            }
        }
    }

    public void logout(SessionID sessionID) throws SessionException {
        InternalSession internalSession = this.locateSession(sessionID);
        this.logoutInternalSession(sessionID);
    }

    public void addSessionListener(SessionID sessionID, String string) throws SessionException {
        InternalSession internalSession = this.locateSession(sessionID);
        if (internalSession.getState() == 0) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + sessionID.toString());
        }
        this.addInternalSessionListener(sessionID, string);
    }

    public void addSessionListenerOnAllSessions(Session session, String string) throws SessionException {
        if (session.getState(false) != 1) {
            throw new SessionException(SessionBundle.getString("invalidSessionState") + session.getID().toString());
        }
        if (session.getClientID().equals(dsameAdminDN)) {
            this.addListenerOnAllInternalSessions(string);
            return;
        }
        try {
            AMUser aMUser = this.getUser(session);
            String string2 = aMUser.getStringAttribute("iplanet-am-session-add-session-listener-on-all-sessions");
            if (string2.equals("false")) {
                throw new SessionException(SessionBundle.rbName, "noPrivilege", null);
            }
            this.addListenerOnAllInternalSessions(string);
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }

    public void setProperty(SessionID sessionID, String string, String string2) throws SessionException {
        this.locateSession(sessionID).putProperty(string, string2);
    }

    protected InternalSession locateSession(SessionID sessionID) throws SessionException {
        InternalSession internalSession = this.getInternalSession(sessionID);
        if (internalSession == null) {
            throw new SessionException(SessionBundle.getString("invalidSessionID") + sessionID.toString());
        }
        return internalSession;
    }

    public void setExternalProperty(SessionID sessionID, String string, String string2) throws SessionException {
        this.locateSession(sessionID).putExternalProperty(string, string2);
    }

    public void sendEvent(InternalSession internalSession, int n) {
        sessionDebug.message("Running sendEvent, type = " + n);
        try {
            threadPool.run(new SessionNotificationSender(this, internalSession, n));
        }
        catch (ThreadPoolException threadPoolException) {
            sessionDebug.error("Sending Notification Error: ", threadPoolException);
        }
    }

    public void logEvent(InternalSession internalSession, int n) {
        switch (n) {
            case 0: {
                this.logIt(internalSession, "SESSION CREATE");
                break;
            }
            case 1: {
                this.logIt(internalSession, "IDLE TIMEOUT");
                break;
            }
            case 2: {
                this.logIt(internalSession, "MAX TIMEOUT");
                break;
            }
            case 3: {
                this.logIt(internalSession, "LOGOUT");
                break;
            }
            case 4: {
                this.logIt(internalSession, "REACTIVATION");
                break;
            }
            case 5: {
                this.logIt(internalSession, "DESTROY");
                break;
            }
            default: {
                this.logIt(internalSession, "UNKNOWN EVENT");
            }
        }
    }

    public void logIt(InternalSession internalSession, String string) {
        if (!logStatus) {
            return;
        }
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            Object var7_8 = null;
            Object var8_9 = null;
            com.sun.identity.log.LogRecord logRecord = null;
            String string6 = internalSession.getID().toString();
            logRecord = new com.sun.identity.log.LogRecord(Level.INFO, string);
            logRecord.addLogInfo("LoginIDSid", (Object)string6);
            string2 = internalSession.getClientID();
            string3 = internalSession.getClientDomain();
            string5 = internalSession.getProperty("Host");
            string4 = internalSession.getProperty("HostName");
            logRecord.addLogInfo("LoginID", (Object)string2);
            logRecord.addLogInfo("LogLevel", (Object)logRecord.getLevel().toString());
            logRecord.addLogInfo("Domain", (Object)string3);
            logRecord.addLogInfo("IPAddr", (Object)string5);
            logRecord.addLogInfo("HostName", (Object)string4);
            this.getLogger().log((LogRecord)logRecord, (Object)this.getSessionServiceToken());
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.logIt(): Cannot write to the session log file: ", exception);
        }
    }

    private SSOTokenManager getSSOTokenManager() throws SSOException {
        if (ssoManager == null) {
            ssoManager = SSOTokenManager.getInstance();
        }
        return ssoManager;
    }

    private SSOToken getSessionServiceToken() throws Exception {
        if (sessionServiceToken == null) {
            InternalSession internalSession = this.getServiceSession("SessionService-" + this.sessionServer, null);
            this.setProperty(internalSession.getID(), "Principal", internalSession.getClientID());
            sessionServiceToken = this.getSSOTokenManager().createSSOToken(internalSession.getID().toString());
        }
        return sessionServiceToken;
    }

    private Logger getLogger() {
        if (logger == null) {
            logger = (Logger)Logger.getLogger((String)amSSOLogFile);
        }
        return logger;
    }

    private SessionService() {
        try {
            dsameAdminDN = (String)AccessController.doPrivileged(new AdminDNAction());
            if (isSessionFailoverEnabled) {
                this.thisSessionServerProtocol = SystemProperties.get("com.iplanet.am.localserver.protocol");
                this.thisSessionServer = SystemProperties.get("com.iplanet.am.localserver.host");
                this.thisSessionServerPortAsString = SystemProperties.get("com.iplanet.am.localserver.port");
                if (this.thisSessionServerProtocol == null || this.thisSessionServerPortAsString == null || this.thisSessionServer == null) {
                    throw new SessionException(SessionBundle.rbName, "propertyMustBeSet", null);
                }
                this.thisSessionServerPort = Integer.parseInt(this.thisSessionServerPortAsString);
                this.thisSessionServerURL = this.thisSessionServerProtocol + "://" + this.thisSessionServer + ":" + this.thisSessionServerPortAsString;
                this.thisSessionServiceURL = Session.getSessionServiceURL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPortAsString);
            }
            this.sessionServerProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
            this.sessionServer = SystemProperties.get("com.iplanet.am.server.host");
            this.sessionServerPort = SystemProperties.get("com.iplanet.am.server.port");
            this.sessionServiceID = new URL(this.sessionServerProtocol, this.sessionServer, Integer.parseInt(this.sessionServerPort), "");
            this.sessionServerID = WebtopNaming.getServerID(this.sessionServerProtocol, this.sessionServer, this.sessionServerPort);
            this.secureRandom = SecureRandomManager.getSecureRandom();
            this.sessionTable = new Hashtable();
            if (stats.isEnabled()) {
                maxSessionStats = new SessionMaxStats(this.sessionTable);
                stats.addStatsListener(maxSessionStats);
            }
            SessionMonitor sessionMonitor = new SessionMonitor(this, this.sessionTable);
            sessionMonitor.start();
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.SessionService():", exception);
        }
    }

    private void postInit() {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(amSessionService, this.getSessionServiceToken());
            SessionConfigListener sessionConfigListener = new SessionConfigListener(serviceSchemaManager);
            serviceSchemaManager.addListener((ServiceListener)sessionConfigListener);
            sessionConfigListener.schemaChanged(amSessionService, null);
        }
        catch (Exception exception) {
            sessionDebug.error("SessionService.postInit():+Unable to get Session Schema Information", exception);
        }
    }

    private AMUser getUser(Session session) throws SessionException, SSOException, AMException {
        Object var2_2 = null;
        SSOToken sSOToken = this.getSSOTokenManager().createSSOToken(session.getID().toString());
        AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
        return aMStoreConnection.getUser(session.getClientID());
    }

    private boolean hasTopLevelAdminRole(Session session) throws SessionException, SSOException, AMException {
        SSOToken sSOToken = this.getSSOTokenManager().createSSOToken(session.getID().toString());
        AMStoreConnection aMStoreConnection = new AMStoreConnection(sSOToken);
        AMUser aMUser = aMStoreConnection.getUser(session.getClientID());
        AMRole aMRole = null;
        Set set = aMUser.getRoleDNs();
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                aMRole = aMStoreConnection.getRole((String)iterator.next());
                if (aMRole.getRoleType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InternalSession createSession(String string) {
        InternalSession internalSession;
        DataInputStream dataInputStream = null;
        try {
            try {
                String string2 = "?op=create";
                if (string != null) {
                    string2 = string2 + "&domain=" + URLEncoder.encode(string);
                }
                URL uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string2);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL, null);
                dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                if (httpURLConnection.getResponseCode() != 200) {
                    InternalSession internalSession2 = null;
                    Object var9_9 = null;
                    this.closeStream(dataInputStream);
                    return internalSession2;
                }
                SessionID sessionID = new SessionID(dataInputStream.readUTF());
                internalSession = (InternalSession)this.sessionTable.get(sessionID);
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to retrieve new session", exception);
                Object var9_11 = null;
                this.closeStream(dataInputStream);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.closeStream(dataInputStream);
            throw throwable;
        }
        Object var9_10 = null;
        this.closeStream(dataInputStream);
        return internalSession;
    }

    private void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                sessionDebug.error("Unable to close input", iOException);
            }
        }
    }

    private boolean releaseSession(URL uRL, SessionID sessionID) {
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Attempting to release InternalSession " + sessionID + " from server instance: " + uRL);
        }
        DataInputStream dataInputStream = null;
        URL uRL2 = null;
        try {
            try {
                String string = "?op=release";
                uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), deploymentURI + "/GetHttpSession" + string);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL2, sessionID);
                dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                boolean bl = httpURLConnection.getResponseCode() == 200;
                Object var9_11 = null;
                this.closeStream(dataInputStream);
                return bl;
            }
            catch (ConnectException connectException) {
                if (sessionDebug.messageEnabled()) {
                    sessionDebug.message("releaseSession: failed to connect to  " + uRL2);
                }
                boolean bl = true;
                Object var9_12 = null;
                this.closeStream(dataInputStream);
                return bl;
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to release session", exception);
                Object var9_13 = null;
                this.closeStream(dataInputStream);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.closeStream(dataInputStream);
            throw throwable;
        }
        return false;
    }

    int handleReleaseSession(SessionID sessionID) {
        if (!isSessionFailoverEnabled) {
            return 501;
        }
        InternalSession internalSession = (InternalSession)this.sessionTable.remove(sessionID);
        this.removeSessionHandle(internalSession);
        if (internalSession == null && sessionDebug.messageEnabled()) {
            sessionDebug.message("releaseSession: session not found  " + sessionID);
        }
        return 200;
    }

    private InternalSession recoverSession(SessionID sessionID) {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        if (sessionDebug.messageEnabled()) {
            sessionDebug.message("Recovering InternalSession from HttpSession: " + sessionID);
        }
        DataInputStream dataInputStream = null;
        try {
            try {
                String string = "?op=recover";
                URL uRL = new URL(this.thisSessionServerProtocol, this.thisSessionServer, this.thisSessionServerPort, deploymentURI + "/GetHttpSession" + string);
                HttpURLConnection httpURLConnection = this.invokeRemote(uRL, sessionID);
                dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            }
            catch (Exception exception) {
                sessionDebug.error("Failed to retrieve new session", exception);
                Object var7_8 = null;
                this.closeStream(dataInputStream);
            }
            Object var7_7 = null;
            this.closeStream(dataInputStream);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeStream(dataInputStream);
            throw throwable;
        }
        return (InternalSession)this.sessionTable.get(sessionID);
    }

    InternalSession retrieveSession(SessionID sessionID, HttpSession httpSession) {
        if (isSessionFailoverEnabled && httpSession != null) {
            String string = (String)httpSession.getAttribute(httpSessionPropertyName);
            if (string == null) {
                sessionDebug.message("GISFHS-No InternalSession in HttpSession");
                return null;
            }
            InternalSession internalSession = SessionService.decrypt(string);
            if (internalSession != null && internalSession.getID().equals(sessionID)) {
                URL uRL = (URL)httpSession.getAttribute(httpSessionOwnerPropertyName);
                if (!this.isLocalSessionService(uRL)) {
                    if (this.releaseSession(uRL, sessionID)) {
                        httpSession.setAttribute(httpSessionOwnerPropertyName, (Object)this.thisSessionServiceURL);
                    } else {
                        return null;
                    }
                }
                internalSession.setHttpSession(httpSession);
                this.sessionTable.put(internalSession.getID(), internalSession);
                String string2 = internalSession.getSessionHandle();
                if (string2 != null) {
                    this.sessionHandleTable.put(string2, internalSession);
                }
                return internalSession;
            }
        }
        return null;
    }

    public void saveForFailover(InternalSession internalSession) {
        if (!isSessionFailoverEnabled) {
            return;
        }
        HttpSession httpSession = internalSession.getHttpSession();
        if (httpSession != null) {
            httpSession.setAttribute(httpSessionOwnerPropertyName, (Object)this.thisSessionServiceURL);
            httpSession.setAttribute(httpSessionPropertyName, (Object)SessionService.encrypt(internalSession));
        }
    }

    private HttpURLConnection invokeRemote(URL uRL, SessionID sessionID) throws Exception {
        if (!isSessionFailoverEnabled) {
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            String string = (String)AccessController.doPrivileged(new EncodeAction(this.thisSessionServerURL + "@" + System.currentTimeMillis()));
            String string2 = "DSAMESecurityCookie=" + string;
            if (sessionID != null) {
                string2 = string2 + ";" + Session.getCookieName() + "=" + sessionID;
                String string3 = sessionID.getHttpId();
                if (string3 != null) {
                    string2 = string2 + ";" + httpSessionTrackingCookieName + "=" + string3;
                }
            }
            httpURLConnection.setRequestProperty("Cookie", string2);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
        }
        catch (Exception exception) {
            sessionDebug.message("Failed contacting " + uRL, exception);
            throw exception;
        }
        return httpURLConnection;
    }

    public static String encrypt(Object object) {
        String string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            String string2 = Base64.encode(byteArrayOutputStream.toByteArray());
            string = (String)AccessController.doPrivileged(new EncodeAction(string2, Crypt.getHardcodedKeyEncryptor()));
        }
        catch (Exception exception) {
            sessionDebug.message("Error in encrypting the Internal Session object");
            return null;
        }
        return string;
    }

    public static InternalSession decrypt(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        Object object = null;
        try {
            String string2 = (String)AccessController.doPrivileged(new DecodeAction(string, Crypt.getHardcodedKeyEncryptor()));
            byArray = Base64.decode(string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            sessionDebug.message("Error in decrypting the Internal Session object" + exception.getMessage());
            return null;
        }
        if (object == null) {
            return null;
        }
        return (InternalSession)object;
    }

    public static String encodeID(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '%') {
                ++n;
            }
            ++n2;
        }
        int n3 = cArray.length + n * 2;
        char[] cArray2 = new char[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < cArray.length) {
            switch (cArray[n4]) {
                case '%': {
                    cArray2[n5] = 37;
                    cArray2[n5 + 1] = 50;
                    cArray2[n5 + 2] = 53;
                    n5 += 3;
                    break;
                }
                default: {
                    cArray2[n5] = cArray[n4];
                    ++n5;
                }
            }
            ++n4;
        }
        return String.valueOf(cArray2);
    }

    protected static void debugIS(String string, Object object) {
        block6: {
            InternalSession internalSession = null;
            if (object == null) {
                sessionDebug.message("InternalSession Attribute is NULL in -->" + string);
                return;
            }
            internalSession = (InternalSession)object;
            if (internalSession != null) {
                try {
                    sessionDebug.message(string + " --Value of sessionID-->" + internalSession.getID());
                    sessionDebug.message(string + " --Value of clientDomain-->" + internalSession.getClientDomain());
                    sessionDebug.message(string + " --Value of maxSessionTime-->" + internalSession.getMaxSessionTime());
                    sessionDebug.message(string + " --Value of sessionState-->" + internalSession.getState());
                    sessionDebug.message(string + " --Value of idleTime-->" + internalSession.getIdleTime());
                    if (internalSession.getProperty("Name") != null) {
                        sessionDebug.message(string + " --Value of property Name is -->" + internalSession.getProperty("Name"));
                        break block6;
                    }
                    sessionDebug.message(string + "  --Value of property Name is NULL");
                }
                catch (Exception exception) {
                    sessionDebug.message("ERROR in debugIS" + exception.getMessage());
                }
            } else {
                sessionDebug.message("InternalSession is NULL in -->" + string);
            }
        }
    }

    public static boolean matchFilter(String string, String string2) {
        if (string2.equals("*") || string2.equals(string)) {
            return true;
        }
        int n = string2.length();
        int n2 = string2.indexOf("*");
        if (n2 >= 0) {
            String string3 = string2.substring(0, n2);
            if (!string.startsWith(string3, 0)) {
                return false;
            }
            int n3 = string3.length() + 1;
            int n4 = 0;
            if (n2 > 0) {
                n4 = n3;
            }
            String string4 = string2.substring(n3, n);
            while ((n2 = string2.indexOf("*", n3)) != -1) {
                string3 = string2.substring(n3, n2);
                if (string.indexOf(string3, n4) == -1) {
                    return false;
                }
                n3 = n2 + 1;
                n4 = n4 + string3.length() + 1;
                string4 = string2.substring(n3, n);
            }
            if (string.endsWith(string4)) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n;
        int n2;
        threadPool = null;
        ssoManager = null;
        sessionDebug = null;
        maxSessions = 10000;
        numberOfActiveSessions = 0;
        dsameAdminDN = null;
        logger = null;
        logStatus = false;
        isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));
        webContainer = SystemProperties.get("com.sun.identity.webcontainer");
        isWeblogicFlag = false;
        defaultApplicationMaxCachingTime = String.valueOf(0x222222222222222L);
        applicationMaxCachingTime = Long.valueOf(SystemProperties.get("com.sun.identity.session.application.maxCacheTime", defaultApplicationMaxCachingTime));
        sessionServiceToken = null;
        sessionDebug = Debug.getInstance("amSession");
        stats = Stats.getInstance("amSSO");
        try {
            n2 = Integer.parseInt(SystemProperties.get("com.iplanet.am.notification.threadpool.size"));
        }
        catch (Exception exception) {
            n2 = 10;
        }
        try {
            n = Integer.parseInt(SystemProperties.get("com.iplanet.am.notification.threadpool.threshold"));
        }
        catch (Exception exception) {
            n = 100;
        }
        threadPool = new ThreadPool("amSession", n2, n, true, sessionDebug);
        try {
            maxSessions = Integer.parseInt(SystemProperties.get("com.iplanet.am.session.maxSessions"));
        }
        catch (Exception exception) {
            maxSessions = 10000;
        }
        String string = null;
        string = SystemProperties.get("com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE")) {
            logStatus = true;
        }
        if (webContainer.startsWith("BEA")) {
            isWeblogicFlag = true;
        }
        volatileRef = null;
        sessionService = null;
        deploymentURI = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
        isSessionFailoverEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.enabled"));
    }

    class SessionNotificationSender
    implements Runnable {
        private SessionService sessionService;
        private InternalSession session;
        private int eventType;

        SessionNotificationSender(SessionService sessionService2, InternalSession internalSession, int n) {
            this.sessionService = sessionService2;
            this.session = internalSession;
            this.eventType = n;
        }

        public void run() {
            Vector vector = this.session.getSessionEventURLs();
            if (this.sessionService.sessionEventURLs.size() != 0 || vector.size() != 0) {
                Object object;
                Object object2;
                SessionNotification sessionNotification = new SessionNotification(this.session.toSessionInfo(), this.eventType, System.currentTimeMillis());
                Notification notification = new Notification(sessionNotification.toXMLString());
                NotificationSet notificationSet = new NotificationSet(SessionService.SESSION_SERVICE);
                notificationSet.addNotification(notification);
                Enumeration enumeration = this.sessionService.sessionEventURLs.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    try {
                        object = new URL((String)object2);
                        if (this.sessionService.isLocalSessionService((URL)object)) {
                            SessionNotificationHandler.handler.processNotification(sessionNotification);
                            continue;
                        }
                        PLLServer.send((URL)object, (NotificationSet)notificationSet);
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Global notification to " + (String)object2, exception);
                    }
                }
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (this.sessionService.sessionEventURLs.contains(object)) continue;
                    try {
                        URL uRL = new URL((String)object);
                        boolean bl = uRL.getQuery() != null ? !uRL.getQuery().equals("shortcircuit=false") : false;
                        if (this.sessionService.isLocalSessionService(uRL) && bl) {
                            SessionNotificationHandler.handler.processNotification(sessionNotification);
                            continue;
                        }
                        PLLServer.send((URL)uRL, (NotificationSet)notificationSet);
                    }
                    catch (Exception exception) {
                        sessionDebug.error("Individual notification to " + (String)object, exception);
                    }
                }
            }
        }
    }
}

