/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.CookieUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionRequestHandler
implements RequestHandler {
    private static final String sccsID = "@(#)SessionRequestHandler.java\t1.8  00/03/28 03/28/00  Sun Microsystems, Inc.";
    private SessionService sessionService = SessionService.getSessionService();
    private static Map sessionServiceURLTable = new HashMap();

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet("session");
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request, httpServletRequest, httpServletResponse);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = request.getContent();
        SessionRequest sessionRequest = SessionRequest.parseXML(string);
        SessionResponse sessionResponse = this.processSessionRequest(sessionRequest, httpServletRequest, httpServletResponse);
        return new Response(sessionResponse.toXMLString());
    }

    private SessionResponse processSessionRequest(SessionRequest sessionRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        SessionResponse sessionResponse = new SessionResponse(sessionRequest.getRequestID(), sessionRequest.getMethodID());
        SessionID sessionID = new SessionID(sessionRequest.getSessionID());
        Session session = null;
        try {
            String string;
            Serializable serializable;
            switch (sessionRequest.getMethodID()) {
                case 1: 
                case 2: 
                case 5: {
                    session = Session.getSession(sessionID);
                    break;
                }
                case 0: 
                case 3: 
                case 4: 
                case 6: {
                    if (this.sessionService.isLocalSession(sessionID)) break;
                    try {
                        serializable = SessionRequestHandler.getSessionServiceURL(sessionID);
                        string = CookieUtils.getCookieValueFromReq(httpServletRequest, Session.getCookieName());
                        boolean bl = false;
                        if (this.sessionService.isSessionFailoverEnabled()) {
                            if (string == null || !string.equals(sessionID.toString())) {
                                bl = true;
                            }
                        } else if (!this.sessionService.isLocalSessionService((URL)serializable)) {
                            bl = true;
                        }
                        if (bl) {
                            return this.forward((URL)serializable, Session.getCookieName() + "=" + sessionID, sessionRequest);
                        }
                        if (!this.sessionService.isSessionFailoverEnabled() || this.sessionService.getInternalSession(sessionID) == null) {
                            sessionResponse.setException(sessionID + " " + SessionBundle.getString("sessionNotObtained"));
                            return sessionResponse;
                        }
                        break;
                    }
                    catch (SessionException sessionException) {
                        sessionResponse.setException(sessionID + " " + sessionException.getMessage());
                        return sessionResponse;
                    }
                }
                default: {
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("unknownRequestMethod"));
                    return sessionResponse;
                }
            }
            switch (sessionRequest.getMethodID()) {
                case 0: {
                    serializable = this.sessionService.getSession(sessionID, sessionRequest.getResetFlag());
                    sessionResponse.addSessionInfo(((InternalSession)serializable).toSessionInfo());
                    break;
                }
                case 1: {
                    string = sessionRequest.getPattern();
                    Vector vector = null;
                    int[] nArray = new int[]{0};
                    vector = this.sessionService.getValidSessions(session, string, nArray);
                    sessionResponse.setStatus(nArray[0]);
                    sessionResponse.setSessionInfoVector(vector);
                    break;
                }
                case 2: {
                    this.sessionService.destroySession(session, new SessionID(sessionRequest.getDestroySessionID()));
                    break;
                }
                case 3: {
                    this.sessionService.logout(sessionID);
                    break;
                }
                case 4: {
                    this.sessionService.addSessionListener(sessionID, sessionRequest.getNotificationURL());
                    break;
                }
                case 5: {
                    this.sessionService.addSessionListenerOnAllSessions(session, sessionRequest.getNotificationURL());
                    break;
                }
                case 6: {
                    this.sessionService.setExternalProperty(sessionID, sessionRequest.getPropertyName(), sessionRequest.getPropertyValue());
                    break;
                }
                default: {
                    sessionResponse.setException(sessionID + " " + SessionBundle.getString("unknownRequestMethod"));
                    break;
                }
            }
        }
        catch (SessionException sessionException) {
            sessionResponse.setException(sessionID + " " + sessionException.getMessage());
        }
        return sessionResponse;
    }

    private static URL getSessionServiceURL(SessionID sessionID) throws SessionException {
        URL uRL = null;
        String string = sessionID.getSessionServerProtocol();
        String string2 = sessionID.getSessionServer();
        String string3 = sessionID.getSessionServerPort();
        String string4 = string + "://" + string2 + ":" + string3;
        if (sessionServiceURLTable.containsKey(string4)) {
            uRL = (URL)sessionServiceURLTable.get(string4);
        }
        if (uRL == null) {
            try {
                uRL = WebtopNaming.getServiceURL("Session", string, string2, string3);
                sessionServiceURLTable.put(string4, uRL);
                return uRL;
            }
            catch (URLNotFoundException uRLNotFoundException) {
                throw new SessionException(uRLNotFoundException);
            }
        }
        return uRL;
    }

    private SessionResponse forward(URL uRL, String string, SessionRequest sessionRequest) throws SessionException {
        try {
            Request request = new Request(sessionRequest.toXMLString());
            RequestSet requestSet = new RequestSet("session");
            requestSet.addRequest(request);
            Vector vector = PLLClient.send(uRL, string, requestSet);
            if (vector.size() != 1) {
                throw new SessionException(SessionBundle.rbName, "unexpectedResponse", null);
            }
            Response response = (Response)vector.elementAt(0);
            SessionResponse sessionResponse = SessionResponse.parseXML(response.getContent());
            if (sessionResponse.getException() != null) {
                throw new SessionException(sessionResponse.getException());
            }
            return sessionResponse;
        }
        catch (Exception exception) {
            throw new SessionException(exception);
        }
    }
}

