/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.dpro.session.share.SessionInfo;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class InternalSession
implements Serializable {
    private static final String sccsID = "@(#)InternalSession.java      1.14  01/04/20 04/20/01  Sun Microsystems, Inc.";
    private SessionID sessionID;
    private int sessionType;
    private String clientID;
    private String clientDomain;
    private long maxSessionTime;
    private long maxIdleTime;
    private long maxCachingTime;
    private int sessionState;
    private Properties sessionProperties;
    private boolean willExpireFlag;
    private boolean isEncoded = false;
    private long creationTime;
    private long latestAccessTime;
    private transient HttpSession httpSession;
    private boolean isISStored = false;
    Boolean cookieMode = null;
    private String cookieStr;
    private static boolean isSessionFailoverEnabled = Boolean.valueOf(SystemProperties.get("com.iplanet.am.session.failover.enabled"));
    private static String superUserDN;
    private static boolean isEnableHostLookUp;
    private long timedOutAt = 0L;
    private static long purgeDelay;
    private String sessionHandle = null;
    private static final String LOGIN_URL = "loginURL";
    private static final String SESSION_TIMED_OUT = "SessionTimedOut";
    private static final String HOST = "Host";
    private static final String HOST_NAME = "HostName";
    private static long maxDefaultIdleTime;
    protected static Set protectedProperties;
    protected static Set remotelyUpdateableProperties;
    private Vector sessionEventURLs = new Vector();
    static /* synthetic */ Class class$com$iplanet$dpro$session$service$InternalSession;

    private static long getPropValue(String string, long l) {
        String string2 = SystemProperties.get(string, String.valueOf(l));
        long l2 = 0L;
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    InternalSession(SessionID sessionID) {
        this.sessionID = sessionID;
        this.sessionState = 0;
        this.setCreationTime();
        this.setLatestAccessTime();
        this.sessionProperties = new Properties();
        this.willExpireFlag = true;
    }

    public SessionID getID() {
        return this.sessionID;
    }

    public int getType() {
        return this.sessionType;
    }

    public void setType(int n) {
        this.sessionType = n;
        this.updateForFailover();
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String string) {
        this.clientID = string;
        this.updateForFailover();
    }

    public String getClientDomain() {
        return this.clientDomain;
    }

    public void setClientDomain(String string) {
        this.clientDomain = string;
        this.updateForFailover();
    }

    public long getMaxSessionTime() {
        return this.maxSessionTime;
    }

    public void setMaxSessionTime(long l) {
        this.maxSessionTime = l;
        this.updateForFailover();
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(long l) {
        int n;
        this.maxIdleTime = l;
        if (this.httpSession != null && this.maxIdleTime > (long)(n = this.httpSession.getMaxInactiveInterval())) {
            this.httpSession.setMaxInactiveInterval((int)this.maxIdleTime * 60);
        }
        this.updateForFailover();
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    public void setMaxCachingTime(long l) {
        this.maxCachingTime = l;
        this.updateForFailover();
    }

    public long getIdleTime() {
        long l = System.currentTimeMillis() / 1000L;
        return l - this.latestAccessTime;
    }

    public long getTimeLeft() {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.creationTime + this.maxSessionTime * 60L - l;
        if (l2 >= 0L) {
            return l2;
        }
        return 0L;
    }

    public long getTimeLeftBeforePurge() {
        if (!this.isTimedOut()) {
            return -1L;
        }
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.timedOutAt + purgeDelay * 60L - l;
        return l2 > 0L ? l2 : 0L;
    }

    public boolean isTimedOut() {
        return this.timedOutAt != 0L;
    }

    public int getState() {
        return this.sessionState;
    }

    public String getProperty(String string) {
        return this.sessionProperties.getProperty(string);
    }

    protected void registerProtectedProperty(String string) {
        if (!protectedProperties.contains(string)) {
            if (remotelyUpdateableProperties.contains(string)) {
                return;
            }
            SessionService.getSessionService().logIt(this, "New protected property detected [" + string + "]");
            Class clazz = class$com$iplanet$dpro$session$service$InternalSession == null ? (class$com$iplanet$dpro$session$service$InternalSession = InternalSession.class$("com.iplanet.dpro.session.service.InternalSession")) : class$com$iplanet$dpro$session$service$InternalSession;
            synchronized (clazz) {
                HashSet<String> hashSet = new HashSet<String>(protectedProperties);
                hashSet.add(string);
                protectedProperties = hashSet;
            }
        }
    }

    void putExternalProperty(String string, String string2) {
        if (protectedProperties.contains(string)) {
            SessionService.getSessionService().logIt(this, "Attempt to set protected property [" + string + "=" + string2 + "]");
            return;
        }
        this.internalPutProperty(string, string2);
    }

    public void putProperty(String string, String string2) {
        this.registerProtectedProperty(string);
        this.internalPutProperty(string, string2);
    }

    protected void internalPutProperty(String string, String string2) {
        if (string.equals(HOST_NAME) || string.equals(HOST)) {
            if (string2 == null || string2.equals("")) {
                return;
            }
            if (isEnableHostLookUp) {
                try {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    String string3 = inetAddress.getHostName();
                    ((Hashtable)this.sessionProperties).put(HOST_NAME, string3);
                    ((Hashtable)this.sessionProperties).put(HOST, string2);
                }
                catch (UnknownHostException unknownHostException) {
                    SessionService.sessionDebug.error("InternalSession.internalputProperty():Unable to get HostName for:" + string2 + " SessionException: ", unknownHostException);
                }
            } else {
                ((Hashtable)this.sessionProperties).put(HOST_NAME, string2);
                ((Hashtable)this.sessionProperties).put(HOST, string2);
            }
        } else {
            ((Hashtable)this.sessionProperties).put(string, string2);
        }
        this.updateForFailover();
    }

    public void setIsISStored(boolean bl) {
        boolean bl2 = this.isISStored;
        this.isISStored = bl;
        if (this.isISStored && !bl2) {
            this.updateForFailover();
        }
    }

    public boolean getIsISstored() {
        return this.isISStored;
    }

    public boolean activate(String string) {
        if (string == null) {
            return false;
        }
        if (SessionService.getActiveSessions() >= SessionService.maxSessions && !string.equalsIgnoreCase(superUserDN)) {
            return false;
        }
        this.setLatestAccessTime();
        this.setState(1);
        SessionService.getSessionService().logEvent(this, 0);
        SessionService.getSessionService().sendEvent(this, 0);
        SessionService.incrementActiveSessions();
        return true;
    }

    public void reactivate() {
        this.setCreationTime();
        this.setLatestAccessTime();
        this.setState(1);
        SessionService.getSessionService().logEvent(this, 4);
        SessionService.getSessionService().sendEvent(this, 4);
    }

    public void setExpire(boolean bl) {
        if (!bl) {
            this.maxSessionTime = 0x222222222222222L;
            this.maxIdleTime = 0x222222222222222L;
            this.maxCachingTime = SessionService.applicationMaxCachingTime;
        }
        this.willExpireFlag = bl;
    }

    private boolean checkInvalidSessionDefaultIdleTime() {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = this.creationTime + maxDefaultIdleTime * 60L - l;
        return l2 < 0L;
    }

    boolean shouldDestroy() {
        if (!this.willExpireFlag) {
            return false;
        }
        if (!this.isTimedOut()) {
            if (this.sessionState == 0) {
                if (this.checkInvalidSessionDefaultIdleTime()) {
                    SessionService.getSessionService().logEvent(this, 5);
                    this.setState(3);
                    SessionService.getSessionService().sendEvent(this, 5);
                    return true;
                }
                return false;
            }
            if (this.getTimeLeft() == 0L) {
                this.changeStateAndNotify(2);
                return false;
            }
            if (this.getIdleTime() >= this.maxIdleTime * 60L && this.sessionState != 2) {
                this.changeStateAndNotify(1);
                return false;
            }
            return false;
        }
        if (this.getTimeLeftBeforePurge() <= 0L) {
            SessionService.getSessionService().logEvent(this, 5);
            this.setState(3);
            SessionService.getSessionService().sendEvent(this, 5);
            return true;
        }
        return false;
    }

    private void changeStateAndNotify(int n) {
        SessionService.decrementActiveSessions();
        SessionService.getSessionService().logEvent(this, n);
        this.setState(0);
        this.timedOutAt = System.currentTimeMillis() / 1000L;
        this.putProperty(SESSION_TIMED_OUT, String.valueOf(this.timedOutAt));
        this.trimSession();
        SessionService.getSessionService().sendEvent(this, n);
    }

    public SessionInfo toSessionInfo() {
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.sid = this.sessionID.toString();
        if (this.sessionType == 0) {
            sessionInfo.stype = "user";
        } else if (this.sessionType == 1) {
            sessionInfo.stype = "application";
        }
        sessionInfo.cid = this.clientID;
        sessionInfo.cdomain = this.clientDomain;
        sessionInfo.maxtime = Long.toString(this.maxSessionTime);
        sessionInfo.maxidle = Long.toString(this.maxIdleTime);
        sessionInfo.maxcaching = Long.toString(this.maxCachingTime);
        if (this.willExpireFlag) {
            sessionInfo.timeidle = Long.toString(this.getIdleTime());
            sessionInfo.timeleft = Long.toString(this.getTimeLeft());
        } else {
            sessionInfo.timeidle = Long.toString(0L);
            sessionInfo.timeleft = Long.toString(0x222222222222222L);
        }
        if (this.sessionState == 0) {
            sessionInfo.state = "invalid";
        } else if (this.sessionState == 1) {
            sessionInfo.state = "valid";
        } else if (this.sessionState == 2) {
            sessionInfo.state = "inactive";
        } else if (this.sessionState == 3) {
            sessionInfo.state = "destroyed";
        }
        sessionInfo.properties = this.sessionProperties;
        return sessionInfo;
    }

    void setLatestAccessTime() {
        this.latestAccessTime = System.currentTimeMillis() / 1000L;
        this.updateForFailover();
    }

    void setState(int n) {
        this.sessionState = n;
        this.updateForFailover();
    }

    Vector getSessionEventURLs() {
        return this.sessionEventURLs;
    }

    boolean willExpire() {
        return this.willExpireFlag;
    }

    public void setCreationTime() {
        this.creationTime = this.httpSession != null ? this.httpSession.getCreationTime() / 1000L : System.currentTimeMillis() / 1000L;
    }

    public String encodeURL(HttpServletResponse httpServletResponse, String string) {
        return this.encodeURL(string, (short)0, true);
    }

    private String encodeURL(String string, boolean bl) {
        return this.encodeURL(string, (short)0, bl);
    }

    public String encodeURL(String string, short s, boolean bl) {
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Session: url: " + string);
        }
        String string2 = string;
        if (string != null && string.length() > 0 && !this.getCookieSupport()) {
            if (this.cookieStr != null) {
                string2 = SessionEncodeURL.buildCookieString(string, this.cookieStr, s, bl);
            } else if (this.sessionID != null) {
                this.cookieStr = SessionEncodeURL.createCookieString(this.sessionID.toString());
                string2 = SessionEncodeURL.encodeURL(this.cookieStr, string, s, bl);
            }
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("Returning encoded Session: url: " + string2);
        }
        return string2;
    }

    private String getClientType() {
        String string = null;
        string = this.getProperty("clientType");
        return string;
    }

    private boolean getCookieSupport() {
        boolean bl = false;
        try {
            if (this.sessionID.getCookieMode() != null) {
                bl = this.sessionID.getCookieMode();
            } else if (this.cookieMode != null) {
                bl = this.cookieMode;
            }
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("Error getting cookieSupport value: ", exception);
            bl = true;
        }
        if (SessionService.sessionDebug.messageEnabled()) {
            SessionService.sessionDebug.message("InternalSession: getCookieSupport: " + bl);
        }
        return bl;
    }

    void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    HttpSession getHttpSession() {
        return this.httpSession;
    }

    protected void updateForFailover() {
        if (isSessionFailoverEnabled && this.isISStored) {
            SessionService.getSessionService().saveForFailover(this);
        }
    }

    private void trimSession() {
        this.clientDomain = null;
        this.cookieStr = null;
        Properties properties = new Properties();
        String string = this.getProperty(LOGIN_URL);
        String string2 = this.getProperty(SESSION_TIMED_OUT);
        if (string != null) {
            ((Hashtable)properties).put(LOGIN_URL, string);
        }
        if (string2 != null) {
            ((Hashtable)properties).put(SESSION_TIMED_OUT, string2);
        }
        this.sessionProperties = properties;
    }

    public void setCookieMode(Boolean bl) {
        SessionService.sessionDebug.message("CookieMode is:" + bl);
        if (bl != null) {
            this.cookieMode = bl;
        }
    }

    void setSessionHandle(String string) {
        this.sessionHandle = string;
        this.putProperty("SessionHandle", string);
        this.updateForFailover();
    }

    String getSessionHandle() {
        return this.sessionHandle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isEnableHostLookUp = Boolean.valueOf(SystemProperties.get("com.sun.am.session.enableHostLookUp"));
        maxDefaultIdleTime = InternalSession.getPropValue("com.iplanet.am.session.invalidsessionmaxtime", 3L);
        purgeDelay = InternalSession.getPropValue("com.iplanet.am.session.purgedelay", 120L);
        superUserDN = SystemProperties.get("com.sun.identity.authentication.super.user");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(HOST);
        hashSet.add(HOST_NAME);
        hashSet.add("AuthLevel");
        hashSet.add("AuthType");
        hashSet.add("Principal");
        hashSet.add("UserId");
        hashSet.add("UserToken");
        hashSet.add("Organization");
        hashSet.add("cookieSupport");
        hashSet.add("authInstant");
        hashSet.add("Principals");
        hashSet.add(LOGIN_URL);
        hashSet.add("Role");
        hashSet.add("Service");
        hashSet.add(SESSION_TIMED_OUT);
        hashSet.add("SessionHandle");
        protectedProperties = hashSet;
        hashSet = new HashSet();
        hashSet.add("clientType");
        hashSet.add("Locale");
        hashSet.add("CharSet");
        String string = SystemProperties.get("com.iplanet.am.session.remotelyUpdateableProperties", "");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                hashSet.add(string2);
                if (!SessionService.sessionDebug.messageEnabled()) continue;
                SessionService.sessionDebug.message("Added remotely updateable property [" + string2 + "]");
            }
        }
        remotelyUpdateableProperties = hashSet;
    }
}

