/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.CookieUtils;
import com.sun.identity.security.DecodeAction;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class GetHttpSession
extends HttpServlet {
    public static final String OP = "op";
    public static final String NO_OP = "";
    public static final String CREATE_OP = "create";
    public static final String RECOVER_OP = "recover";
    public static final String RELEASE_OP = "release";
    public static final String DOMAIN = "domain";
    private static final long MAX_TIMESTAMP_DIFF = 600000L;

    private boolean validateRequest(HttpServletRequest httpServletRequest) {
        try {
            String string = CookieUtils.getCookieValueFromReq(httpServletRequest, "DSAMESecurityCookie");
            if (string == null) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: no Security Cookie in the request");
                return false;
            }
            String string2 = (String)AccessController.doPrivileged(new DecodeAction(string));
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
            String string3 = stringTokenizer.nextToken();
            long l = Long.parseLong(stringTokenizer.nextToken());
            long l2 = System.currentTimeMillis();
            if (Math.abs(l2 - l) > 600000L) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: Max time elapsed for the Request");
                return false;
            }
            Vector vector = WebtopNaming.getPlatformServerList();
            if (!vector.contains(string3)) {
                SessionService.sessionDebug.error("GetHttpSession.validateRequest: request host :" + string3 + "was not part of the platformServerList");
            }
            return true;
        }
        catch (Exception exception) {
            SessionService.sessionDebug.error("GetHttpSession.validateRequest: Exception while validating the request ", exception);
            return false;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (!this.validateRequest(httpServletRequest)) {
            httpServletResponse.setStatus(403);
            return;
        }
        String string = httpServletRequest.getParameter(OP);
        if (string.equals(RECOVER_OP)) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                SessionID sessionID;
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.recover: Old HttpSession is obtained");
                }
                if ((sessionID = new SessionID(httpServletRequest)).toString() != null) {
                    SessionService.getSessionService().retrieveSession(sessionID, httpSession);
                }
            } else {
                SessionService.sessionDebug.error("GetHttpSession.recover: Old  HttpSession is not obtained");
            }
        } else if (string.equals(CREATE_OP)) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            String string2 = httpServletRequest.getParameter(DOMAIN);
            InternalSession internalSession = SessionService.getSessionService().newInternalSession(string2, httpSession);
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.create: Created new session=" + internalSession.getID());
            }
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)httpServletResponse.getOutputStream());
            dataOutputStream.writeUTF(internalSession.getID().toString());
            dataOutputStream.flush();
            dataOutputStream.close();
        } else if (string.equals(RELEASE_OP)) {
            SessionID sessionID = new SessionID(httpServletRequest);
            if (sessionID.toString() != null) {
                if (SessionService.sessionDebug.messageEnabled()) {
                    SessionService.sessionDebug.message("GetHttpSession.release: releasing session=" + sessionID);
                }
                int n = SessionService.getSessionService().handleReleaseSession(sessionID);
                httpServletResponse.setStatus(n);
            } else if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("GetHttpSession.release: missing session id");
            }
        } else {
            SessionService.sessionDebug.error("GetHttpSession: unknown operation requested");
            httpServletResponse.setStatus(501);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }
}

