/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionEvent;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.SessionListener;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionRequest;
import com.iplanet.dpro.session.share.SessionResponse;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SessionPoller
extends Thread {
    Hashtable sessionTable;
    Hashtable destroyedTable;
    private boolean isSessionServiceLocal = false;
    private SessionService sessionService = null;
    public static Debug debug;
    URL url;
    static long period;

    public SessionPoller(Hashtable hashtable, Hashtable hashtable2, URL uRL, boolean bl) {
        this.sessionTable = hashtable;
        this.url = uRL;
        this.isSessionServiceLocal = bl;
        this.destroyedTable = hashtable2;
    }

    public void run() {
        Enumeration enumeration = this.sessionTable.elements();
        while (true) {
            long l = System.currentTimeMillis() + period;
            while (enumeration.hasMoreElements()) {
                SessionInfo sessionInfo;
                SessionID sessionID;
                Session session;
                block17: {
                    Object object;
                    session = (Session)enumeration.nextElement();
                    sessionID = session.getID();
                    sessionInfo = null;
                    try {
                        if (session.getTimeLeftBeforePurge() != 0L) {
                            continue;
                        }
                    }
                    catch (SessionException sessionException) {
                        debug.error("session is not in timeout state so clean it", sessionException);
                    }
                    if (this.isSessionServiceLocal) {
                        object = null;
                        try {
                            this.sessionService = SessionService.getSessionService();
                            object = this.sessionService.getSession(sessionID, false);
                        }
                        catch (SessionException sessionException) {
                            this.removeSID(sessionID);
                            if (!debug.messageEnabled()) continue;
                            debug.message("Removed SID:" + sessionID);
                            continue;
                        }
                        sessionInfo = ((InternalSession)object).toSessionInfo();
                    } else {
                        try {
                            object = new SessionRequest(0, sessionID.toString(), false);
                            Request request = new Request(((SessionRequest)object).toXMLString());
                            RequestSet requestSet = new RequestSet("session");
                            requestSet.addRequest(request);
                            String string = Session.getCookieName() + "=" + sessionID;
                            Vector vector = PLLClient.send(this.url, string, requestSet);
                            if (vector.size() != 1) {
                                this.removeSID(sessionID);
                                if (!debug.messageEnabled()) continue;
                                debug.message("Could not get session information from the server");
                                continue;
                            }
                            Response response = (Response)vector.elementAt(0);
                            SessionResponse sessionResponse = SessionResponse.parseXML(response.getContent());
                            if (sessionResponse.getException() != null) {
                                this.removeSID(sessionID);
                                continue;
                            }
                            Vector vector2 = sessionResponse.getSessionInfoVector();
                            sessionInfo = (SessionInfo)vector2.elementAt(0);
                        }
                        catch (Exception exception) {
                            if (!debug.messageEnabled()) break block17;
                            debug.message("Could not connect to the session server" + exception.getMessage());
                        }
                    }
                }
                if (sessionInfo != null) {
                    if (debug.messageEnabled()) {
                        debug.message("Updating" + sessionInfo.toXMLString());
                    }
                    session.update(sessionInfo);
                    continue;
                }
                this.removeSID(sessionID);
            }
            enumeration = this.sessionTable.elements();
            try {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) continue;
                Thread.sleep(l2);
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void removeSID(SessionID sessionID) {
        Session session = null;
        session = (Session)this.sessionTable.remove(sessionID);
        this.destroyedTable.remove(sessionID);
        if (session != null) {
            long l = System.currentTimeMillis();
            SessionEvent sessionEvent = new SessionEvent(session, 5, l);
            this.invokeListeners(sessionEvent);
        }
    }

    private void invokeListeners(SessionEvent sessionEvent) {
        Session session = sessionEvent.getSession();
        Vector vector = session.getSessionEventListeners();
        Vector vector2 = Session.getAllSessionEventListeners();
        int n = 0;
        while (n < vector.size()) {
            SessionListener sessionListener = (SessionListener)vector.elementAt(n);
            sessionListener.sessionChanged(sessionEvent);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            SessionListener sessionListener = (SessionListener)vector2.elementAt(n2);
            sessionListener.sessionChanged(sessionEvent);
            ++n2;
        }
    }

    static {
        block2: {
            debug = null;
            period = 180000L;
            debug = Debug.getInstance("amSession");
            String string = SystemProperties.get("com.iplanet.am.session.client.polling.period");
            try {
                period = Long.parseLong(string);
                period *= 1000L;
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Can not get the polling time");
            }
        }
    }
}

