/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.services.util.Crypt;
import com.sun.identity.security.DecodeAction;
import java.io.Serializable;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class SessionID
implements Serializable {
    private static final String sccsID = "$Id: SessionID.java,v 1.40 2003/08/26 23:46:31 bina Exp $ $Date: 2003/08/26 23:46:31 $  Sun Microsystems, Inc.";
    private String randomString = "";
    private String sessionServerProtocol = "";
    private boolean parseSid = true;
    private String sessionServer = "";
    private String sessionServerPort = "";
    private String sessionDomain = "";
    private int hashCode;
    private String encryptedString = "";
    private String sessionServerID = "";
    private String httpId = null;
    private static String cookieName = null;
    private static Debug debug;
    private Boolean cookieMode = null;

    public SessionID(HttpServletRequest httpServletRequest) {
        String string = null;
        if (cookieName != null) {
            string = CookieUtils.getCookieValueFromReq(httpServletRequest, cookieName);
            if (string == null) {
                String string2 = SessionEncodeURL.getSidFromURL(httpServletRequest);
                if (string2 != null) {
                    this.encryptedString = string2;
                }
                this.cookieMode = Boolean.FALSE;
            } else {
                this.cookieMode = Boolean.TRUE;
                this.encryptedString = string;
            }
        }
        this.hashCode = this.encryptedString.hashCode();
    }

    public SessionID(String string) {
        this.encryptedString = string;
        this.hashCode = this.encryptedString.hashCode();
    }

    public SessionID(String string, String string2, String string3, String string4, String string5, String string6) {
        this.encryptedString = string;
        this.hashCode = this.encryptedString.hashCode();
        int n = string.lastIndexOf("@");
        if (n != -1) {
            this.httpId = string.substring(n + 1);
            string = string.substring(0, n);
        }
        this.randomString = string2;
        this.sessionServerProtocol = string3;
        this.sessionServer = string4;
        this.sessionServerPort = string5;
        this.sessionDomain = string6;
        this.parseSid = false;
    }

    public String getRandomString() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.randomString;
    }

    public String getSessionServerProtocol() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.sessionServerProtocol;
    }

    public String getSessionServerPort() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.sessionServerPort;
    }

    public String getSessionServer() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.sessionServer;
    }

    public String getSessionDomain() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.sessionDomain;
    }

    public String getSessionServerID() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.sessionServerID;
    }

    public String toString() {
        return this.encryptedString;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SessionID sessionID = (SessionID)object;
        return this.encryptedString.equals(sessionID.encryptedString);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private void parseSessionString(String string) {
        String string2;
        this.parseSid = false;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("SessionID.parseSessionString :sid value is null or empty");
        }
        int n = string.lastIndexOf("@");
        if (n != -1) {
            this.httpId = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if ((string2 = (String)AccessController.doPrivileged(new DecodeAction(string, Crypt.getHardcodedKeyEncryptor()))) == null) {
            return;
        }
        int n2 = string2.indexOf(64);
        if (n2 == -1) {
            return;
        }
        if (n2 != 0) {
            this.randomString = string2.substring(0, n2);
        }
        if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf("@")) == -1) {
            this.parseServerID(string2);
        } else {
            if (n2 != 0) {
                this.sessionServerProtocol = string2.substring(0, n2);
            }
            if (n2 == string2.length() - 1) {
                return;
            }
            if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf(64)) == -1) {
                return;
            }
            if (n2 != 0) {
                this.sessionServer = string2.substring(0, n2);
            }
            if (n2 == string2.length() - 1) {
                return;
            }
            if ((n2 = (string2 = string2.substring(n2 + 1)).indexOf(64)) == -1) {
                return;
            }
            if (n2 != 0) {
                this.sessionServerPort = string2.substring(0, n2);
            }
            if (n2 == string2.length() - 1) {
                return;
            }
            this.sessionDomain = string2.substring(n2 + 1);
        }
    }

    private void parseServerID(String string) {
        String string2 = null;
        this.sessionServerID = string;
        try {
            string2 = WebtopNaming.getServerFromID(this.sessionServerID);
        }
        catch (Exception exception) {
            debug.error("Could not get server info from sessionid" + exception.toString());
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        this.sessionServerProtocol = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        this.sessionServer = string3.substring(2);
        this.sessionServerPort = stringTokenizer.nextToken();
    }

    public String getHttpId() {
        if (this.parseSid) {
            this.parseSessionString(this.encryptedString);
        }
        return this.httpId;
    }

    public Boolean getCookieMode() {
        return this.cookieMode;
    }

    static {
        cookieName = System.getProperty("com.iplanet.am.cookie.name");
        if (cookieName == null) {
            cookieName = SystemProperties.get("com.iplanet.am.cookie.name");
        }
        debug = Debug.getInstance("amSession");
    }
}

