/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.ValidationErrorHandler;
import com.iplanet.am.util.XMLHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private static DocumentBuilderFactory dbFactory = null;
    public static Debug debug;
    private static String ATTR_VALUE_PAIR_NODE;
    private static String VALUE_NODE;
    static /* synthetic */ Class class$com$iplanet$am$util$XMLUtils;

    public static Document toDOMDocument(String string, Debug debug) {
        try {
            Object object;
            XMLUtils.debug = debug;
            if (dbFactory == null) {
                object = class$com$iplanet$am$util$XMLUtils == null ? (class$com$iplanet$am$util$XMLUtils = XMLUtils.class$("com.iplanet.am.util.XMLUtils")) : class$com$iplanet$am$util$XMLUtils;
                synchronized (object) {
                    block19: {
                        if (dbFactory == null) {
                            try {
                                dbFactory = DocumentBuilderFactory.newInstance();
                                if (XMLUtils.debug != null && XMLUtils.debug.warningEnabled()) {
                                    dbFactory.setValidating(true);
                                } else {
                                    dbFactory.setValidating(false);
                                }
                                dbFactory.setNamespaceAware(true);
                            }
                            catch (Exception exception) {
                                if (XMLUtils.debug == null) break block19;
                                XMLUtils.debug.error("XMLUtils.DocumentBuilder init failed", exception);
                            }
                        }
                    }
                }
            }
            if (string == null) {
                return null;
            }
            object = null;
            DocumentBuilderFactory documentBuilderFactory = dbFactory;
            synchronized (documentBuilderFactory) {
                object = dbFactory.newDocumentBuilder();
            }
            if (object == null) {
                if (XMLUtils.debug != null) {
                    XMLUtils.debug.error("XMLUtils.toDOM : null builder instance");
                }
                return null;
            }
            ((DocumentBuilder)object).setEntityResolver(new XMLHandler());
            if (XMLUtils.debug != null && XMLUtils.debug.warningEnabled()) {
                ((DocumentBuilder)object).setErrorHandler(new ValidationErrorHandler());
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            return ((DocumentBuilder)object).parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            if (XMLUtils.debug != null && XMLUtils.debug.warningEnabled()) {
                XMLUtils.debug.warning("Can't parse the XML document:\n" + string, exception);
            }
            return null;
        }
    }

    public static Set parseAttributesTag(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1 || node2.getNodeName().equals("Attribute")) {
                String string = ((Element)node2).getAttribute("name");
                hashSet.add(string);
            }
            ++n2;
        }
        return hashSet;
    }

    public static Map parseAttributeValuePairTags(Node node) {
        NodeList nodeList = node.getChildNodes();
        HashMap hashMap = null;
        int n = nodeList.getLength();
        if (n <= 0) {
            return EMPTY_MAP;
        }
        int n2 = 0;
        while (n2 < n) {
            NodeList nodeList2;
            long l;
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1 && node2.getNodeName().equals("AttributeValuePair") && (l = (long)(nodeList2 = node2.getChildNodes()).getLength()) >= 2L) {
                Object object;
                String string = null;
                HashSet<String> hashSet = null;
                Node node3 = null;
                int n3 = 0;
                while ((long)n3 < l) {
                    node3 = nodeList2.item(n3);
                    if (node3.getNodeType() == 1 && node3.getNodeName().equals("Attribute")) {
                        n3 = (int)l;
                    }
                    ++n3;
                }
                string = ((Element)node3).getAttribute("name");
                int n4 = 0;
                while ((long)n4 < l) {
                    object = nodeList2.item(n4);
                    if (object.getNodeType() == 1 && object.getNodeName().equals("Value")) {
                        String string2;
                        Text text;
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                        }
                        if ((text = (Text)object.getFirstChild()) != null && (string2 = text.getNodeValue()) != null) {
                            hashSet.add(string2);
                        }
                    }
                    ++n4;
                }
                if (hashSet != null) {
                    if (hashMap == null) {
                        hashMap = new HashMap();
                    }
                    if ((object = (Set)hashMap.get(string)) != null) {
                        hashSet.addAll((Collection<String>)object);
                    }
                    hashMap.put(string, hashSet);
                    hashSet = null;
                }
            }
            ++n2;
        }
        if (hashMap == null) {
            return EMPTY_MAP;
        }
        return hashMap;
    }

    public static Document getXMLDocument(InputStream inputStream) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            String string = "\n" + sAXParseException.getMessage() + "\n";
            Object[] objectArray = new Object[]{new Integer(sAXParseException.getLineNumber())};
            throw new Exception(string + "XMLUtils.parser_error" + objectArray);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{new String(sAXException.getMessage())};
            throw new Exception("XMLUtils.exception_message" + objectArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{new String(parserConfigurationException.getMessage())};
            throw new Exception("XMLUtils.invalid_xml_document" + objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{new String(iOException.getMessage())};
            throw new Exception("XMLUtils.invalid_input_stream" + objectArray);
        }
    }

    public static Node getRootNode(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        return nodeList.item(0);
    }

    public static Node getChildNode(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static Node getNamedChildNode(Node node, String string, String string2, String string3) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (string.equalsIgnoreCase(node2.getNodeName()) && XMLUtils.getNodeAttributeValue(node2, string2).equalsIgnoreCase(string3)) {
                return node2;
            }
            ++n;
        }
        return null;
    }

    public static Set getChildNodes(Node node, String string) {
        HashSet<Node> hashSet = new HashSet<Node>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(string)) {
                hashSet.add(node2);
            }
            ++n;
        }
        return hashSet;
    }

    public static String getNodeAttributeValue(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static Set getAttributeValuePair(Node node) {
        if (!node.getNodeName().equals(ATTR_VALUE_PAIR_NODE)) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equalsIgnoreCase(VALUE_NODE)) {
                hashSet.add(XMLUtils.getValueOfValueNode(node2));
            }
            ++n;
        }
        return hashSet;
    }

    public static String getValueOfValueNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            stringBuffer.append(node2.getNodeValue());
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ATTR_VALUE_PAIR_NODE = "AttributeValuePair";
        VALUE_NODE = "Value";
    }
}

