/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.StatsListener;
import com.iplanet.am.util.StatsRunner;
import com.iplanet.am.util.SystemProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class Stats {
    public static final int OFF = 0;
    public static final int FILE = 1;
    public static final int CONSOLE = 2;
    private static Map statsMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static DateFormat dateFormat;
    private static String defaultStatsLevel;
    private static String outputDirectory;
    private final String statsName;
    private PrintWriter statsFile = null;
    private int statsState;
    private static Thread sr;
    public static Vector statsListeners;
    private static final String sccsID = "$Id: Stats.java,v 1.7 2003/07/13 04:01:27 vs125812 Exp $ Sun Microsystems, Inc.";
    static /* synthetic */ Class class$com$iplanet$am$util$Stats;

    private static void initService() {
        if (!serviceInitialized) {
            Class clazz = class$com$iplanet$am$util$Stats == null ? (class$com$iplanet$am$util$Stats = Stats.class$("com.iplanet.am.util.Stats")) : class$com$iplanet$am$util$Stats;
            synchronized (clazz) {
                if (!serviceInitialized) {
                    dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
                    try {
                        File file;
                        defaultStatsLevel = SystemProperties.get("com.iplanet.services.stats.state");
                        outputDirectory = SystemProperties.get("com.iplanet.services.stats.directory");
                        ResourceBundle resourceBundle = Locale.getInstallResourceBundle("amUtilMsgs");
                        if (outputDirectory != null && !(file = new File(outputDirectory)).exists() && !file.mkdirs()) {
                            System.err.println(resourceBundle.getString("com.iplanet.services.stats.nodir"));
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        System.err.println(missingResourceException.getMessage());
                        missingResourceException.printStackTrace();
                        defaultStatsLevel = "console";
                        outputDirectory = null;
                    }
                    catch (SecurityException securityException) {
                        System.err.println(securityException.getMessage());
                    }
                    if (sr == null) {
                        sr = new StatsRunner();
                        sr.start();
                    }
                    serviceInitialized = true;
                }
            }
        }
    }

    private Stats(String string) {
        Stats.initService();
        this.statsName = string;
        this.setStats(defaultStatsLevel);
        Map map = statsMap;
        synchronized (map) {
            statsMap.put(string, this);
        }
    }

    public static synchronized Stats getInstance(String string) {
        Stats stats = (Stats)statsMap.get(string);
        if (stats == null) {
            stats = new Stats(string);
        }
        return stats;
    }

    public boolean isEnabled() {
        return this.statsState > 0;
    }

    public int getState() {
        return this.statsState;
    }

    public void record(String string) {
        if (this.statsState > 0) {
            this.formatAndWrite(null, string);
        }
    }

    private void formatAndWrite(String string, String string2) {
        if (this.statsState == 2) {
            if (string2 != null) {
                if (string == null) {
                    System.out.println(string2);
                } else {
                    System.out.println(string + string2);
                }
            }
            return;
        }
        String string3 = System.getProperty("server.name");
        StringWriter stringWriter = new StringWriter(160);
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        DateFormat dateFormat = Stats.dateFormat;
        synchronized (dateFormat) {
            printWriter.write(Stats.dateFormat.format(new Date()));
        }
        if (string3 != null && string3 != "") {
            printWriter.write(": ");
            printWriter.write("Server Instance: " + string3);
        }
        printWriter.write(": ");
        printWriter.write(Thread.currentThread().toString());
        printWriter.write("\n");
        if (string != null) {
            printWriter.write(string);
        }
        if (string2 != null) {
            printWriter.write(string2);
        }
        printWriter.flush();
        this.write(stringWriter.toString());
    }

    private synchronized void write(String string) {
        try {
            if (this.statsFile == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(outputDirectory + File.separator + this.statsName, true);
                this.statsFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")), true);
                this.statsFile.println("******************************************************");
            }
            this.statsFile.println(string);
        }
        catch (IOException iOException) {
            System.err.println(string);
            this.statsState = 0;
        }
    }

    public void setStats(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.statsState = n;
                break;
            }
        }
    }

    public void setStats(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("console")) {
            this.statsState = 2;
        } else if (string.equalsIgnoreCase("file")) {
            this.statsState = 1;
        } else if (string.equalsIgnoreCase("off")) {
            this.statsState = 0;
        } else if (string.equals("*")) {
            this.statsState = 2;
        } else {
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (this.statsName.startsWith(string)) {
                this.statsState = 2;
            }
        }
    }

    public void destroy() {
        this.finalize();
    }

    protected void finalize() {
        Map map = statsMap;
        synchronized (map) {
            statsMap.remove(this.statsName);
        }
        Stats stats = this;
        synchronized (stats) {
            if (this.statsFile == null) {
                return;
            }
            this.statsState = 0;
            this.statsFile.flush();
            this.statsFile.close();
            this.statsFile = null;
        }
    }

    public void addStatsListener(StatsListener statsListener) {
        Vector vector = statsListeners;
        synchronized (vector) {
            statsListeners.addElement(statsListener);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sr = null;
        statsListeners = new Vector();
    }
}

