/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Debug {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int MESSAGE = 3;
    public static final int ON = 4;
    private static Map debugMap = new HashMap();
    private static boolean serviceInitialized = false;
    private static DateFormat dateFormat;
    private static String defaultDebugLevel;
    private static String outputDirectory;
    private final String debugName;
    private PrintWriter debugFile = null;
    private int debugLevel;
    private static final String sccsID = "$Id: Debug.java,v 1.10 2003/08/15 08:51:54 vs125812 Exp $ Sun Microsystems, Inc.";
    static /* synthetic */ Class class$com$iplanet$am$util$Debug;

    private static void initService() {
        if (!serviceInitialized) {
            Class clazz = class$com$iplanet$am$util$Debug == null ? (class$com$iplanet$am$util$Debug = Debug.class$("com.iplanet.am.util.Debug")) : class$com$iplanet$am$util$Debug;
            synchronized (clazz) {
                if (!serviceInitialized) {
                    dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
                    try {
                        File file;
                        defaultDebugLevel = SystemProperties.get("com.iplanet.services.debug.level");
                        outputDirectory = SystemProperties.get("com.iplanet.services.debug.directory");
                        ResourceBundle resourceBundle = Locale.getInstallResourceBundle("amUtilMsgs");
                        if (outputDirectory != null && !(file = new File(outputDirectory)).exists() && !file.mkdirs()) {
                            System.err.println(resourceBundle.getString("com.iplanet.services.debug.nodir"));
                        }
                    }
                    catch (MissingResourceException missingResourceException) {
                        System.err.println(missingResourceException.getMessage());
                        missingResourceException.printStackTrace();
                        defaultDebugLevel = "on";
                        outputDirectory = null;
                    }
                    catch (SecurityException securityException) {
                        System.err.println(securityException.getMessage());
                    }
                    serviceInitialized = true;
                }
            }
        }
    }

    private Debug(String string) {
        Debug.initService();
        this.debugName = string;
        this.setDebug(defaultDebugLevel);
        Map map = debugMap;
        synchronized (map) {
            debugMap.put(string, this);
        }
    }

    public static synchronized Debug getInstance(String string) {
        Debug debug = (Debug)debugMap.get(string);
        if (debug == null) {
            debug = new Debug(string);
        }
        return debug;
    }

    private boolean debugEnabled() {
        return this.debugLevel > 2;
    }

    public boolean messageEnabled() {
        return this.debugLevel > 2;
    }

    public boolean warningEnabled() {
        return this.debugLevel > 1;
    }

    public int getState() {
        return this.debugLevel;
    }

    public void message(String string) {
        if (this.debugLevel > 2) {
            this.message(string, null);
        }
    }

    public void message(String string, Throwable throwable) {
        if (this.debugLevel > 2) {
            this.formatAndWrite(null, string, throwable);
        }
    }

    public void warning(String string) {
        if (this.debugLevel > 1) {
            this.formatAndWrite("WARNING: ", string, null);
        }
    }

    public void warning(String string, Throwable throwable) {
        if (this.debugLevel > 1) {
            this.formatAndWrite("WARNING: ", string, throwable);
        }
    }

    public void error(String string) {
        if (this.debugLevel > 0) {
            this.formatAndWrite("ERROR: ", string, null);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.debugLevel > 0) {
            this.formatAndWrite("ERROR: ", string, throwable);
        }
    }

    private void formatAndWrite(String string, String string2, Throwable throwable) {
        if (this.debugLevel == 4) {
            if (string2 != null) {
                if (string == null) {
                    System.out.println(string2);
                } else {
                    System.out.println(string + string2);
                }
            }
            if (throwable != null) {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace(System.out);
            }
            return;
        }
        StringWriter stringWriter = new StringWriter(160);
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        DateFormat dateFormat = Debug.dateFormat;
        synchronized (dateFormat) {
            printWriter.write(Debug.dateFormat.format(new Date()));
        }
        printWriter.write(": ");
        printWriter.write(Thread.currentThread().toString());
        printWriter.write("\n");
        if (string != null) {
            printWriter.write(string);
        }
        if (string2 != null) {
            printWriter.write(string2);
        }
        if (throwable != null) {
            printWriter.write("\n");
            throwable.printStackTrace(printWriter);
        }
        printWriter.flush();
        this.write(stringWriter.toString());
    }

    private synchronized void write(String string) {
        try {
            if (this.debugFile == null) {
                FileOutputStream fileOutputStream = new FileOutputStream(outputDirectory + File.separator + this.debugName, true);
                this.debugFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")), true);
                this.debugFile.println("******************************************************");
            }
            this.debugFile.println(string);
        }
        catch (IOException iOException) {
            System.err.println(string);
            this.debugLevel = 0;
        }
    }

    public void setDebug(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.debugLevel = n;
                break;
            }
        }
    }

    private void setDebug() {
        Debug.initService();
        this.setDebug(defaultDebugLevel);
    }

    public void setDebug(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("error")) {
            this.debugLevel = 1;
        } else if (string.equalsIgnoreCase("warning")) {
            this.debugLevel = 2;
        } else if (string.equalsIgnoreCase("message")) {
            this.debugLevel = 3;
        } else if (string.equalsIgnoreCase("on")) {
            this.debugLevel = 4;
        } else if (string.equalsIgnoreCase("off")) {
            this.debugLevel = 0;
        } else if (string.equals("*")) {
            this.debugLevel = 4;
        } else {
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (this.debugName.startsWith(string)) {
                this.debugLevel = 4;
            }
        }
    }

    public void destroy() {
        this.finalize();
    }

    protected void finalize() {
        Map map = debugMap;
        synchronized (map) {
            debugMap.remove(this.debugName);
        }
        Debug debug = this;
        synchronized (debug) {
            if (this.debugFile == null) {
                return;
            }
            this.debugLevel = 0;
            this.debugFile.flush();
            this.debugFile.close();
            this.debugFile = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

