/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.Crypt;
import com.sun.identity.security.ISSecurityPermission;
import com.sun.identity.security.ServerInstanceAction;
import java.security.AccessController;
import java.security.Permission;

public class AdminUtils {
    private static String adminDN = null;
    private static byte[] adminPassword = null;
    private static Debug debug = Debug.getInstance("amSDK");

    public static String getAdminDN() {
        if (Crypt.checkCaller()) {
            ISSecurityPermission iSSecurityPermission = new ISSecurityPermission("access", "adminpassword");
            try {
                if (Crypt.securityManager != null) {
                    Crypt.securityManager.checkPermission((Permission)iSSecurityPermission);
                }
            }
            catch (SecurityException securityException) {
                debug.error("Security Alert: Unauthorized access to Administative password utility: Returning NULL", securityException);
                return null;
            }
        }
        return adminDN;
    }

    public static byte[] getAdminPassword() {
        if (Crypt.checkCaller()) {
            ISSecurityPermission iSSecurityPermission = new ISSecurityPermission("access", "adminpassword");
            try {
                if (Crypt.securityManager != null) {
                    Crypt.securityManager.checkPermission((Permission)iSSecurityPermission);
                }
            }
            catch (SecurityException securityException) {
                debug.error("Security Alert: Unauthorized access to Administative password utility: Returning NULL", securityException);
                return null;
            }
        }
        return AdminUtils.xor(adminPassword);
    }

    private static byte[] xor(byte[] byArray) {
        if (byArray != null) {
            int n = byArray.length;
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = (byte)(byArray[n2] ^ 1);
                ++n2;
            }
            return byArray2;
        }
        return null;
    }

    static {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            ServerInstance serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            if (serverInstance != null) {
                adminDN = serverInstance.getAuthID();
                String string = (String)AccessController.doPrivileged(new ServerInstanceAction(serverInstance));
                adminPassword = AdminUtils.xor(string.getBytes());
            } else {
                debug.error("AdminUtils: server instance not found");
            }
        }
        catch (LDAPServiceException lDAPServiceException) {
            debug.error("AdminUtils: Initialize admin info ", lDAPServiceException);
        }
    }
}

