/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.services.cdm.ClientDetectionInterface;
import com.iplanet.services.cdm.ClientTypesManager;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AMClientDetector {
    private static ClientTypesManager clientManager;
    private static Map attrs;
    private static boolean detectionEnabled;
    private ClientDetectionInterface clientDetector;
    private static ClientDetectionInterface defaultClientDetector;
    private static final String CDM_SERVICE_NAME = "iPlanetAMClientDetection";
    private static final String CDM_CLASS_NAME = "iplanet-am-client-detection-class";
    private static final String DEFAULT_CDM_CLASS_NAME = "com.iplanet.services.cdm.ClientDetectionDefaultImpl";
    private static final String CLIENT_TYPES_MANAGER_CLASS_NAME = "iplanet-am-client-types-manager-class";
    private static final String CDM_ENABLED_ATTR = "iplanet-am-client-detection-enabled";
    private static Debug debug;
    private static String ClientTypesManagerImpl;
    private static String clientDetectionClass;
    private static SSOToken adminToken;
    private static boolean servicePassed;

    public AMClientDetector() {
        this.clientDetector = defaultClientDetector;
    }

    public AMClientDetector(String string) {
        if (string != null) {
            try {
                this.clientDetector = (ClientDetectionInterface)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                this.clientDetector = defaultClientDetector;
            }
        } else {
            this.clientDetector = defaultClientDetector;
        }
    }

    public AMClientDetector(ClientDetectionInterface clientDetectionInterface) {
        this.clientDetector = clientDetectionInterface;
    }

    public String getClientType(HttpServletRequest httpServletRequest) {
        debug.message("AMClientDetector.getClientType()");
        if (detectionEnabled && this.clientDetector != null) {
            try {
                String string = this.clientDetector.getClientType(httpServletRequest);
                if (debug.messageEnabled()) {
                    debug.message("AMClientDetector: Client Type:" + string);
                }
                return string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = clientManager.getDefaultClientType();
        if (debug.messageEnabled()) {
            debug.message("AMClientDetector:default Client Type:" + string);
        }
        if (string == null || string.length() == 0) {
            string = "genericHTML";
        }
        return string;
    }

    public String detectionEnabled() {
        return detectionEnabled ? "true" : "false";
    }

    public static ClientTypesManager getClientTypesManagerInstance() {
        return clientManager;
    }

    private static void initClientTypesManager() {
        if (ClientTypesManagerImpl != null && ClientTypesManagerImpl.length() > 0) {
            try {
                clientManager = (ClientTypesManager)Class.forName(ClientTypesManagerImpl).newInstance();
            }
            catch (Exception exception) {
                clientManager = new DefaultClientTypesManager();
            }
        } else {
            clientManager = new DefaultClientTypesManager();
        }
        clientManager.initManager();
    }

    private static void getServiceSchemaManager() {
        try {
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager(CDM_SERVICE_NAME, adminToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            attrs = serviceSchema.getAttributeDefaults();
        }
        catch (Exception exception) {
            debug.error("AMClientDetector.static: ", exception);
            servicePassed = false;
            return;
        }
    }

    private static void getClientAttributes() {
        if (attrs != null) {
            String string = Misc.getMapAttr(attrs, CDM_ENABLED_ATTR);
            detectionEnabled = string != null && string.equalsIgnoreCase("true");
            if (debug.messageEnabled()) {
                debug.message("AMClientDetector: ClientDetection enable" + detectionEnabled);
            }
            clientDetectionClass = Misc.getMapAttr(attrs, CDM_CLASS_NAME);
            ClientTypesManagerImpl = Misc.getMapAttr(attrs, CLIENT_TYPES_MANAGER_CLASS_NAME);
        }
    }

    private static SSOToken getInternalToken() {
        Object var0 = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            adminToken = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
        }
        catch (SSOException sSOException) {
            debug.error("AMClientDetector.static: ", sSOException);
        }
        return adminToken;
    }

    private static void executeClientDetector() {
        if (clientDetectionClass != null && clientDetectionClass.length() != 0) {
            try {
                defaultClientDetector = (ClientDetectionInterface)Class.forName(clientDetectionClass).newInstance();
            }
            catch (Exception exception) {
                debug.error("Error instantiating Client Detector", exception);
                try {
                    defaultClientDetector = (ClientDetectionInterface)Class.forName(DEFAULT_CDM_CLASS_NAME).newInstance();
                }
                catch (Exception exception2) {
                    debug.error("No CDM Class found", exception2);
                }
            }
        }
    }

    public static boolean isServicePassed() {
        return servicePassed;
    }

    static {
        debug = Debug.getInstance("amClientDetection");
        ClientTypesManagerImpl = null;
        clientDetectionClass = null;
        adminToken = null;
        servicePassed = true;
        adminToken = AMClientDetector.getInternalToken();
        AMClientDetector.getServiceSchemaManager();
        if (servicePassed) {
            AMClientDetector.getClientAttributes();
            AMClientDetector.initClientTypesManager();
            AMClientDetector.executeClientDetector();
        }
    }
}

