/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.services.util.Base64;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.LogManager;

public class RemoteFormatter
extends Formatter {
    private static LogManager manager = LogManagerUtil.getLogManager();

    public String format(java.util.logging.LogRecord logRecord) {
        String string = logRecord.getLoggerName();
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        String string2 = (String)map.get("LoggedBySid");
        if (string2 == null) {
            if (Debug.warningEnabled()) {
                Debug.warning("RemoteFormatter : returning null because logRecord doesn't have loggedBySid");
            }
            return null;
        }
        Object[] objectArray = logRecord.getParameters();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<logRecWrite><log logName=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" sid=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\"></log><logRecord><level>");
        stringBuffer.append(logRecord.getLevel().intValue());
        stringBuffer.append("</level><recMsg>");
        String string3 = this.formatMessage(logRecord);
        string3 = Base64.encode((byte[])string3.getBytes());
        stringBuffer.append(string3);
        stringBuffer.append("</recMsg>");
        Map map2 = ((LogRecord)logRecord).getLogInfoMap();
        if (map2 != null) {
            Set set = map2.keySet();
            Iterator iterator = set.iterator();
            stringBuffer.append("<logInfoMap>");
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                stringBuffer.append("<logInfo> <infoKey>");
                stringBuffer.append(string4);
                stringBuffer.append("</infoKey><infoValue>");
                String string5 = (String)map2.get(string4);
                if (string4.equalsIgnoreCase("Data")) {
                    string5 = Base64.encode((byte[])string5.getBytes());
                }
                stringBuffer.append(string5);
                stringBuffer.append("</infoValue></logInfo>");
            }
            stringBuffer.append("</logInfoMap>");
        }
        if (objectArray != null && objectArray.length > 0) {
            stringBuffer.append("<parameters>");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("<parameter><paramIndex>");
                stringBuffer.append(String.valueOf(n));
                stringBuffer.append("</paramIndex><paramValue>");
                stringBuffer.append(objectArray[n].toString());
                stringBuffer.append("</paramValue></parameter>");
                ++n;
            }
            stringBuffer.append("</parameters>");
        }
        stringBuffer.append("</logRecord></logRecWrite>");
        if (Debug.messageEnabled()) {
            Debug.message("RemoteFormatter: XML Req string = " + stringBuffer);
        }
        return stringBuffer.toString();
    }
}

