/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.log.ConnectionException;
import com.iplanet.log.DriverLoadException;
import com.iplanet.log.NullLocationException;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.handlers.FormatterInitException;
import com.sun.identity.log.spi.Debug;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DBHandler
extends Handler {
    private LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String driver;
    private String databaseURL;
    private Connection conn = null;
    private String tableName;
    private Formatter formatter;
    private String userName;
    private String password;
    private int recCount = 0;
    private int recCountLimit;
    private int recMaxDBMem = 2;
    private String[] recordBuffer;
    private Timer bufferTimer;
    private boolean timeBufferingEnabled = false;
    private boolean connectionToDBLost = false;
    private boolean isMySQL = false;
    static /* synthetic */ Class class$com$sun$identity$log$handlers$DBHandler;

    private void configure() throws NullLocationException, FormatterInitException {
        String string;
        String string2 = (class$com$sun$identity$log$handlers$DBHandler == null ? (class$com$sun$identity$log$handlers$DBHandler = DBHandler.class$("com.sun.identity.log.handlers.DBHandler")) : class$com$sun$identity$log$handlers$DBHandler).getName();
        this.setLevel(Level.INFO);
        this.setFilter(null);
        try {
            this.setEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(this.tableName + ":DBHandler: unsupportedEncodingException ", unsupportedEncodingException);
        }
        String string3 = this.lmanager.getProperty("iplanet-am-logging-buffer-size");
        String string4 = this.lmanager.getProperty("sun-am-logging-db-max-in-mem");
        if (string4 != null && string4.length() > 0) {
            try {
                this.recMaxDBMem = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.warning(this.tableName + ":DBHandler:recMaxDBMem (" + string4 + "): NumberFormatException ", numberFormatException);
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler: Setting Max DB Mem Buffer Size to 2x (" + 2 * this.recCountLimit + ") the Buffer Size (" + this.recCountLimit + ")");
                }
                this.recMaxDBMem = 2 * this.recCountLimit;
            }
        } else {
            Debug.warning(this.tableName + ":DBHandler: Invalid buffer size: " + string3);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Defaulting Max DB Mem Buffer Size " + "to 2x Buffer Size");
            }
            this.recMaxDBMem = 2 * this.recCountLimit;
        }
        if (this.recMaxDBMem < this.recCountLimit) {
            Debug.warning(this.tableName + ":DBHandler:Maximum DB memory buffer size < Buffer Size, " + "setting to buffer size (" + this.recCountLimit + ")");
            this.recMaxDBMem = this.recCountLimit;
        }
        if (string3 != null && string3.length() > 0) {
            try {
                this.recCountLimit = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.warning(this.tableName + ":DBHandler: NumberFormatException ", numberFormatException);
                if (Debug.messageEnabled()) {
                    Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
                }
                this.recCountLimit = 1;
            }
        } else {
            Debug.warning(this.tableName + ":DBHandler: Invalid buffer size: " + string3);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Setting buffer size to 1");
            }
            this.recCountLimit = 1;
        }
        if ((string = this.lmanager.getProperty("iplanet-am-logging-time-buffering-status")) != null && string.equalsIgnoreCase("ON")) {
            this.timeBufferingEnabled = true;
        }
        this.databaseURL = this.lmanager.getProperty("iplanet-am-logging-location");
        if (this.databaseURL == null || this.databaseURL.length() == 0) {
            throw new NullLocationException("Database URL location is null");
        }
        String string5 = LogManager.FORMATTER;
        if (string5 == null || string5.length() == 0) {
            throw new FormatterInitException("Unable To Initialize DBFormatter");
        }
        this.userName = this.lmanager.getProperty("iplanet-am-logging-db-user");
        if (this.userName == null || this.userName.length() == 0) {
            throw new NullLocationException("userName is null");
        }
        this.password = this.lmanager.getProperty("iplanet-am-logging-db-password");
        if (this.password == null || this.password.length() == 0) {
            throw new NullLocationException("password not provided");
        }
        this.driver = this.lmanager.getProperty("iplanet-am-logging-db-driver");
        if (this.driver == null || this.driver.length() == 0) {
            throw new NullLocationException("driver not provided");
        }
        if (this.driver.toLowerCase().indexOf("oracle") != -1) {
            this.isMySQL = false;
        } else if (this.driver.toLowerCase().indexOf("mysql") != -1) {
            this.isMySQL = true;
        } else {
            this.isMySQL = false;
            Debug.warning(this.tableName + ":DBHandler:configure:assuming driver: '" + this.driver + "' is Oracle-compatible.");
        }
        try {
            Class<?> clazz = Class.forName(string5);
            this.formatter = (Formatter)clazz.newInstance();
            this.setFormatter(this.formatter);
        }
        catch (Exception exception) {
            Debug.error(this.tableName + ":DBHandler: Couldnot load Formatter", exception);
            throw new FormatterInitException("Unable To Initialize DBFormatter " + exception.getMessage());
        }
    }

    private void connectToDatabase(String string, String string2) throws SQLException, ClassNotFoundException, ConnectionException, DriverLoadException {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.databaseURL, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error(this.tableName + ":DBHandler: ClassNotFoundException ", classNotFoundException);
            throw new DriverLoadException(classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            Debug.error(this.tableName + ":DBHandler: ConnectionException (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            throw new ConnectionException(sQLException.getMessage());
        }
    }

    private void reconnectToDatabase() throws ConnectionException, DriverLoadException {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.databaseURL, this.userName, this.password);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DriverLoadException(classNotFoundException.getMessage());
        }
        catch (SQLException sQLException) {
            Debug.error(this.tableName + ":DBHandler:reconnect (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            throw new ConnectionException(sQLException.getMessage());
        }
    }

    public DBHandler(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.tableName = string = string.replace('.', '_');
        try {
            this.configure();
        }
        catch (NullLocationException nullLocationException) {
            Debug.error(string + ":DBHandler: Null Location", nullLocationException);
        }
        catch (FormatterInitException formatterInitException) {
            Debug.error(string + ":DBHandler: Unable to Initialize formatter", formatterInitException);
        }
        String string2 = this.lmanager.getProperty("com.iplanet.am.logstatus");
        if (Debug.messageEnabled()) {
            Debug.message("DBHandler:tableName = " + string + ", LOG_STATUS = " + string2);
        }
        if (string2 != null & !string2.startsWith("INACTIVE")) {
            this.connectionToDBLost = true;
            try {
                this.connectToDatabase(this.userName, this.password);
                this.connectionToDBLost = false;
                this.createTable(string);
            }
            catch (SQLException sQLException) {
                Debug.error(string + ":DBHandler: sql operation unsuccessful (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.error(string + ":DBHandler: Class not found", classNotFoundException);
            }
            catch (ConnectionException connectionException) {
                Debug.error(string + ":DBHandler: Could not connect to database" + connectionException.getMessage());
            }
            catch (DriverLoadException driverLoadException) {
                Debug.error(string + ":DBHandler: Could not load driver", driverLoadException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.error(string + ":DBHandler: Unsupported Encoding: " + unsupportedEncodingException.getMessage());
            }
            this.connectionToDBLost = false;
        }
        this.recordBuffer = new String[this.recMaxDBMem + 1];
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.recordBuffer[this.recCount] = string = this.getFormatter().format(logRecord);
        ++this.recCount;
        if (this.recCount >= this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler:.publish(): got " + this.recCount + " records, writing all");
            }
            this.flush();
        }
    }

    private String getColString() {
        String string = this.getFormatter().getHead(this);
        if (Debug.messageEnabled()) {
            Debug.message("cols = " + string);
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("insert into ").append(this.tableName).append(" (").append(string).append(")").append(" values (");
        return stringBuffer.toString();
    }

    public synchronized void flush() {
        block63: {
            String string;
            block58: {
                if (this.recCount <= 0) {
                    if (Debug.messageEnabled()) {
                        Debug.message(this.tableName + ":DBHandler:flush: no records in buffer to write");
                    }
                    return;
                }
                string = this.getTableName();
                if (string == null) {
                    Debug.error(string + ":DBHandler:flush:NullLocationException: table name is null");
                    this.recCount = 0;
                    return;
                }
                if (this.conn == null || this.connectionToDBLost) {
                    try {
                        this.reconnectToDatabase();
                        Debug.error(string + ":DBHandler:flush:reconnectToDatabase successful.");
                    }
                    catch (DriverLoadException driverLoadException) {
                        Debug.error(string + ":DBHandler:flush:reconnectToDatabase:DLE: " + driverLoadException.getMessage());
                        if (this.recCount > this.recMaxDBMem) {
                            Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                            this.recCount = 0;
                        }
                        throw new AMLogException("Could not load DB driver '" + this.driver + "'");
                    }
                    catch (ConnectionException connectionException) {
                        Debug.error(string + ":DBHandler:flush:reconnectToDatabase:CE: " + connectionException.getMessage());
                        if (this.recCount > this.recMaxDBMem) {
                            Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                            this.recCount = 0;
                        }
                        throw new AMLogException("Connection to DB failed");
                    }
                    this.connectionToDBLost = false;
                    try {
                        this.createTable(string);
                    }
                    catch (SQLException sQLException) {
                        if (Debug.messageEnabled()) {
                            Debug.message(string + ":DBHandler:flush:reconnect:cTable:SQLE (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!Debug.messageEnabled()) break block58;
                        Debug.message(string + ":DBHandler:flush:reconnect:cTable:UE: " + unsupportedEncodingException.getMessage());
                    }
                }
            }
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
            }
            catch (SQLException sQLException) {
                block60: {
                    block59: {
                        Debug.error(string + ":DBHandler:flush:cStatement:SQLE (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                        try {
                            this.conn.close();
                        }
                        catch (SQLException sQLException2) {
                            if (!Debug.messageEnabled()) break block59;
                            Debug.error(string + ":DBHandler:flush:cStatement:close:SQLE (" + sQLException2.getErrorCode() + ")" + sQLException2.getMessage());
                        }
                    }
                    this.connectionToDBLost = true;
                    try {
                        this.reconnectToDatabase();
                        Debug.error(string + ":DBHandler:flush:cStatement:reconnect successful.");
                    }
                    catch (DriverLoadException driverLoadException) {
                        Debug.error(string + ":DBHandler:flush:cStatement:reconnect:DLE: " + driverLoadException.getMessage());
                        if (this.recCount > this.recMaxDBMem) {
                            Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                            this.recCount = 0;
                        }
                        throw new AMLogException("Could not load DB driver '" + this.driver + "'");
                    }
                    catch (ConnectionException connectionException) {
                        Debug.error(string + ":DBHandler:flush:cStatement:reconnect:CE: " + connectionException.getMessage());
                        if (this.recCount > this.recMaxDBMem) {
                            Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                            this.recCount = 0;
                        }
                        throw new AMLogException("Connection to DB failed");
                    }
                    this.connectionToDBLost = false;
                    try {
                        this.createTable(string);
                    }
                    catch (SQLException sQLException3) {
                        if (Debug.messageEnabled()) {
                            Debug.message(string + ":DBHandler:flush:cStatement:reconnect:cTable:SQLE (" + sQLException3.getErrorCode() + "): " + sQLException3.getMessage());
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        if (!Debug.messageEnabled()) break block60;
                        Debug.message(string + ":DBHandler:flush:cStatement:reconnect:cTable:UE: " + unsupportedEncodingException.getMessage());
                    }
                }
                try {
                    statement = this.conn.createStatement();
                }
                catch (SQLException sQLException4) {
                    Debug.error(string + ":DBHandler:flush:cStatement:reconnect:cSt:SQLE (" + sQLException4.getErrorCode() + "): " + sQLException4.getMessage());
                    throw new AMLogException("createStatement failure");
                }
            }
            String string2 = null;
            int n = 0;
            while (n < this.recCount) {
                string2 = this.recordBuffer[n];
                if (Debug.messageEnabled()) {
                    Debug.message("values = " + string2);
                }
                StringBuffer stringBuffer = new StringBuffer(2000);
                stringBuffer.append(this.getColString()).append(string2).append(")");
                String string3 = stringBuffer.toString();
                if (Debug.messageEnabled()) {
                    Debug.message(string + ":DBHandler:insertString is: " + string3);
                }
                try {
                    statement.executeUpdate(string3);
                }
                catch (SQLException sQLException) {
                    int n2 = sQLException.getErrorCode();
                    boolean bl = false;
                    if (Debug.messageEnabled()) {
                        Debug.message(string + "DBHandler:execute:SQLException: insertStr = " + string3);
                        Debug.error(string + ":DBHandler:execute:SQLException (" + n2 + "): " + sQLException.getMessage());
                    }
                    if (this.isMySQL && n2 == 1146 || !this.isMySQL && n2 == 942) {
                        try {
                            this.createTable(string);
                        }
                        catch (SQLException sQLException5) {
                            Debug.error(string + ":DBHandler:flush:execUpdate:cTable:SQLE (" + sQLException5.getErrorCode() + "): " + sQLException5.getMessage());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Debug.error(string + ":DBHandler:flush:execUpdate:cTable:UE: " + unsupportedEncodingException.getMessage());
                        }
                        try {
                            statement.executeUpdate(string3);
                        }
                        catch (SQLException sQLException6) {
                            Debug.error(string + ":DBHandler:flush:execUpdate:exUpdate:SQLE (" + sQLException6.getErrorCode() + "): " + sQLException6.getMessage());
                            throw new AMLogException("executeUpdate failure");
                        }
                    }
                    if (this.isMySQL && n2 == 0 || !this.isMySQL && (n2 == 17002 || n2 == 17410)) {
                        block62: {
                            try {
                                this.conn.close();
                            }
                            catch (SQLException sQLException7) {
                                if (!Debug.messageEnabled()) break block62;
                                Debug.message(string + ":DBHandler:flush:execUpdate:close:SQLE (" + sQLException7.getErrorCode() + "): " + sQLException7.getMessage());
                            }
                        }
                        this.connectionToDBLost = true;
                        try {
                            this.reconnectToDatabase();
                            Debug.error(string + ":DBHandler:flush:execUpdate:reconnect successful.");
                        }
                        catch (DriverLoadException driverLoadException) {
                            if (Debug.messageEnabled()) {
                                Debug.message(string + ":DBHandler:flush:execUpdate:reconnect:DLE: " + driverLoadException.getMessage());
                            }
                            if (this.recCount > this.recMaxDBMem) {
                                Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                                this.recCount = 0;
                            }
                            throw new AMLogException("Reconnection to DB failed");
                        }
                        catch (ConnectionException connectionException) {
                            if (Debug.messageEnabled()) {
                                Debug.message(string + ":DBHandler:flush:execUpdate:reconnect:CE: " + connectionException.getMessage());
                            }
                            if (this.recCount > this.recMaxDBMem) {
                                Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                                this.recCount = 0;
                            }
                            throw new AMLogException("Reconnection to DB failed");
                        }
                        this.connectionToDBLost = false;
                        try {
                            this.createTable(string);
                            statement = this.conn.createStatement();
                            statement.executeUpdate(string3);
                        }
                        catch (SQLException sQLException8) {
                            Debug.error(string + ":DBHandler:flush:executeUpd:reconnect:stmt:SQE: (" + sQLException8.getErrorCode() + "): " + sQLException8.getMessage());
                            if (this.recCount > this.recMaxDBMem) {
                                Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                                this.recCount = 0;
                            }
                            throw new AMLogException("executeUpdate failure");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Debug.error(string + ":DBHandler:flush:execUpd:reconnect:stmt:UE: " + unsupportedEncodingException.getMessage());
                            if (this.recCount > this.recMaxDBMem) {
                                Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                                this.recCount = 0;
                            }
                            throw new AMLogException("executeUpdate failure");
                        }
                    }
                    Debug.error(string + ":DBHandler:flush:executeUpdate failed (" + n2 + "): " + sQLException.getMessage());
                    if (this.recCount > this.recMaxDBMem) {
                        Debug.error(string + ":DBHandler:dropping " + this.recCount + " records.");
                        this.recCount = 0;
                    }
                    throw new AMLogException("executeUpdate failure");
                }
                ++n;
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                if (!Debug.warningEnabled()) break block63;
                Debug.warning(string + ":DBHandler:close:SQLException (" + sQLException.getErrorCode() + "): ", sQLException);
            }
        }
        this.recCount = 0;
    }

    public void close() {
        this.flush();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {
                Debug.error(this.tableName + ":DBHandler: Unable To Close Connection", sQLException);
            }
        }
        this.stopBufferTimer();
    }

    private void setTableName(String string) {
        this.tableName = string;
    }

    private String getTableName() {
        return this.tableName;
    }

    private void createTable(String string) throws SQLException, UnsupportedEncodingException {
        Object object;
        StringBuffer stringBuffer;
        block29: {
            stringBuffer = new StringBuffer();
            String string2 = new String(string.getBytes("UTF-8")).toUpperCase();
            try {
                if (!this.isMySQL) {
                    stringBuffer.append("select count(table_name) from all_tables where table_name=");
                    stringBuffer.append("'").append(new String(string.getBytes("UTF-8")).toUpperCase()).append("'");
                } else {
                    stringBuffer.append("show tables like ");
                    stringBuffer.append("'").append(new String(string.getBytes("UTF-8"))).append("'");
                }
                object = this.conn.createStatement();
                ResultSet resultSet = object.executeQuery(stringBuffer.toString());
                boolean bl = false;
                if (this.isMySQL) {
                    String string3 = null;
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                    }
                    if (string3 != null && string3.equalsIgnoreCase(string)) {
                        bl = true;
                    }
                } else {
                    int n = 0;
                    while (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    if (n == 1) {
                        bl = true;
                    }
                }
                if (!bl) break block29;
                String string4 = null;
                string4 = this.isMySQL ? "show columns from " + string : "select column_name from USER_TAB_COLUMNS where Table_Name = '" + string2 + "'";
                object = this.conn.createStatement();
                try {
                    resultSet = object.executeQuery(string4);
                }
                catch (SQLException sQLException) {
                    Debug.error("DBHandler:createTable: '" + string4 + "'; error (" + sQLException.getErrorCode() + "); msg = " + sQLException.getMessage());
                    return;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                String string5 = null;
                int n2 = 0;
                HashSet<String> hashSet = new HashSet<String>();
                while (resultSet.next()) {
                    string5 = resultSet.getString(1);
                    hashSet.add(string5);
                    int n3 = 0;
                    while (n3 < n) {
                        string5 = resultSet.getString(n3 + 1);
                        ++n3;
                    }
                    ++n2;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                String[] stringArray = this.getAllFields();
                boolean bl2 = false;
                String string6 = null;
                int n4 = 2;
                while (n4 < stringArray.length - 1) {
                    string6 = this.isMySQL ? stringArray[n4] : stringArray[n4].toUpperCase();
                    if (!hashSet.contains(string6)) {
                        if (bl2) {
                            stringBuffer2.append(", ");
                        }
                        stringBuffer2.append(stringArray[n4]).append(" varchar(255)");
                        bl2 = true;
                    }
                    ++n4;
                }
                if (stringBuffer2.length() > 0) {
                    String string7 = "alter table " + string + " add (" + stringBuffer2.toString() + ")";
                    try {
                        object = this.conn.createStatement();
                        object.execute(string7);
                    }
                    catch (SQLException sQLException) {
                        Debug.error("DBHandler:createTable: '" + string7 + "'; error (" + sQLException.getErrorCode() + "); msg = " + sQLException.getMessage());
                    }
                }
                return;
            }
            catch (SQLException sQLException) {
                Debug.error(string + ":DBHandler:createTable:Query:SQLException (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
                throw sQLException;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Debug.error(string + ":DBHandler:createTable:Query:UE: " + unsupportedEncodingException.getMessage());
                throw unsupportedEncodingException;
            }
        }
        stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("create table ").append(new String(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.error(string + ":DBHandler: unsupported encoding exception uee", unsupportedEncodingException);
        }
        stringBuffer.append(" (time varchar(30), ");
        if (this.isMySQL) {
            stringBuffer.append(" data varchar(255), ");
        } else {
            stringBuffer.append(" data varchar(1024), ");
        }
        object = this.getAllFields();
        int n = 0;
        n = 2;
        while (n < ((String[])object).length - 1) {
            stringBuffer.append(object[n]).append(" varchar (255), ");
            ++n;
        }
        stringBuffer.append(object[n]).append(" varchar (255)) ");
        String string8 = stringBuffer.toString();
        try {
            Statement statement = this.conn.createStatement();
            if (Debug.messageEnabled()) {
                Debug.message(string + ":DBHandler: the query string for creating is " + string8);
            }
            statement.executeUpdate(string8);
            statement.close();
        }
        catch (SQLException sQLException) {
            Debug.error(string + ":DBHandler:createTable:Execute:SQLEx (" + sQLException.getErrorCode() + "): " + sQLException.getMessage());
            throw sQLException;
        }
    }

    private String[] getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + stringArray[n2] + "\t";
            ++n2;
        }
        return stringArray;
    }

    private void startTimeBufferingThread() {
        String string = this.lmanager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long l = string != null || string.length() != 0 ? Long.parseLong(string) : 3600L;
        l *= 1000L;
        if (this.bufferTimer == null) {
            this.bufferTimer = new Timer();
            this.bufferTimer.scheduleAtFixedRate((TimerTask)new TimeBufferingTask(), l, l);
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTimer != null) {
            this.bufferTimer.cancel();
            if (Debug.messageEnabled()) {
                Debug.message(this.tableName + ":DBHandler: Buffer Timer Stopped");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TimeBufferingTask
    extends TimerTask {
        private TimeBufferingTask() {
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message(DBHandler.this.tableName + ":DBHandler:TimeBufferingTask.run() called");
            }
            DBHandler.this.flush();
        }
    }
}

